/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.thriftfs;

import com.facebook.thrift.TProcessor;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.server.TServer;
import com.facebook.thrift.server.TThreadPoolServer;
import com.facebook.thrift.transport.TServerSocket;
import com.facebook.thrift.transport.TServerTransport;
import com.facebook.thrift.transport.TTransportFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.thriftfs.api.BlockLocation;
import org.apache.hadoop.thriftfs.api.FileStatus;
import org.apache.hadoop.thriftfs.api.Pathname;
import org.apache.hadoop.thriftfs.api.ThriftHadoopFileSystem;
import org.apache.hadoop.thriftfs.api.ThriftHandle;
import org.apache.hadoop.thriftfs.api.ThriftIOException;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

public class HadoopThriftServer
extends ThriftHadoopFileSystem {
    static int serverPort = 0;
    TServer server = null;

    private ServerSocket createServerSocket(int port) throws IOException {
        try {
            ServerSocket sock = new ServerSocket();
            sock.setReuseAddress(true);
            if (port == 0) {
                sock.bind(null);
                serverPort = sock.getLocalPort();
            } else {
                sock.bind(new InetSocketAddress(port));
            }
            return sock;
        }
        catch (IOException ioe) {
            throw new IOException("Could not create ServerSocket on port " + port + "." + ioe);
        }
    }

    public HadoopThriftServer(String[] args) {
        if (args.length > 0) {
            serverPort = new Integer(args[0]);
        }
        try {
            ServerSocket ssock = this.createServerSocket(serverPort);
            TServerSocket serverTransport = new TServerSocket(ssock);
            HadoopThriftHandler handler = new HadoopThriftHandler("hdfs-thrift-dhruba");
            ThriftHadoopFileSystem.Processor processor = new ThriftHadoopFileSystem.Processor((ThriftHadoopFileSystem.Iface)handler);
            TThreadPoolServer.Options options = new TThreadPoolServer.Options();
            options.minWorkerThreads = 10;
            this.server = new TThreadPoolServer((TProcessor)processor, (TServerTransport)serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), options);
            System.out.println("Starting the hadoop thrift server on port [" + serverPort + "]...");
            HadoopThriftHandler.LOG.info((Object)("Starting the hadoop thrift server on port [" + serverPort + "]..."));
            System.out.flush();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HadoopThriftServer me = new HadoopThriftServer(args);
        me.server.serve();
    }

    public static class HadoopThriftHandler
    implements ThriftHadoopFileSystem.Iface {
        public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.thrift");
        Configuration conf;
        FileSystem fs;
        private long nextId = new Random().nextLong();
        private HashMap<Long, Object> hadoopHash = new HashMap();
        private Daemon inactivityThread = null;
        private static volatile long inactivityPeriod = 3600000L;
        private static volatile long inactivityRecheckInterval = 60000L;
        private static volatile boolean fsRunning = true;
        private static long now;

        public void setOption(String key, String val) {
        }

        static long now() {
            return System.currentTimeMillis();
        }

        public String getVersion() {
            return "0.1";
        }

        public void shutdown(int status) {
            LOG.info((Object)"HadoopThriftServer shutting down.");
            try {
                this.fs.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to close file system");
            }
            Runtime.getRuntime().exit(status);
        }

        public HadoopThriftHandler(String name) {
            this.conf = new Configuration();
            now = HadoopThriftHandler.now();
            try {
                this.inactivityThread = new Daemon((Runnable)new InactivityMonitor());
                this.fs = FileSystem.get((Configuration)this.conf);
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to open hadoop file system...");
                Runtime.getRuntime().exit(-1);
            }
        }

        private static void printStackTrace(Exception e) {
            for (StackTraceElement s : e.getStackTrace()) {
                LOG.error((Object)s);
            }
        }

        private synchronized Object lookup(long id) {
            return this.hadoopHash.get(new Long(id));
        }

        private synchronized long insert(Object o) {
            ++this.nextId;
            this.hadoopHash.put(this.nextId, o);
            return this.nextId;
        }

        private synchronized Object remove(long id) {
            return this.hadoopHash.remove(new Long(id));
        }

        public synchronized void setInactivityTimeoutPeriod(long periodInSeconds) {
            inactivityPeriod = periodInSeconds * 1000L;
            if (inactivityRecheckInterval > inactivityPeriod) {
                inactivityRecheckInterval = inactivityPeriod;
            }
        }

        public ThriftHandle create(Pathname path) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("create: " + path));
                FSDataOutputStream out = this.fs.create(new Path(path.pathname));
                long id = this.insert(out);
                ThriftHandle obj = new ThriftHandle(id);
                LOG.debug((Object)("created: " + path + " id: " + id));
                return obj;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public ThriftHandle createFile(Pathname path, short mode, boolean overwrite, int bufferSize, short replication, long blockSize) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("create: " + path + " permission: " + mode + " overwrite: " + overwrite + " bufferSize: " + bufferSize + " replication: " + replication + " blockSize: " + blockSize));
                FSDataOutputStream out = this.fs.create(new Path(path.pathname), new FsPermission(mode), overwrite, bufferSize, replication, blockSize, null);
                long id = this.insert(out);
                ThriftHandle obj = new ThriftHandle(id);
                LOG.debug((Object)("created: " + path + " id: " + id));
                return obj;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public ThriftHandle open(Pathname path) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("open: " + path));
                FSDataInputStream out = this.fs.open(new Path(path.pathname));
                long id = this.insert(out);
                ThriftHandle obj = new ThriftHandle(id);
                LOG.debug((Object)("opened: " + path + " id: " + id));
                return obj;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public ThriftHandle append(Pathname path) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("append: " + path));
                FSDataOutputStream out = this.fs.append(new Path(path.pathname));
                long id = this.insert(out);
                ThriftHandle obj = new ThriftHandle(id);
                LOG.debug((Object)("appended: " + path + " id: " + id));
                return obj;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public boolean write(ThriftHandle tout, String data) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("write: " + tout.id));
                FSDataOutputStream out = (FSDataOutputStream)this.lookup(tout.id);
                byte[] tmp = data.getBytes("UTF-8");
                out.write(tmp, 0, tmp.length);
                LOG.debug((Object)("wrote: " + tout.id));
                return true;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public String read(ThriftHandle tout, long offset, int length) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("read: " + tout.id + " offset: " + offset + " length: " + length));
                FSDataInputStream in = (FSDataInputStream)this.lookup(tout.id);
                if (in.getPos() != offset) {
                    in.seek(offset);
                }
                byte[] tmp = new byte[length];
                int numbytes = in.read(offset, tmp, 0, length);
                LOG.debug((Object)("read done: " + tout.id));
                return new String(tmp, 0, numbytes, "UTF-8");
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public boolean rm(Pathname path, boolean recursive) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("rm: " + path + " recursive: " + recursive));
                boolean ret = this.fs.delete(new Path(path.pathname), recursive);
                LOG.debug((Object)("rm: " + path));
                return ret;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public boolean rename(Pathname path, Pathname dest) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("rename: " + path + " destination: " + dest));
                boolean ret = this.fs.rename(new Path(path.pathname), new Path(dest.pathname));
                LOG.debug((Object)("rename: " + path));
                return ret;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public boolean close(ThriftHandle tout) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("close: " + tout.id));
                Object obj = this.remove(tout.id);
                if (obj instanceof FSDataOutputStream) {
                    FSDataOutputStream out = (FSDataOutputStream)obj;
                    out.close();
                } else if (obj instanceof FSDataInputStream) {
                    FSDataInputStream in = (FSDataInputStream)obj;
                    in.close();
                } else {
                    throw new ThriftIOException("Unknown thrift handle.");
                }
                LOG.debug((Object)("closed: " + tout.id));
                return true;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public boolean mkdirs(Pathname path) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("mkdirs: " + path));
                boolean ret = this.fs.mkdirs(new Path(path.pathname));
                LOG.debug((Object)("mkdirs: " + path));
                return ret;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public boolean exists(Pathname path) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("exists: " + path));
                boolean ret = this.fs.exists(new Path(path.pathname));
                LOG.debug((Object)("exists done: " + path));
                return ret;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public FileStatus stat(Pathname path) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("stat: " + path));
                org.apache.hadoop.fs.FileStatus stat = this.fs.getFileStatus(new Path(path.pathname));
                LOG.debug((Object)("stat done: " + path));
                return new FileStatus(stat.getPath().toString(), stat.getLen(), stat.isDir(), stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getPermission().toString(), stat.getOwner(), stat.getGroup());
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public List<FileStatus> listStatus(Pathname path) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("listStatus: " + path));
                org.apache.hadoop.fs.FileStatus[] stat = this.fs.listStatus(new Path(path.pathname));
                LOG.debug((Object)("listStatus done: " + path));
                LinkedList<FileStatus> value = new LinkedList<FileStatus>();
                for (int i = 0; i < stat.length; ++i) {
                    FileStatus tmp = new FileStatus(stat[i].getPath().toString(), stat[i].getLen(), stat[i].isDir(), stat[i].getReplication(), stat[i].getBlockSize(), stat[i].getModificationTime(), stat[i].getPermission().toString(), stat[i].getOwner(), stat[i].getGroup());
                    value.add(tmp);
                }
                return value;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public void chmod(Pathname path, short mode) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("chmod: " + path + " mode " + mode));
                this.fs.setPermission(new Path(path.pathname), new FsPermission(mode));
                LOG.debug((Object)("chmod done: " + path));
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public void chown(Pathname path, String owner, String group) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("chown: " + path + " owner: " + owner + " group: " + group));
                this.fs.setOwner(new Path(path.pathname), owner, group);
                LOG.debug((Object)("chown done: " + path));
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public void setReplication(Pathname path, short repl) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("setrepl: " + path + " replication factor: " + repl));
                this.fs.setReplication(new Path(path.pathname), repl);
                LOG.debug((Object)("setrepl done: " + path));
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        public List<BlockLocation> getFileBlockLocations(Pathname path, long start, long length) throws ThriftIOException {
            try {
                now = HadoopThriftHandler.now();
                LOG.debug((Object)("getFileBlockLocations: " + path));
                org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(new Path(path.pathname));
                org.apache.hadoop.fs.BlockLocation[] stat = this.fs.getFileBlockLocations(status, start, length);
                LOG.debug((Object)("getFileBlockLocations done: " + path));
                LinkedList<BlockLocation> value = new LinkedList<BlockLocation>();
                for (int i = 0; i < stat.length; ++i) {
                    LinkedList<String> hosts = new LinkedList<String>();
                    String[] hostsHdfs = stat[i].getHosts();
                    for (int j = 0; j < hostsHdfs.length; ++j) {
                        hosts.add(hostsHdfs[j]);
                    }
                    LinkedList<String> names = new LinkedList<String>();
                    String[] namesHdfs = stat[i].getNames();
                    for (int j = 0; j < namesHdfs.length; ++j) {
                        names.add(namesHdfs[j]);
                    }
                    BlockLocation tmp = new BlockLocation(hosts, names, stat[i].getOffset(), stat[i].getLength());
                    value.add(tmp);
                }
                return value;
            }
            catch (IOException e) {
                throw new ThriftIOException(e.getMessage());
            }
        }

        class InactivityMonitor
        implements Runnable {
            InactivityMonitor() {
            }

            @Override
            public void run() {
                while (fsRunning) {
                    try {
                        if (HadoopThriftHandler.now() > now + inactivityPeriod) {
                            LOG.warn((Object)("HadoopThriftServer Inactivity period of " + inactivityPeriod + " expired... Stopping Server."));
                            HadoopThriftHandler.this.shutdown(-1);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    }
                    try {
                        Thread.sleep(inactivityRecheckInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

