/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.ShellParser;

public class SMARTParser
extends ShellParser {
    String[] devices;

    public SMARTParser() {
        String devicesStr = Environment.getProperty("disks.list");
        System.out.println("skato " + devicesStr);
        if (devicesStr != null) {
            this.devices = devicesStr.split(",\\s*");
        }
    }

    @Override
    public EventRecord query(String device) throws Exception {
        String[] var;
        String conf = Environment.getProperty("disks." + device + ".source");
        StringBuffer sb = conf == null ? Environment.runCommand("sudo smartctl --all " + device) : Environment.runCommand("cat " + conf);
        EventRecord retval = new EventRecord(InetAddress.getLocalHost().getCanonicalHostName(), InetAddress.getAllByName(InetAddress.getLocalHost().getHostName()), Calendar.getInstance(), "SMART", "Unknown", conf == null ? "sudo smartctl --all " + device : "file " + conf, "-");
        retval.set("model", this.findPattern("Device\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("serial", this.findPattern("Serial\\s+Number\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("firmware", this.findPattern("Firmware\\s+Version\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("capacity", this.findPattern("User\\s+Capacity\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("status", this.findPattern("SMART\\s*Health\\s*Status:\\s*(.*)", sb.toString(), 1));
        retval.set("current_temperature", this.findPattern("Current\\s+Drive\\s+Temperature\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("trip_temperature", this.findPattern("Drive\\s+Trip\\s+Temperature\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("start_stop_count", this.findPattern("start\\s+stop\\s+count\\s*:\\s*(\\d*)", sb.toString(), 1));
        for (String s : var = new String[]{"read", "write", "verify"}) {
            retval.set(s + "_ecc_fast", this.findPattern(s + "\\s*:\\s*(\\d*)", sb.toString(), 1));
            retval.set(s + "_ecc_delayed", this.findPattern(s + "\\s*:\\s*(\\d+\\s+){1}(\\d+)", sb.toString(), 2));
            retval.set(s + "_rereads", this.findPattern(s + "\\s*:\\s*(\\d+\\s+){2}(\\d+)", sb.toString(), 2));
            retval.set(s + "_GBs", this.findPattern(s + "\\s*:\\s*(\\d+\\s+){5}(\\d+.?\\d*)", sb.toString(), 2));
            retval.set(s + "_uncorrected", this.findPattern(s + "\\s*:\\s*(\\d+\\s+){5}(\\d+.?\\d*){1}\\s+(\\d+)", sb.toString(), 3));
        }
        retval.set("model", this.findPattern("Device\\s*Model\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("serial", this.findPattern("Serial\\s+number\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("protocol", this.findPattern("Transport\\s+protocol\\s*:\\s*(.*)", sb.toString(), 1));
        retval.set("status", "PASSED".equalsIgnoreCase(this.findPattern("test\\s*result\\s*:\\s*(.*)", sb.toString(), 1)) ? "OK" : "FAILED");
        this.readColumns(retval, sb);
        return retval;
    }

    private EventRecord readColumns(EventRecord er, StringBuffer sb) {
        Pattern pattern = Pattern.compile("^\\s{0,2}(\\d{1,3}\\s+.*)$", 8);
        Matcher matcher = pattern.matcher(sb);
        while (matcher.find()) {
            String[] tokens = matcher.group(1).split("\\s+");
            boolean failed = false;
            if (!tokens[8].equals("-")) {
                failed = true;
            }
            er.set(tokens[1].toLowerCase(), (failed ? "FAILED:" : "") + tokens[9]);
        }
        return er;
    }

    @Override
    public EventRecord[] monitor() {
        ArrayList<EventRecord> recs = new ArrayList<EventRecord>();
        for (String device : this.devices) {
            try {
                recs.add(this.query(device));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EventRecord[] T = new EventRecord[recs.size()];
        return recs.toArray(T);
    }

    @Override
    public String getInfo() {
        String retval = "S.M.A.R.T. disk attributes parser for disks ";
        for (String device : this.devices) {
            retval = retval + device + " ";
        }
        return retval;
    }
}

