/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.apache.hadoop.contrib.failmon.Anonymizer;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.HadoopLogParser;
import org.apache.hadoop.contrib.failmon.LocalStore;
import org.apache.hadoop.contrib.failmon.LogParser;
import org.apache.hadoop.contrib.failmon.SerializedRecord;
import org.apache.hadoop.contrib.failmon.SystemLogParser;

public class OfflineAnonymizer {
    LogType logtype;
    File logfile;
    LogParser parser;

    public OfflineAnonymizer(LogType logtype, String filename) {
        this.logfile = new File(filename);
        if (!this.logfile.exists()) {
            System.err.println("Input file does not exist!");
            System.exit(0);
        }
        this.parser = logtype == LogType.HADOOP ? new HadoopLogParser(filename) : new SystemLogParser(filename);
    }

    public void anonymize() throws Exception {
        EventRecord er = null;
        SerializedRecord sr = null;
        BufferedWriter bfw = new BufferedWriter(new FileWriter(this.logfile.getName() + ".anonymized"));
        System.out.println("Anonymizing log records...");
        while ((er = this.parser.getNext()) != null) {
            if (!er.isValid()) continue;
            sr = new SerializedRecord(er);
            Anonymizer.anonymize(sr);
            bfw.write(LocalStore.pack(sr).toString());
            bfw.write(10);
        }
        bfw.flush();
        bfw.close();
        System.out.println("Anonymized log records written to " + this.logfile.getName() + ".anonymized");
        System.out.println("Compressing output file...");
        LocalStore.zipCompress(this.logfile.getName() + ".anonymized");
        System.out.println("Compressed output file written to " + this.logfile.getName() + ".anonymized" + ".zip");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: OfflineAnonymizer <log_type> <filename>");
            System.out.println("where <log_type> is either \"hadoop\" or \"system\" and <filename> is the path to the log file");
            System.exit(0);
        }
        LogType logtype = null;
        if (args[0].equalsIgnoreCase("-hadoop")) {
            logtype = LogType.HADOOP;
        } else if (args[0].equalsIgnoreCase("-system")) {
            logtype = LogType.SYSTEM;
        } else {
            System.err.println("Invalid first argument.");
            System.exit(0);
        }
        OfflineAnonymizer oa = new OfflineAnonymizer(logtype, args[1]);
        try {
            oa.anonymize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum LogType {
        HADOOP,
        SYSTEM;

    }
}

