/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.ShellParser;

public class NICParser
extends ShellParser {
    String[] nics = Environment.getProperty("nic.list").split(",\\s*");

    @Override
    public EventRecord query(String device) throws UnknownHostException {
        StringBuffer sb = Environment.runCommand("/sbin/ifconfig " + device);
        EventRecord retval = new EventRecord(InetAddress.getLocalHost().getCanonicalHostName(), InetAddress.getAllByName(InetAddress.getLocalHost().getHostName()), Calendar.getInstance(), "NIC", "Unknown", device, "-");
        retval.set("hwAddress", this.findPattern("HWaddr\\s*([\\S{2}:]{17})", sb.toString(), 1));
        retval.set("ipAddress", this.findPattern("inet\\s+addr:\\s*([\\w.?]*)", sb.toString(), 1));
        String tmp = this.findPattern("inet\\s+addr:\\s*([\\w.?]*)", sb.toString(), 1);
        retval.set("status", tmp == null ? "DOWN" : "UP");
        if (tmp != null) {
            retval.set("ipAddress", tmp);
        }
        retval.set("rxPackets", this.findPattern("RX\\s*packets\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("rxErrors", this.findPattern("RX.+errors\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("rxDropped", this.findPattern("RX.+dropped\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("rxOverruns", this.findPattern("RX.+overruns\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("rxFrame", this.findPattern("RX.+frame\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("txPackets", this.findPattern("TX\\s*packets\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("txErrors", this.findPattern("TX.+errors\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("txDropped", this.findPattern("TX.+dropped\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("txOverruns", this.findPattern("TX.+overruns\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("txCarrier", this.findPattern("TX.+carrier\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("collisions", this.findPattern("\\s+collisions\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("rxBytes", this.findPattern("RX\\s*bytes\\s*:\\s*(\\d+)", sb.toString(), 1));
        retval.set("txBytes", this.findPattern("TX\\s*bytes\\s*:\\s*(\\d+)", sb.toString(), 1));
        return retval;
    }

    @Override
    public EventRecord[] monitor() {
        ArrayList<EventRecord> recs = new ArrayList<EventRecord>();
        for (String nic : this.nics) {
            try {
                recs.add(this.query(nic));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        EventRecord[] T = new EventRecord[recs.size()];
        return recs.toArray(T);
    }

    @Override
    public String getInfo() {
        String retval = "ifconfig parser for interfaces: ";
        for (String nic : this.nics) {
            retval = retval + nic + " ";
        }
        return retval;
    }
}

