/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.LocalStore;
import org.apache.hadoop.contrib.failmon.MonitorJob;

public class Executor
implements Runnable {
    public static final int DEFAULT_LOG_INTERVAL = 3600;
    public static final int DEFAULT_POLL_INTERVAL = 360;
    public static int MIN_INTERVAL = 5;
    public static int instances = 0;
    LocalStore lstore;
    ArrayList<MonitorJob> monitors;
    int interval;
    int upload_interval;
    int upload_counter;

    public Executor(Configuration conf) {
        Environment.prepare("conf/failmon.properties");
        if (conf == null) {
            String localTmpDir = System.getProperty("java.io.tmpdir");
            Environment.setProperty("local.tmp.dir", localTmpDir);
        } else {
            String localTmpDir = conf.get("hadoop.tmp.dir");
            String hadoopLogPath = System.getProperty("hadoop.log.dir") + "/" + System.getProperty("hadoop.log.file");
            Environment.setProperty("hadoop.log.file", hadoopLogPath);
            Environment.setProperty("local.tmp.dir", localTmpDir);
        }
        this.monitors = Environment.getJobs();
        this.interval = Environment.getInterval(this.monitors);
        this.upload_interval = 600;
        this.lstore = new LocalStore();
        if (Environment.getProperty("local.upload.interval") != null) {
            this.upload_interval = Integer.parseInt(Environment.getProperty("local.upload.interval"));
        }
        ++instances;
    }

    @Override
    public void run() {
        this.upload_counter = this.upload_interval;
        Environment.logInfo("Failmon Executor thread started successfully.");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.interval * 1000);
                    for (int i = 0; i < this.monitors.size(); ++i) {
                        this.monitors.get((int)i).counter -= this.interval;
                        if (this.monitors.get((int)i).counter > 0) continue;
                        this.monitors.get(i).reset();
                        Environment.logInfo("Calling " + this.monitors.get((int)i).job.getInfo() + "...\t");
                        this.monitors.get((int)i).job.monitor(this.lstore);
                    }
                    this.upload_counter -= this.interval;
                    if (this.upload_counter > 0) continue;
                    this.lstore.upload();
                    this.upload_counter = this.upload_interval;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void cleanup() {
        --instances;
    }
}

