/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.StreamFile;
import org.apache.hadoop.hdfsproxy.ProxyUtil;
import org.apache.hadoop.security.UserGroupInformation;

public class ProxyStreamFile
extends StreamFile {
    private static final long serialVersionUID = 1L;

    protected UserGroupInformation getUGI(HttpServletRequest request, Configuration conf) {
        String userID = (String)request.getAttribute("org.apache.hadoop.hdfsproxy.authorized.userID");
        return ProxyUtil.getProxyUGIFor(userID);
    }

    protected DFSClient getDFSClient(HttpServletRequest request) throws IOException, InterruptedException {
        ServletContext context = this.getServletContext();
        Configuration conf = (Configuration)context.getAttribute("current.conf");
        UserGroupInformation ugi = this.getUGI(request, conf);
        InetSocketAddress nameNodeAddr = (InetSocketAddress)context.getAttribute("name.node.address");
        return JspHelper.getDFSClient((UserGroupInformation)ugi, (InetSocketAddress)nameNodeAddr, (Configuration)conf);
    }
}

