/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.net.NetUtils;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;

public class ProxyHttpServer
extends HttpServer {
    public static final Log LOG = LogFactory.getLog(ProxyHttpServer.class);

    public ProxyHttpServer(InetSocketAddress addr, Configuration conf) throws IOException {
        super("", addr.getHostName(), addr.getPort(), 0 <= addr.getPort(), conf);
    }

    public Connector createBaseListener(Configuration conf) throws IOException {
        String sAddr = conf.get("proxy.http.test.listener.addr");
        if (null == sAddr) {
            SslSocketConnector sslListener = new SslSocketConnector();
            sslListener.setKeystore(conf.get("ssl.server.keystore.location"));
            sslListener.setPassword(conf.get("ssl.server.keystore.password", ""));
            sslListener.setKeyPassword(conf.get("ssl.server.keystore.keypassword", ""));
            sslListener.setKeystoreType(conf.get("ssl.server.keystore.type", "jks"));
            sslListener.setNeedClientAuth(true);
            System.setProperty("javax.net.ssl.trustStore", conf.get("ssl.server.truststore.location", ""));
            System.setProperty("javax.net.ssl.trustStorePassword", conf.get("ssl.server.truststore.password", ""));
            System.setProperty("javax.net.ssl.trustStoreType", conf.get("ssl.server.truststore.type", "jks"));
            return sslListener;
        }
        InetSocketAddress proxyAddr = NetUtils.createSocketAddr((String)sAddr);
        SelectChannelConnector testlistener = new SelectChannelConnector();
        testlistener.setUseDirectBuffers(false);
        testlistener.setHost(proxyAddr.getHostName());
        testlistener.setPort(proxyAddr.getPort());
        return testlistener;
    }
}

