/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class ProxyForwardServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Configuration configuration = null;
    public static final Log LOG = LogFactory.getLog(ProxyForwardServlet.class);

    public void init() throws ServletException {
        ServletContext context = this.getServletContext();
        configuration = (Configuration)context.getAttribute("org.apache.hadoop.hdfsproxy.conf");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext curContext;
        ServletContext dstContext;
        String hostname = request.getServerName();
        String version = configuration.get(hostname);
        if (version == null) {
            String[] strs = hostname.split("[-\\.]");
            version = "/" + strs[0];
        }
        if ((dstContext = (curContext = this.getServletContext()).getContext(version)) == null || "HDFS Proxy Forward".equals(dstContext.getServletContextName())) {
            LOG.error((Object)("Context (" + version + ".war) non-exist or restricted from access"));
            response.sendError(404);
            return;
        }
        LOG.debug((Object)("Request to " + hostname + " is forwarded to version " + version));
        this.forwardRequest(request, response, dstContext, request.getServletPath());
    }

    public void forwardRequest(HttpServletRequest request, HttpServletResponse response, ServletContext context, String pathInfo) throws IOException, ServletException {
        String path = this.buildForwardPath(request, pathInfo);
        RequestDispatcher dispatcher = context.getRequestDispatcher(path);
        if (dispatcher == null) {
            LOG.info((Object)("There was no such dispatcher: " + path));
            response.sendError(204);
            return;
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected String buildForwardPath(HttpServletRequest request, String pathInfo) {
        String path = pathInfo;
        if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        if (request.getQueryString() != null) {
            path = path + "?" + request.getQueryString();
        }
        return path;
    }
}

