/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfsproxy.ProxyFileDataServlet;
import org.apache.hadoop.hdfsproxy.ProxyFilter;
import org.apache.hadoop.hdfsproxy.ProxyHttpServer;
import org.apache.hadoop.hdfsproxy.ProxyListPathsServlet;
import org.apache.hadoop.hdfsproxy.ProxyStreamFile;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;

public class HdfsProxy {
    public static final Log LOG = LogFactory.getLog(HdfsProxy.class);
    private ProxyHttpServer server;
    private InetSocketAddress sslAddr;

    public HdfsProxy(Configuration conf) throws IOException {
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
    }

    private void initialize(Configuration conf) throws IOException {
        this.sslAddr = HdfsProxy.getSslAddr(conf);
        String nn = conf.get("hdfsproxy.dfs.namenode.address");
        if (nn == null) {
            throw new IOException("HDFS NameNode address is not specified");
        }
        InetSocketAddress nnAddr = NetUtils.createSocketAddr((String)nn);
        LOG.info((Object)("HDFS NameNode is at: " + nnAddr.getHostName() + ":" + nnAddr.getPort()));
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("hdfsproxy.https.server.keystore.resource", "ssl-server.xml"));
        sslConf.set("proxy.http.test.listener.addr", conf.get("proxy.http.test.listener.addr"));
        this.server = new ProxyHttpServer(this.sslAddr, sslConf);
        this.server.setAttribute("proxy.https.port", this.server.getPort());
        this.server.setAttribute("name.node.address", nnAddr);
        this.server.setAttribute("current.conf", new Configuration());
        this.server.addGlobalFilter("ProxyFilter", ProxyFilter.class.getName(), null);
        this.server.addServlet("listPaths", "/listPaths/*", ProxyListPathsServlet.class);
        this.server.addServlet("data", "/data/*", ProxyFileDataServlet.class);
        this.server.addServlet("streamFile", "/streamFile/*", ProxyStreamFile.class);
    }

    int getPort() throws IOException {
        return this.server.getPort();
    }

    public void start() throws IOException {
        this.server.start();
        LOG.info((Object)("HdfsProxy server up at: " + this.sslAddr.getHostName() + ":" + this.sslAddr.getPort()));
    }

    public void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server.join();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Got exception shutting down proxy", (Throwable)e);
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static InetSocketAddress getSslAddr(Configuration conf) throws IOException {
        String addr = conf.get("hdfsproxy.https.address");
        if (addr == null) {
            throw new IOException("HdfsProxy address is not specified");
        }
        return NetUtils.createSocketAddr((String)addr);
    }

    public static HdfsProxy createHdfsProxy(String[] argv, Configuration conf) throws IOException {
        if (argv.length > 0) {
            System.err.println("Usage: HdfsProxy");
            return null;
        }
        if (conf == null) {
            conf = new Configuration(false);
            conf.addResource("hdfsproxy-default.xml");
        }
        StringUtils.startupShutdownMessage(HdfsProxy.class, (String[])argv, (Log)LOG);
        HdfsProxy proxy = new HdfsProxy(conf);
        proxy.start();
        return proxy;
    }

    public static void main(String[] argv) throws Exception {
        try {
            HdfsProxy proxy = HdfsProxy.createHdfsProxy(argv, null);
            if (proxy != null) {
                proxy.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            System.exit(-1);
        }
    }
}

