/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;

public class AuthorizationFilter
implements Filter {
    public static final Log LOG = LogFactory.getLog(AuthorizationFilter.class);
    private static final Pattern HDFS_PATH_PATTERN = Pattern.compile("(^hdfs://([\\w\\-]+(\\.)?)+:\\d+|^hdfs://([\\w\\-]+(\\.)?)+)");
    protected static final Pattern HFTP_PATTERN = Pattern.compile("^(/listPaths|/data|/streamFile|/file)$");
    protected String contextPath;
    protected String namenode;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.contextPath = filterConfig.getServletContext().getContextPath();
        Configuration conf = new Configuration(false);
        conf.addResource("hdfsproxy-default.xml");
        conf.addResource("hdfsproxy-site.xml");
        this.namenode = conf.get("fs.default.name");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse rsp = (HttpServletResponse)response;
        HttpServletRequest rqst = (HttpServletRequest)request;
        String userId = this.getUserId(request);
        String groups = this.getGroups(request);
        List<Path> allowedPaths = this.getAllowedPaths(request);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userId);
        String filePath = this.getPathFromRequest(rqst);
        if (filePath == null || !this.checkHdfsPath(filePath, allowedPaths)) {
            String msg = "User " + userId + " (" + groups + ") is not authorized to access path " + filePath;
            LOG.warn((Object)msg);
            rsp.sendError(403, msg);
            return;
        }
        request.setAttribute("authorized.ugi", (Object)ugi);
        chain.doFilter(request, response);
    }

    protected String getUserId(ServletRequest request) {
        return (String)request.getAttribute("org.apache.hadoop.hdfsproxy.authorized.userID");
    }

    protected String getGroups(ServletRequest request) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.getUserId(request));
        return Arrays.toString(ugi.getGroupNames());
    }

    protected List<Path> getAllowedPaths(ServletRequest request) {
        return (List)request.getAttribute("org.apache.hadoop.hdfsproxy.authorized.paths");
    }

    private String getPathFromRequest(HttpServletRequest rqst) {
        String filePath = null;
        String servletPath = rqst.getServletPath();
        if (HFTP_PATTERN.matcher(servletPath).matches()) {
            filePath = rqst.getPathInfo() != null ? rqst.getPathInfo() : "/";
        }
        return filePath;
    }

    public boolean checkHdfsPath(String pathInfo, List<Path> ldapPaths) {
        if (pathInfo == null || pathInfo.length() == 0) {
            LOG.info((Object)"Can't get file path from the request");
            return false;
        }
        for (Path ldapPathVar : ldapPaths) {
            String allowedPath;
            String ldapPath = ldapPathVar.toString();
            if (!(this.isPathQualified(ldapPath) && this.isPathAuthroized(ldapPath) ? pathInfo.startsWith(allowedPath = this.extractPath(ldapPath)) : pathInfo.startsWith(ldapPath))) continue;
            return true;
        }
        return false;
    }

    private String extractPath(String ldapPath) {
        return HDFS_PATH_PATTERN.split(ldapPath)[1];
    }

    private boolean isPathAuthroized(String pathStr) {
        Matcher namenodeMatcher = HDFS_PATH_PATTERN.matcher(pathStr);
        return namenodeMatcher.find() && namenodeMatcher.group().contains(this.namenode);
    }

    private boolean isPathQualified(String pathStr) {
        if (pathStr == null || pathStr.trim().isEmpty()) {
            return false;
        }
        return HDFS_PATH_PATTERN.matcher(pathStr).find();
    }

    public void destroy() {
    }
}

