/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MultiFileInputFormat;
import org.apache.hadoop.mapred.MultiFileSplit;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MultiFileWordCount
extends Configured
implements Tool {
    private void printUsage() {
        System.out.println("Usage : multifilewc <input_dir> <output>");
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            this.printUsage();
            return 1;
        }
        JobConf job = new JobConf(this.getConf(), MultiFileWordCount.class);
        job.setJobName("MultiFileWordCount");
        job.setInputFormat(MyInputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(MapClass.class);
        job.setCombinerClass(LongSumReducer.class);
        job.setReducerClass(LongSumReducer.class);
        FileInputFormat.addInputPaths((JobConf)job, (String)args[0]);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
        JobClient.runJob((JobConf)job);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new MultiFileWordCount(), (String[])args);
        System.exit(ret);
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<WordOffset, Text, Text, LongWritable> {
        private static final LongWritable one = new LongWritable(1L);
        private Text word = new Text();

        public void map(WordOffset key, Text value, OutputCollector<Text, LongWritable> output, Reporter reporter) throws IOException {
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                output.collect((Object)this.word, (Object)one);
            }
        }
    }

    public static class MultiFileLineRecordReader
    implements RecordReader<WordOffset, Text> {
        private MultiFileSplit split;
        private long offset;
        private long totLength;
        private FileSystem fs;
        private int count = 0;
        private Path[] paths;
        private FSDataInputStream currentStream;
        private BufferedReader currentReader;

        public MultiFileLineRecordReader(Configuration conf, MultiFileSplit split) throws IOException {
            this.split = split;
            this.fs = FileSystem.get((Configuration)conf);
            this.paths = split.getPaths();
            this.totLength = split.getLength();
            this.offset = 0L;
            Path file = this.paths[this.count];
            this.currentStream = this.fs.open(file);
            this.currentReader = new BufferedReader(new InputStreamReader((InputStream)this.currentStream));
        }

        public void close() throws IOException {
        }

        public long getPos() throws IOException {
            long currentOffset = this.currentStream == null ? 0L : this.currentStream.getPos();
            return this.offset + currentOffset;
        }

        public float getProgress() throws IOException {
            return (float)this.getPos() / (float)this.totLength;
        }

        public boolean next(WordOffset key, Text value) throws IOException {
            String line;
            if (this.count >= this.split.getNumPaths()) {
                return false;
            }
            do {
                if ((line = this.currentReader.readLine()) != null) continue;
                this.currentReader.close();
                this.offset += this.split.getLength(this.count);
                if (++this.count >= this.split.getNumPaths()) {
                    return false;
                }
                Path file = this.paths[this.count];
                this.currentStream = this.fs.open(file);
                this.currentReader = new BufferedReader(new InputStreamReader((InputStream)this.currentStream));
                key.fileName = file.getName();
            } while (line == null);
            key.offset = this.currentStream.getPos();
            value.set(line);
            return true;
        }

        public WordOffset createKey() {
            WordOffset wo = new WordOffset();
            wo.fileName = this.paths[0].toString();
            return wo;
        }

        public Text createValue() {
            return new Text();
        }
    }

    public static class MyInputFormat
    extends MultiFileInputFormat<WordOffset, Text> {
        public RecordReader<WordOffset, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new MultiFileLineRecordReader((Configuration)job, (MultiFileSplit)split);
        }
    }

    public static class WordOffset
    implements WritableComparable {
        private long offset;
        private String fileName;

        public void readFields(DataInput in) throws IOException {
            this.offset = in.readLong();
            this.fileName = Text.readString((DataInput)in);
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.offset);
            Text.writeString((DataOutput)out, (String)this.fileName);
        }

        public int compareTo(Object o) {
            WordOffset that = (WordOffset)o;
            int f = this.fileName.compareTo(that.fileName);
            if (f == 0) {
                return (int)Math.signum((double)(this.offset - that.offset));
            }
            return f;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WordOffset) {
                return this.compareTo(obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }
}

