/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TByteArrayOutputStream;
import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBase64Utils;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.TTransport;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class TJSONProtocol
extends TProtocol {
    private static final byte[] COMMA = new byte[]{44};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] LBRACE = new byte[]{123};
    private static final byte[] RBRACE = new byte[]{125};
    private static final byte[] LBRACKET = new byte[]{91};
    private static final byte[] RBRACKET = new byte[]{93};
    private static final byte[] QUOTE = new byte[]{34};
    private static final byte[] BACKSLASH = new byte[]{92};
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] ESCSEQ = new byte[]{92, 117, 48, 48};
    private static final long VERSION = 1L;
    private static final byte[] JSON_CHAR_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 98, 116, 110, 0, 102, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final String ESCAPE_CHARS = "\"\\bfnrt";
    private static final byte[] ESCAPE_CHAR_VALS = new byte[]{34, 92, 8, 12, 10, 13, 9};
    private static final int DEF_STRING_SIZE = 16;
    private static final byte[] NAME_BOOL = new byte[]{116, 102};
    private static final byte[] NAME_BYTE = new byte[]{105, 56};
    private static final byte[] NAME_I16 = new byte[]{105, 49, 54};
    private static final byte[] NAME_I32 = new byte[]{105, 51, 50};
    private static final byte[] NAME_I64 = new byte[]{105, 54, 52};
    private static final byte[] NAME_DOUBLE = new byte[]{100, 98, 108};
    private static final byte[] NAME_STRUCT = new byte[]{114, 101, 99};
    private static final byte[] NAME_STRING = new byte[]{115, 116, 114};
    private static final byte[] NAME_MAP = new byte[]{109, 97, 112};
    private static final byte[] NAME_LIST = new byte[]{108, 115, 116};
    private static final byte[] NAME_SET = new byte[]{115, 101, 116};
    private Stack<JSONBaseContext> contextStack_ = new Stack();
    private JSONBaseContext context_ = new JSONBaseContext();
    private LookaheadReader reader_ = new LookaheadReader();
    private byte[] tmpbuf_ = new byte[4];

    private static final byte[] getTypeNameForTypeID(byte by) throws TException {
        switch (by) {
            case 2: {
                return NAME_BOOL;
            }
            case 3: {
                return NAME_BYTE;
            }
            case 6: {
                return NAME_I16;
            }
            case 8: {
                return NAME_I32;
            }
            case 10: {
                return NAME_I64;
            }
            case 4: {
                return NAME_DOUBLE;
            }
            case 11: {
                return NAME_STRING;
            }
            case 12: {
                return NAME_STRUCT;
            }
            case 13: {
                return NAME_MAP;
            }
            case 14: {
                return NAME_SET;
            }
            case 15: {
                return NAME_LIST;
            }
        }
        throw new TProtocolException(5, "Unrecognized type");
    }

    private static final byte getTypeIDForTypeName(byte[] byArray) throws TException {
        int n = 0;
        if (byArray.length > 1) {
            switch (byArray[0]) {
                case 100: {
                    n = 4;
                    break;
                }
                case 105: {
                    switch (byArray[1]) {
                        case 56: {
                            n = 3;
                            break;
                        }
                        case 49: {
                            n = 6;
                            break;
                        }
                        case 51: {
                            n = 8;
                            break;
                        }
                        case 54: {
                            n = 10;
                        }
                    }
                    break;
                }
                case 108: {
                    n = 15;
                    break;
                }
                case 109: {
                    n = 13;
                    break;
                }
                case 114: {
                    n = 12;
                    break;
                }
                case 115: {
                    if (byArray[1] == 116) {
                        n = 11;
                        break;
                    }
                    if (byArray[1] != 101) break;
                    n = 14;
                    break;
                }
                case 116: {
                    n = 2;
                }
            }
        }
        if (n == 0) {
            throw new TProtocolException(5, "Unrecognized type");
        }
        return (byte)n;
    }

    private void pushContext(JSONBaseContext jSONBaseContext) {
        this.contextStack_.push(this.context_);
        this.context_ = jSONBaseContext;
    }

    private void popContext() {
        this.context_ = this.contextStack_.pop();
    }

    public TJSONProtocol(TTransport tTransport) {
        super(tTransport);
    }

    protected void readJSONSyntaxChar(byte[] byArray) throws TException {
        byte by = this.reader_.read();
        if (by != byArray[0]) {
            throw new TProtocolException(1, "Unexpected character:" + (char)by);
        }
    }

    private static final byte hexVal(byte by) throws TException {
        if (by >= 48 && by <= 57) {
            return (byte)((char)by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)((char)by - 97);
        }
        throw new TProtocolException(1, "Expected hex character");
    }

    private static final byte hexChar(byte by) {
        if ((by = (byte)(by & 0xF)) < 10) {
            return (byte)((char)by + 48);
        }
        return (byte)((char)by + 97);
    }

    private void writeJSONString(byte[] byArray) throws TException {
        this.context_.write();
        this.trans_.write(QUOTE);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) >= 48) {
                if (byArray[i] == BACKSLASH[0]) {
                    this.trans_.write(BACKSLASH);
                    this.trans_.write(BACKSLASH);
                    continue;
                }
                this.trans_.write(byArray, i, 1);
                continue;
            }
            this.tmpbuf_[0] = JSON_CHAR_TABLE[byArray[i]];
            if (this.tmpbuf_[0] == 1) {
                this.trans_.write(byArray, i, 1);
                continue;
            }
            if (this.tmpbuf_[0] > 1) {
                this.trans_.write(BACKSLASH);
                this.trans_.write(this.tmpbuf_, 0, 1);
                continue;
            }
            this.trans_.write(ESCSEQ);
            this.tmpbuf_[0] = TJSONProtocol.hexChar((byte)(byArray[i] >> 4));
            this.tmpbuf_[1] = TJSONProtocol.hexChar(byArray[i]);
            this.trans_.write(this.tmpbuf_, 0, 2);
        }
        this.trans_.write(QUOTE);
    }

    private void writeJSONInteger(long l) throws TException {
        this.context_.write();
        String string = Long.toString(l);
        boolean bl = this.context_.escapeNum();
        if (bl) {
            this.trans_.write(QUOTE);
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.trans_.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        if (bl) {
            this.trans_.write(QUOTE);
        }
    }

    private void writeJSONDouble(double d) throws TException {
        boolean bl;
        this.context_.write();
        String string = Double.toString(d);
        boolean bl2 = false;
        switch (string.charAt(0)) {
            case 'I': 
            case 'N': {
                bl2 = true;
                break;
            }
            case '-': {
                if (string.charAt(1) != 'I') break;
                bl2 = true;
            }
        }
        boolean bl3 = bl = bl2 || this.context_.escapeNum();
        if (bl) {
            this.trans_.write(QUOTE);
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.trans_.write(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        if (bl) {
            this.trans_.write(QUOTE);
        }
    }

    private void writeJSONBase64(byte[] byArray) throws TException {
        int n;
        this.context_.write();
        this.trans_.write(QUOTE);
        int n2 = 0;
        for (n = byArray.length; n >= 3; n -= 3) {
            TBase64Utils.encode(byArray, n2, 3, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, 4);
            n2 += 3;
        }
        if (n > 0) {
            TBase64Utils.encode(byArray, n2, n, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, n + 1);
        }
        this.trans_.write(QUOTE);
    }

    private void writeJSONObjectStart() throws TException {
        this.context_.write();
        this.trans_.write(LBRACE);
        this.pushContext(new JSONPairContext());
    }

    private void writeJSONObjectEnd() throws TException {
        this.popContext();
        this.trans_.write(RBRACE);
    }

    private void writeJSONArrayStart() throws TException {
        this.context_.write();
        this.trans_.write(LBRACKET);
        this.pushContext(new JSONListContext());
    }

    private void writeJSONArrayEnd() throws TException {
        this.popContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeMessageBegin(TMessage tMessage) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONInteger(1L);
        try {
            byte[] byArray = tMessage.name.getBytes("UTF-8");
            this.writeJSONString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        this.writeJSONInteger(tMessage.type);
        this.writeJSONInteger(tMessage.seqid);
    }

    @Override
    public void writeMessageEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeStructBegin(TStruct tStruct) throws TException {
        this.writeJSONObjectStart();
    }

    @Override
    public void writeStructEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeFieldBegin(TField tField) throws TException {
        this.writeJSONInteger(tField.id);
        this.writeJSONObjectStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(tField.type));
    }

    @Override
    public void writeFieldEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(TMap tMap) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(tMap.keyType));
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(tMap.valueType));
        this.writeJSONInteger(tMap.size);
        this.writeJSONObjectStart();
    }

    @Override
    public void writeMapEnd() throws TException {
        this.writeJSONObjectEnd();
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeListBegin(TList tList) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(tList.elemType));
        this.writeJSONInteger(tList.size);
    }

    @Override
    public void writeListEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeSetBegin(TSet tSet) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(tSet.elemType));
        this.writeJSONInteger(tSet.size);
    }

    @Override
    public void writeSetEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeBool(boolean bl) throws TException {
        this.writeJSONInteger(bl ? 1L : 0L);
    }

    @Override
    public void writeByte(byte by) throws TException {
        this.writeJSONInteger(by);
    }

    @Override
    public void writeI16(short s) throws TException {
        this.writeJSONInteger(s);
    }

    @Override
    public void writeI32(int n) throws TException {
        this.writeJSONInteger(n);
    }

    @Override
    public void writeI64(long l) throws TException {
        this.writeJSONInteger(l);
    }

    @Override
    public void writeDouble(double d) throws TException {
        this.writeJSONDouble(d);
    }

    @Override
    public void writeString(String string) throws TException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.writeJSONString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public void writeBinary(byte[] byArray) throws TException {
        this.writeJSONBase64(byArray);
    }

    private TByteArrayOutputStream readJSONString(boolean bl) throws TException {
        byte by;
        TByteArrayOutputStream tByteArrayOutputStream = new TByteArrayOutputStream(16);
        if (!bl) {
            this.context_.read();
        }
        this.readJSONSyntaxChar(QUOTE);
        while ((by = this.reader_.read()) != QUOTE[0]) {
            if (by == ESCSEQ[0]) {
                by = this.reader_.read();
                if (by == ESCSEQ[1]) {
                    this.readJSONSyntaxChar(ZERO);
                    this.readJSONSyntaxChar(ZERO);
                    this.trans_.readAll(this.tmpbuf_, 0, 2);
                    by = (byte)((TJSONProtocol.hexVal(this.tmpbuf_[0]) << 4) + TJSONProtocol.hexVal(this.tmpbuf_[1]));
                } else {
                    int n = ESCAPE_CHARS.indexOf(by);
                    if (n == -1) {
                        throw new TProtocolException(1, "Expected control char");
                    }
                    by = ESCAPE_CHAR_VALS[n];
                }
            }
            tByteArrayOutputStream.write(by);
        }
        return tByteArrayOutputStream;
    }

    private boolean isJSONNumeric(byte by) {
        switch (by) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    private String readJSONNumericChars() throws TException {
        byte by;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.isJSONNumeric(by = this.reader_.peek())) {
            stringBuilder.append((char)this.reader_.read());
        }
        return stringBuilder.toString();
    }

    private long readJSONInteger() throws TException {
        this.context_.read();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        String string = this.readJSONNumericChars();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private double readJSONDouble() throws TException {
        this.context_.read();
        if (this.reader_.peek() == QUOTE[0]) {
            TByteArrayOutputStream tByteArrayOutputStream = this.readJSONString(true);
            try {
                double d = Double.valueOf(tByteArrayOutputStream.toString("UTF-8"));
                if (!(this.context_.escapeNum() || Double.isNaN(d) || Double.isInfinite(d))) {
                    throw new TProtocolException(1, "Numeric data unexpectedly quoted");
                }
                return d;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TException("JVM DOES NOT SUPPORT UTF-8");
            }
        }
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Double.valueOf(this.readJSONNumericChars());
        }
        catch (NumberFormatException numberFormatException) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private byte[] readJSONBase64() throws TException {
        TByteArrayOutputStream tByteArrayOutputStream = this.readJSONString(false);
        byte[] byArray = tByteArrayOutputStream.get();
        int n = tByteArrayOutputStream.len();
        int n2 = 0;
        int n3 = 0;
        while (n >= 4) {
            TBase64Utils.decode(byArray, n2, 4, byArray, n3);
            n2 += 4;
            n -= 4;
            n3 += 3;
        }
        if (n > 1) {
            TBase64Utils.decode(byArray, n2, n, byArray, n3);
            n3 += n - 1;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    private void readJSONObjectStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACE);
        this.pushContext(new JSONPairContext());
    }

    private void readJSONObjectEnd() throws TException {
        this.readJSONSyntaxChar(RBRACE);
        this.popContext();
    }

    private void readJSONArrayStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACKET);
        this.pushContext(new JSONListContext());
    }

    private void readJSONArrayEnd() throws TException {
        this.readJSONSyntaxChar(RBRACKET);
        this.popContext();
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        TMessage tMessage = new TMessage();
        this.readJSONArrayStart();
        if (this.readJSONInteger() != 1L) {
            throw new TProtocolException(4, "Message contained bad version.");
        }
        try {
            tMessage.name = this.readJSONString(false).toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        tMessage.type = (byte)this.readJSONInteger();
        tMessage.seqid = (int)this.readJSONInteger();
        return tMessage;
    }

    @Override
    public void readMessageEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public TStruct readStructBegin() throws TException {
        this.readJSONObjectStart();
        return new TStruct();
    }

    @Override
    public void readStructEnd() throws TException {
        this.readJSONObjectEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        TField tField = new TField();
        byte by = this.reader_.peek();
        if (by == RBRACE[0]) {
            tField.type = 0;
        } else {
            tField.id = (short)this.readJSONInteger();
            this.readJSONObjectStart();
            tField.type = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        }
        return tField;
    }

    @Override
    public void readFieldEnd() throws TException {
        this.readJSONObjectEnd();
    }

    @Override
    public TMap readMapBegin() throws TException {
        TMap tMap = new TMap();
        this.readJSONArrayStart();
        tMap.keyType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        tMap.valueType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        tMap.size = (int)this.readJSONInteger();
        this.readJSONObjectStart();
        return tMap;
    }

    @Override
    public void readMapEnd() throws TException {
        this.readJSONObjectEnd();
        this.readJSONArrayEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        TList tList = new TList();
        this.readJSONArrayStart();
        tList.elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        tList.size = (int)this.readJSONInteger();
        return tList;
    }

    @Override
    public void readListEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        TSet tSet = new TSet();
        this.readJSONArrayStart();
        tSet.elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        tSet.size = (int)this.readJSONInteger();
        return tSet;
    }

    @Override
    public void readSetEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public boolean readBool() throws TException {
        return this.readJSONInteger() != 0L;
    }

    @Override
    public byte readByte() throws TException {
        return (byte)this.readJSONInteger();
    }

    @Override
    public short readI16() throws TException {
        return (short)this.readJSONInteger();
    }

    @Override
    public int readI32() throws TException {
        return (int)this.readJSONInteger();
    }

    @Override
    public long readI64() throws TException {
        return this.readJSONInteger();
    }

    @Override
    public double readDouble() throws TException {
        return this.readJSONDouble();
    }

    @Override
    public String readString() throws TException {
        try {
            return this.readJSONString(false).toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public byte[] readBinary() throws TException {
        return this.readJSONBase64();
    }

    protected class LookaheadReader {
        private boolean hasData_;
        private byte[] data_ = new byte[1];

        protected LookaheadReader() {
        }

        protected byte read() throws TException {
            if (this.hasData_) {
                this.hasData_ = false;
            } else {
                TJSONProtocol.this.trans_.readAll(this.data_, 0, 1);
            }
            return this.data_[0];
        }

        protected byte peek() throws TException {
            if (!this.hasData_) {
                TJSONProtocol.this.trans_.readAll(this.data_, 0, 1);
            }
            this.hasData_ = true;
            return this.data_[0];
        }
    }

    protected class JSONPairContext
    extends JSONBaseContext {
        private boolean first_;
        private boolean colon_;

        protected JSONPairContext() {
            this.first_ = true;
            this.colon_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TJSONProtocol.this.trans_.write(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }

        @Override
        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TJSONProtocol.this.readJSONSyntaxChar(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }

        @Override
        protected boolean escapeNum() {
            return this.colon_;
        }
    }

    protected class JSONListContext
    extends JSONBaseContext {
        private boolean first_;

        protected JSONListContext() {
            this.first_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TJSONProtocol.this.trans_.write(COMMA);
            }
        }

        @Override
        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TJSONProtocol.this.readJSONSyntaxChar(COMMA);
            }
        }
    }

    protected class JSONBaseContext {
        protected JSONBaseContext() {
        }

        protected void write() throws TException {
        }

        protected void read() throws TException {
        }

        protected boolean escapeNum() {
            return false;
        }
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport tTransport) {
            return new TJSONProtocol(tTransport);
        }
    }
}

