/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.transport.TIOStreamTransport;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public class TDeserializer {
    private final TProtocolFactory protocolFactory_;

    public TDeserializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TDeserializer(TProtocolFactory tProtocolFactory) {
        this.protocolFactory_ = tProtocolFactory;
    }

    public void deserialize(TBase tBase, byte[] byArray) throws TException {
        tBase.read(this.protocolFactory_.getProtocol(new TIOStreamTransport(new ByteArrayInputStream(byArray))));
    }

    public void deserialize(TBase tBase, String string, String string2) throws TException {
        try {
            this.deserialize(tBase, string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + string2);
        }
    }

    public void toString(TBase tBase, String string) throws TException {
        this.deserialize(tBase, string.getBytes());
    }
}

