/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.gridmix.CombineFileSplit;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;

class LoadSplit
extends CombineFileSplit {
    private int id;
    private int nSpec;
    private int maps;
    private int reduces;
    private long inputRecords;
    private long outputBytes;
    private long outputRecords;
    private long maxMemory;
    private double[] reduceBytes = new double[0];
    private double[] reduceRecords = new double[0];
    private long[] reduceOutputBytes = new long[0];
    private long[] reduceOutputRecords = new long[0];
    private ResourceUsageMetrics mapMetrics;
    private ResourceUsageMetrics[] reduceMetrics;

    LoadSplit() {
    }

    public LoadSplit(CombineFileSplit cfsplit, int maps, int id, long inputBytes, long inputRecords, long outputBytes, long outputRecords, double[] reduceBytes, double[] reduceRecords, long[] reduceOutputBytes, long[] reduceOutputRecords, ResourceUsageMetrics metrics, ResourceUsageMetrics[] rMetrics) throws IOException {
        super(cfsplit);
        this.id = id;
        this.maps = maps;
        this.reduces = reduceBytes.length;
        this.inputRecords = inputRecords;
        this.outputBytes = outputBytes;
        this.outputRecords = outputRecords;
        this.reduceBytes = reduceBytes;
        this.reduceRecords = reduceRecords;
        this.nSpec = reduceOutputBytes.length;
        this.reduceOutputBytes = reduceOutputBytes;
        this.reduceOutputRecords = reduceOutputRecords;
        this.mapMetrics = metrics;
        this.reduceMetrics = rMetrics;
    }

    public int getId() {
        return this.id;
    }

    public int getMapCount() {
        return this.maps;
    }

    public long getInputRecords() {
        return this.inputRecords;
    }

    public long[] getOutputBytes() {
        if (0 == this.reduces) {
            return new long[]{this.outputBytes};
        }
        long[] ret = new long[this.reduces];
        for (int i = 0; i < this.reduces; ++i) {
            ret[i] = Math.round((double)this.outputBytes * this.reduceBytes[i]);
        }
        return ret;
    }

    public long[] getOutputRecords() {
        if (0 == this.reduces) {
            return new long[]{this.outputRecords};
        }
        long[] ret = new long[this.reduces];
        for (int i = 0; i < this.reduces; ++i) {
            ret[i] = Math.round((double)this.outputRecords * this.reduceRecords[i]);
        }
        return ret;
    }

    public long getReduceBytes(int i) {
        return this.reduceOutputBytes[i];
    }

    public long getReduceRecords(int i) {
        return this.reduceOutputRecords[i];
    }

    public ResourceUsageMetrics getMapResourceUsageMetrics() {
        return this.mapMetrics;
    }

    public ResourceUsageMetrics getReduceResourceUsageMetrics(int i) {
        return this.reduceMetrics[i];
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        WritableUtils.writeVInt((DataOutput)out, (int)this.id);
        WritableUtils.writeVInt((DataOutput)out, (int)this.maps);
        WritableUtils.writeVLong((DataOutput)out, (long)this.inputRecords);
        WritableUtils.writeVLong((DataOutput)out, (long)this.outputBytes);
        WritableUtils.writeVLong((DataOutput)out, (long)this.outputRecords);
        WritableUtils.writeVLong((DataOutput)out, (long)this.maxMemory);
        WritableUtils.writeVInt((DataOutput)out, (int)this.reduces);
        for (i = 0; i < this.reduces; ++i) {
            out.writeDouble(this.reduceBytes[i]);
            out.writeDouble(this.reduceRecords[i]);
        }
        WritableUtils.writeVInt((DataOutput)out, (int)this.nSpec);
        for (i = 0; i < this.nSpec; ++i) {
            WritableUtils.writeVLong((DataOutput)out, (long)this.reduceOutputBytes[i]);
            WritableUtils.writeVLong((DataOutput)out, (long)this.reduceOutputRecords[i]);
        }
        this.mapMetrics.write(out);
        int numReduceMetrics = this.reduceMetrics == null ? 0 : this.reduceMetrics.length;
        WritableUtils.writeVInt((DataOutput)out, (int)numReduceMetrics);
        for (int i2 = 0; i2 < numReduceMetrics; ++i2) {
            this.reduceMetrics[i2].write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        super.readFields(in);
        this.id = WritableUtils.readVInt((DataInput)in);
        this.maps = WritableUtils.readVInt((DataInput)in);
        this.inputRecords = WritableUtils.readVLong((DataInput)in);
        this.outputBytes = WritableUtils.readVLong((DataInput)in);
        this.outputRecords = WritableUtils.readVLong((DataInput)in);
        this.maxMemory = WritableUtils.readVLong((DataInput)in);
        this.reduces = WritableUtils.readVInt((DataInput)in);
        if (this.reduceBytes.length < this.reduces) {
            this.reduceBytes = new double[this.reduces];
            this.reduceRecords = new double[this.reduces];
        }
        for (i = 0; i < this.reduces; ++i) {
            this.reduceBytes[i] = in.readDouble();
            this.reduceRecords[i] = in.readDouble();
        }
        this.nSpec = WritableUtils.readVInt((DataInput)in);
        if (this.reduceOutputBytes.length < this.nSpec) {
            this.reduceOutputBytes = new long[this.nSpec];
            this.reduceOutputRecords = new long[this.nSpec];
        }
        for (i = 0; i < this.nSpec; ++i) {
            this.reduceOutputBytes[i] = WritableUtils.readVLong((DataInput)in);
            this.reduceOutputRecords[i] = WritableUtils.readVLong((DataInput)in);
        }
        this.mapMetrics = new ResourceUsageMetrics();
        this.mapMetrics.readFields(in);
        int numReduceMetrics = WritableUtils.readVInt((DataInput)in);
        this.reduceMetrics = new ResourceUsageMetrics[numReduceMetrics];
        for (int i2 = 0; i2 < numReduceMetrics; ++i2) {
            this.reduceMetrics[i2] = new ResourceUsageMetrics();
            this.reduceMetrics[i2].readFields(in);
        }
    }
}

