/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.ReplayJobFactory;
import org.apache.hadoop.mapred.gridmix.SerialJobFactory;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.StressJobFactory;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.tools.rumen.JobStoryProducer;

enum GridmixJobSubmissionPolicy {
    REPLAY("REPLAY", 320000){

        @Override
        public JobFactory<Statistics.ClusterStats> createJobFactory(JobSubmitter submitter, JobStoryProducer producer, Path scratchDir, Configuration conf, CountDownLatch startFlag, UserResolver userResolver) throws IOException {
            return new ReplayJobFactory(submitter, producer, scratchDir, conf, startFlag, userResolver);
        }
    }
    ,
    STRESS("STRESS", 5000){

        @Override
        public JobFactory<Statistics.ClusterStats> createJobFactory(JobSubmitter submitter, JobStoryProducer producer, Path scratchDir, Configuration conf, CountDownLatch startFlag, UserResolver userResolver) throws IOException {
            return new StressJobFactory(submitter, producer, scratchDir, conf, startFlag, userResolver);
        }
    }
    ,
    SERIAL("SERIAL", 0){

        @Override
        public JobFactory<Statistics.JobStats> createJobFactory(JobSubmitter submitter, JobStoryProducer producer, Path scratchDir, Configuration conf, CountDownLatch startFlag, UserResolver userResolver) throws IOException {
            return new SerialJobFactory(submitter, producer, scratchDir, conf, startFlag, userResolver);
        }
    };

    public static final String JOB_SUBMISSION_POLICY = "gridmix.job-submission.policy";
    private final String name;
    private final int pollingInterval;

    private GridmixJobSubmissionPolicy(String name, int pollingInterval) {
        this.name = name;
        this.pollingInterval = pollingInterval;
    }

    public abstract JobFactory createJobFactory(JobSubmitter var1, JobStoryProducer var2, Path var3, Configuration var4, CountDownLatch var5, UserResolver var6) throws IOException;

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public static GridmixJobSubmissionPolicy getPolicy(Configuration conf, GridmixJobSubmissionPolicy defaultPolicy) {
        String policy = conf.get(JOB_SUBMISSION_POLICY, defaultPolicy.name());
        return GridmixJobSubmissionPolicy.valueOf(policy.toUpperCase());
    }
}

