/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.mapred.CapBasedLoadManager;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.DefaultTaskSelector;
import org.apache.hadoop.mapred.FairSchedulerEventLog;
import org.apache.hadoop.mapred.FairSchedulerServlet;
import org.apache.hadoop.mapred.FifoJobComparator;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobSchedulable;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.LoadManager;
import org.apache.hadoop.mapred.LocalityLevel;
import org.apache.hadoop.mapred.Pool;
import org.apache.hadoop.mapred.PoolManager;
import org.apache.hadoop.mapred.PoolSchedulable;
import org.apache.hadoop.mapred.Schedulable;
import org.apache.hadoop.mapred.SchedulingAlgorithms;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskSelector;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.UndeclaredPoolException;
import org.apache.hadoop.mapred.WeightAdjuster;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class FairScheduler
extends TaskScheduler {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.FairScheduler");
    protected long updateInterval = 500L;
    protected long dumpInterval = 10000L;
    protected long preemptionInterval = 15000L;
    private static final TaskType[] MAP_AND_REDUCE = new TaskType[]{TaskType.MAP, TaskType.REDUCE};
    private static final long MAX_AUTOCOMPUTED_LOCALITY_DELAY = 15000L;
    protected PoolManager poolMgr;
    protected LoadManager loadMgr;
    protected TaskSelector taskSelector;
    protected WeightAdjuster weightAdjuster;
    protected Map<JobInProgress, JobInfo> infos = new HashMap<JobInProgress, JobInfo>();
    protected long lastUpdateTime;
    protected long lastPreemptionUpdateTime;
    protected boolean initialized;
    protected volatile boolean running;
    protected boolean assignMultiple;
    protected int mapAssignCap = -1;
    protected int reduceAssignCap = -1;
    protected long nodeLocalityDelay;
    protected long rackLocalityDelay;
    protected boolean autoComputeLocalityDelay = false;
    protected boolean sizeBasedWeight;
    protected boolean waitForMapsBeforeLaunchingReduces = true;
    protected boolean preemptionEnabled;
    protected boolean onlyLogPreemption;
    private Clock clock;
    private JobListener jobListener;
    private JobInitializer jobInitializer;
    private boolean mockMode;
    private FairSchedulerEventLog eventLog;
    protected long lastDumpTime;
    protected long lastHeartbeatTime;
    private long lastPreemptCheckTime;
    public static final String ALLOW_UNDECLARED_POOLS_KEY = "mapred.fairscheduler.allow.undeclared.pools";
    private boolean allowUndeclaredPools = false;
    private MetricsUpdater metricsUpdater;

    public FairScheduler() {
        this(new Clock(), false);
    }

    protected FairScheduler(Clock clock, boolean mockMode) {
        this.clock = clock;
        this.mockMode = mockMode;
        this.jobListener = new JobListener();
    }

    public void start() {
        try {
            Configuration conf = this.getConf();
            this.eventLog = new FairSchedulerEventLog();
            boolean logEnabled = conf.getBoolean("mapred.fairscheduler.eventlog.enabled", false);
            if (!this.mockMode && logEnabled) {
                String hostname = "localhost";
                if (this.taskTrackerManager instanceof JobTracker) {
                    hostname = ((JobTracker)this.taskTrackerManager).getJobTrackerMachine();
                }
                this.eventLog.init(conf, hostname);
            }
            this.jobInitializer = new JobInitializer(conf, this.taskTrackerManager);
            this.taskTrackerManager.addJobInProgressListener((JobInProgressListener)this.jobListener);
            this.poolMgr = new PoolManager(this);
            this.poolMgr.initialize();
            this.loadMgr = (LoadManager)ReflectionUtils.newInstance((Class)conf.getClass("mapred.fairscheduler.loadmanager", CapBasedLoadManager.class, LoadManager.class), (Configuration)conf);
            this.loadMgr.setTaskTrackerManager(this.taskTrackerManager);
            this.loadMgr.setEventLog(this.eventLog);
            this.loadMgr.start();
            this.taskSelector = (TaskSelector)ReflectionUtils.newInstance((Class)conf.getClass("mapred.fairscheduler.taskselector", DefaultTaskSelector.class, TaskSelector.class), (Configuration)conf);
            this.taskSelector.setTaskTrackerManager(this.taskTrackerManager);
            this.taskSelector.start();
            Class weightAdjClass = conf.getClass("mapred.fairscheduler.weightadjuster", null);
            if (weightAdjClass != null) {
                this.weightAdjuster = (WeightAdjuster)ReflectionUtils.newInstance((Class)weightAdjClass, (Configuration)conf);
            }
            this.updateInterval = conf.getLong("mapred.fairscheduler.update.interval", 500L);
            this.dumpInterval = conf.getLong("mapred.fairscheduler.dump.interval", 10000L);
            this.preemptionInterval = conf.getLong("mapred.fairscheduler.preemption.interval", 15000L);
            this.assignMultiple = conf.getBoolean("mapred.fairscheduler.assignmultiple", true);
            this.mapAssignCap = conf.getInt("mapred.fairscheduler.assignmultiple.maps", -1);
            this.reduceAssignCap = conf.getInt("mapred.fairscheduler.assignmultiple.reduces", -1);
            this.sizeBasedWeight = conf.getBoolean("mapred.fairscheduler.sizebasedweight", false);
            this.preemptionEnabled = conf.getBoolean("mapred.fairscheduler.preemption", false);
            this.onlyLogPreemption = conf.getBoolean("mapred.fairscheduler.preemption.only.log", false);
            long defaultDelay = conf.getLong("mapred.fairscheduler.locality.delay", -1L);
            this.nodeLocalityDelay = conf.getLong("mapred.fairscheduler.locality.delay.node", defaultDelay);
            this.rackLocalityDelay = conf.getLong("mapred.fairscheduler.locality.delay.rack", defaultDelay);
            this.allowUndeclaredPools = conf.getBoolean(ALLOW_UNDECLARED_POOLS_KEY, true);
            if (defaultDelay == -1L && (this.nodeLocalityDelay == -1L || this.rackLocalityDelay == -1L)) {
                this.autoComputeLocalityDelay = true;
            }
            this.initialized = true;
            this.running = true;
            this.lastUpdateTime = this.clock.getTime();
            if (!this.mockMode) {
                new UpdateThread().start();
            }
            if (this.taskTrackerManager instanceof JobTracker) {
                JobTracker jobTracker = (JobTracker)this.taskTrackerManager;
                HttpServer infoServer = jobTracker.infoServer;
                infoServer.setAttribute("scheduler", (Object)this);
                infoServer.addServlet("scheduler", "/scheduler", FairSchedulerServlet.class);
            }
            this.initMetrics();
            this.eventLog.log("INITIALIZED", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start FairScheduler", e);
        }
        LOG.info((Object)"Successfully configured FairScheduler");
    }

    LoadManager getLoadManager() {
        return this.loadMgr;
    }

    private void initMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"fairscheduler");
        this.metricsUpdater = new MetricsUpdater();
        context.registerUpdater((Updater)this.metricsUpdater);
    }

    public void terminate() throws IOException {
        if (this.eventLog != null) {
            this.eventLog.log("SHUTDOWN", new Object[0]);
        }
        this.running = false;
        this.jobInitializer.terminate();
        if (this.jobListener != null) {
            this.taskTrackerManager.removeJobInProgressListener((JobInProgressListener)this.jobListener);
        }
        if (this.eventLog != null) {
            this.eventLog.shutdown();
        }
        if (this.metricsUpdater != null) {
            MetricsContext context = MetricsUtil.getContext((String)"fairscheduler");
            context.unregisterUpdater((Updater)this.metricsUpdater);
            this.metricsUpdater = null;
        }
    }

    synchronized void updateMetrics() {
        this.poolMgr.updateMetrics();
    }

    public synchronized List<Task> assignTasks(TaskTracker tracker) throws IOException {
        if (!this.initialized) {
            return null;
        }
        String trackerName = tracker.getTrackerName();
        this.eventLog.log("HEARTBEAT", trackerName);
        long currentTime = this.clock.getTime();
        int runnableMaps = 0;
        int runningMaps = 0;
        int runnableReduces = 0;
        int runningReduces = 0;
        for (Pool pool : this.poolMgr.getPools()) {
            runnableMaps += pool.getMapSchedulable().getDemand();
            runningMaps += pool.getMapSchedulable().getRunningTasks();
            runnableReduces += pool.getReduceSchedulable().getDemand();
            runningReduces += pool.getReduceSchedulable().getRunningTasks();
        }
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        int totalMapSlots = this.getTotalSlots(TaskType.MAP, clusterStatus);
        int totalReduceSlots = this.getTotalSlots(TaskType.REDUCE, clusterStatus);
        this.eventLog.log("RUNNABLE_TASKS", runnableMaps, runningMaps, runnableReduces, runningReduces);
        this.updateLocalityWaitTimes(currentTime);
        if (this.taskTrackerManager.isInSafeMode()) {
            LOG.info((Object)"JobTracker is in safe-mode, not scheduling any tasks.");
            return null;
        }
        TaskTrackerStatus tts = tracker.getStatus();
        int mapsAssigned = 0;
        int reducesAssigned = 0;
        int mapCapacity = this.maxTasksToAssign(TaskType.MAP, tts);
        int reduceCapacity = this.maxTasksToAssign(TaskType.REDUCE, tts);
        boolean mapRejected = false;
        boolean reduceRejected = false;
        HashSet<JobInProgress> visitedForMap = new HashSet<JobInProgress>();
        HashSet<JobInProgress> visitedForReduce = new HashSet<JobInProgress>();
        HashSet<JobInProgress> launchedMap = new HashSet<JobInProgress>();
        ArrayList<Task> tasks = new ArrayList<Task>();
        while (true) {
            if (!(mapRejected || mapsAssigned != mapCapacity && runningMaps != runnableMaps && this.loadMgr.canAssignMap(tts, runnableMaps, totalMapSlots, mapsAssigned))) {
                this.eventLog.log("INFO", "Can't assign another MAP to " + trackerName);
                mapRejected = true;
            }
            if (!(reduceRejected || reducesAssigned != reduceCapacity && runningReduces != runnableReduces && this.loadMgr.canAssignReduce(tts, runnableReduces, totalReduceSlots, reducesAssigned))) {
                this.eventLog.log("INFO", "Can't assign another REDUCE to " + trackerName);
                reduceRejected = true;
            }
            if (mapRejected && reduceRejected || !this.assignMultiple && tasks.size() > 0) break;
            TaskType taskType = mapRejected ? TaskType.REDUCE : (reduceRejected ? TaskType.MAP : (tts.countMapTasks() + mapsAssigned <= tts.countReduceTasks() + reducesAssigned ? TaskType.MAP : TaskType.REDUCE));
            List<PoolSchedulable> scheds = this.getPoolSchedulables(taskType);
            Collections.sort(scheds, new SchedulingAlgorithms.FairShareComparator());
            boolean foundTask = false;
            for (PoolSchedulable sched : scheds) {
                this.eventLog.log("INFO", "Checking for " + taskType + " task in " + ((Schedulable)sched).getName());
                Task task = taskType == TaskType.MAP ? ((Schedulable)sched).assignTask(tts, currentTime, visitedForMap) : ((Schedulable)sched).assignTask(tts, currentTime, visitedForReduce);
                if (task == null) continue;
                foundTask = true;
                JobInProgress job = this.taskTrackerManager.getJob(task.getJobID());
                this.eventLog.log("ASSIGN", trackerName, taskType, job.getJobID(), task.getTaskID());
                if (taskType == TaskType.MAP) {
                    launchedMap.add(job);
                    ++mapsAssigned;
                    ++runningMaps;
                    this.updateLastMapLocalityLevel(job, task, tts);
                } else {
                    ++reducesAssigned;
                    ++runningReduces;
                }
                tasks.add(task);
                break;
            }
            if (foundTask) continue;
            if (taskType == TaskType.MAP) {
                mapRejected = true;
                continue;
            }
            reduceRejected = true;
        }
        for (JobInProgress job : visitedForMap) {
            if (launchedMap.contains(job)) continue;
            this.infos.get((Object)job).skippedAtLastHeartbeat = true;
        }
        return tasks.isEmpty() ? null : tasks;
    }

    protected int maxTasksToAssign(TaskType type, TaskTrackerStatus tts) {
        int availableSlots;
        if (!this.assignMultiple) {
            return 1;
        }
        int cap = type == TaskType.MAP ? this.mapAssignCap : this.reduceAssignCap;
        int n = availableSlots = type == TaskType.MAP ? tts.getAvailableMapSlots() : tts.getAvailableReduceSlots();
        if (cap == -1) {
            return availableSlots;
        }
        return Math.min(cap, availableSlots);
    }

    private void updateLocalityWaitTimes(long currentTime) {
        long timeSinceLastHeartbeat = this.lastHeartbeatTime == 0L ? 0L : currentTime - this.lastHeartbeatTime;
        this.lastHeartbeatTime = currentTime;
        for (JobInfo info : this.infos.values()) {
            if (!info.skippedAtLastHeartbeat) continue;
            info.timeWaitedForLocalMap += timeSinceLastHeartbeat;
            info.skippedAtLastHeartbeat = false;
        }
    }

    private void updateLastMapLocalityLevel(JobInProgress job, Task mapTaskLaunched, TaskTrackerStatus tracker) {
        LocalityLevel localityLevel;
        JobInfo info = this.infos.get(job);
        boolean isNodeGroupAware = this.conf.getBoolean("net.topology.nodegroup.aware", false);
        info.lastMapLocalityLevel = localityLevel = LocalityLevel.fromTask(job, mapTaskLaunched, tracker, isNodeGroupAware);
        info.timeWaitedForLocalMap = 0L;
        this.eventLog.log("ASSIGNED_LOC_LEVEL", new Object[]{job.getJobID(), localityLevel});
    }

    protected LocalityLevel getAllowedLocalityLevel(JobInProgress job, long currentTime) {
        JobInfo info = this.infos.get(job);
        if (info == null) {
            LOG.error((Object)("getAllowedLocalityLevel called on job " + job + ", which does not have a JobInfo in infos"));
            return LocalityLevel.ANY;
        }
        if (job.nonLocalMaps.size() > 0) {
            return LocalityLevel.ANY;
        }
        Pool pool = this.poolMgr.getPool(job);
        PoolSchedulable sched = pool.getMapSchedulable();
        long minShareTimeout = this.poolMgr.getMinSharePreemptionTimeout(pool.getName());
        long fairShareTimeout = this.poolMgr.getFairSharePreemptionTimeout();
        if (currentTime - sched.getLastTimeAtMinShare() > minShareTimeout || currentTime - sched.getLastTimeAtHalfFairShare() > fairShareTimeout) {
            this.eventLog.log("INFO", "No delay scheduling for " + job.getJobID() + " because it is being starved");
            return LocalityLevel.ANY;
        }
        switch (info.lastMapLocalityLevel) {
            case NODE: {
                if (info.timeWaitedForLocalMap >= this.nodeLocalityDelay + this.rackLocalityDelay) {
                    return LocalityLevel.ANY;
                }
                if (info.timeWaitedForLocalMap >= this.nodeLocalityDelay) {
                    return LocalityLevel.RACK;
                }
                return LocalityLevel.NODE;
            }
            case RACK: {
                if (info.timeWaitedForLocalMap >= this.rackLocalityDelay) {
                    return LocalityLevel.ANY;
                }
                return LocalityLevel.RACK;
            }
        }
        return LocalityLevel.ANY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        if (this.autoComputeLocalityDelay) {
            JobTracker jobTracker = (JobTracker)this.taskTrackerManager;
            this.rackLocalityDelay = this.nodeLocalityDelay = Math.min(15000L, (long)(1.5 * (double)jobTracker.getNextHeartbeatInterval()));
        }
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            this.poolMgr.reloadAllocsIfNecessary();
            ArrayList<JobInProgress> toRemove = new ArrayList<JobInProgress>();
            for (JobInProgress job : this.infos.keySet()) {
                int runState = job.getStatus().getRunState();
                if (runState != 2 && runState != 3 && runState != 5) continue;
                toRemove.add(job);
            }
            for (JobInProgress job : toRemove) {
                this.jobNoLongerRunning(job);
            }
            this.updateRunnability();
            for (Pool pool : this.poolMgr.getPools()) {
                pool.getMapSchedulable().updateDemand();
                pool.getReduceSchedulable().updateDemand();
            }
            List<PoolSchedulable> mapScheds = this.getPoolSchedulables(TaskType.MAP);
            List<PoolSchedulable> reduceScheds = this.getPoolSchedulables(TaskType.REDUCE);
            SchedulingAlgorithms.computeFairShares(mapScheds, clusterStatus.getMaxMapTasks());
            SchedulingAlgorithms.computeFairShares(reduceScheds, clusterStatus.getMaxReduceTasks());
            for (Pool pool : this.poolMgr.getPools()) {
                pool.getMapSchedulable().redistributeShare();
                pool.getReduceSchedulable().redistributeShare();
            }
            if (this.preemptionEnabled) {
                this.updatePreemptionVariables();
            }
        }
    }

    private void jobNoLongerRunning(JobInProgress job) {
        assert (Thread.holdsLock((Object)this));
        JobInfo info = this.infos.remove(job);
        if (info != null) {
            info.mapSchedulable.cleanupMetrics();
            info.reduceSchedulable.cleanupMetrics();
        }
        this.poolMgr.removeJob(job);
    }

    public List<PoolSchedulable> getPoolSchedulables(TaskType type) {
        ArrayList<PoolSchedulable> scheds = new ArrayList<PoolSchedulable>();
        for (Pool pool : this.poolMgr.getPools()) {
            scheds.add(pool.getSchedulable(type));
        }
        return scheds;
    }

    private void updateRunnability() {
        for (JobInfo info : this.infos.values()) {
            info.runnable = false;
        }
        ArrayList<JobInProgress> jobs = new ArrayList<JobInProgress>(this.infos.keySet());
        Collections.sort(jobs, new FifoJobComparator());
        HashMap<String, Integer> userJobs = new HashMap<String, Integer>();
        HashMap<String, Integer> poolJobs = new HashMap<String, Integer>();
        for (JobInProgress job : jobs) {
            int poolCount;
            String user = job.getJobConf().getUser();
            String pool = this.poolMgr.getPoolName(job);
            int userCount = userJobs.containsKey(user) ? (Integer)userJobs.get(user) : 0;
            int n = poolCount = poolJobs.containsKey(pool) ? (Integer)poolJobs.get(pool) : 0;
            if (userCount >= this.poolMgr.getUserMaxJobs(user) || poolCount >= this.poolMgr.getPoolMaxJobs(pool) || job.getStatus().getRunState() != 1 && job.getStatus().getRunState() != 4) continue;
            userJobs.put(user, userCount + 1);
            poolJobs.put(pool, poolCount + 1);
            JobInfo jobInfo = this.infos.get(job);
            if (job.getStatus().getRunState() == 1) {
                jobInfo.runnable = true;
                continue;
            }
            if (!jobInfo.needsInitializing) continue;
            jobInfo.needsInitializing = false;
            this.jobInitializer.initJob(jobInfo, job);
        }
    }

    public double getJobWeight(JobInProgress job, TaskType taskType) {
        if (!this.isRunnable(job)) {
            return 1.0;
        }
        double weight = 1.0;
        if (this.sizeBasedWeight) {
            JobInfo info = this.infos.get(job);
            int runnableTasks = taskType == TaskType.MAP ? info.mapSchedulable.getDemand() : info.reduceSchedulable.getDemand();
            weight = Math.log1p(runnableTasks) / Math.log(2.0);
        }
        weight *= this.getPriorityFactor(job.getPriority());
        if (this.weightAdjuster != null) {
            weight = this.weightAdjuster.adjustWeight(job, taskType, weight);
        }
        return weight;
    }

    private double getPriorityFactor(JobPriority priority) {
        switch (priority) {
            case VERY_HIGH: {
                return 4.0;
            }
            case HIGH: {
                return 2.0;
            }
            case NORMAL: {
                return 1.0;
            }
            case LOW: {
                return 0.5;
            }
        }
        return 0.25;
    }

    public PoolManager getPoolManager() {
        return this.poolMgr;
    }

    private int getTotalSlots(TaskType type, ClusterStatus clusterStatus) {
        return type == TaskType.MAP ? clusterStatus.getMaxMapTasks() : clusterStatus.getMaxReduceTasks();
    }

    private void updatePreemptionVariables() {
        long now;
        this.lastPreemptionUpdateTime = now = this.clock.getTime();
        for (TaskType type : MAP_AND_REDUCE) {
            for (PoolSchedulable sched : this.getPoolSchedulables(type)) {
                if (!this.isStarvedForMinShare(sched)) {
                    sched.setLastTimeAtMinShare(now);
                }
                if (!this.isStarvedForFairShare(sched)) {
                    sched.setLastTimeAtHalfFairShare(now);
                }
                this.eventLog.log("PREEMPT_VARS", sched.getName(), type, now - sched.getLastTimeAtMinShare(), now - sched.getLastTimeAtHalfFairShare());
            }
        }
    }

    boolean isStarvedForMinShare(PoolSchedulable sched) {
        int desiredShare = Math.min(sched.getMinShare(), sched.getDemand());
        return sched.getRunningTasks() < desiredShare;
    }

    boolean isStarvedForFairShare(PoolSchedulable sched) {
        int desiredFairShare = (int)Math.floor(Math.min(sched.getFairShare() / 2.0, (double)sched.getDemand()));
        return sched.getRunningTasks() < desiredFairShare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preemptTasksIfNecessary() {
        if (!this.preemptionEnabled) {
            return;
        }
        long curTime = this.clock.getTime();
        if (curTime - this.lastPreemptCheckTime < this.preemptionInterval) {
            return;
        }
        this.lastPreemptCheckTime = curTime;
        TaskTrackerManager taskTrackerManager = this.taskTrackerManager;
        synchronized (taskTrackerManager) {
            FairScheduler fairScheduler = this;
            synchronized (fairScheduler) {
                for (TaskType type : MAP_AND_REDUCE) {
                    List<PoolSchedulable> scheds = this.getPoolSchedulables(type);
                    int tasksToPreempt = 0;
                    for (PoolSchedulable sched : scheds) {
                        tasksToPreempt += this.tasksToPreempt(sched, curTime);
                    }
                    if (tasksToPreempt <= 0) continue;
                    this.eventLog.log("SHOULD_PREEMPT", type, tasksToPreempt);
                    if (this.onlyLogPreemption) continue;
                    this.preemptTasks(scheds, tasksToPreempt);
                }
            }
        }
    }

    private void preemptTasks(List<PoolSchedulable> scheds, int tasksToPreempt) {
        if (scheds.isEmpty() || tasksToPreempt == 0) {
            return;
        }
        TaskType taskType = scheds.get(0).getTaskType();
        ArrayList<TaskStatus> runningTasks = new ArrayList<TaskStatus>();
        for (PoolSchedulable sched : scheds) {
            if (!((double)sched.getRunningTasks() > sched.getFairShare())) continue;
            for (JobSchedulable js : sched.getJobSchedulables()) {
                runningTasks.addAll(this.getRunningTasks(js.getJob(), taskType));
            }
        }
        Collections.sort(runningTasks, new Comparator<TaskStatus>(){

            @Override
            public int compare(TaskStatus t1, TaskStatus t2) {
                if (t1.getStartTime() < t2.getStartTime()) {
                    return 1;
                }
                if (t1.getStartTime() == t2.getStartTime()) {
                    return 0;
                }
                return -1;
            }
        });
        HashMap<Pool, Integer> tasksLeft = new HashMap<Pool, Integer>();
        for (Pool p : this.poolMgr.getPools()) {
            tasksLeft.put(p, p.getSchedulable(taskType).getRunningTasks());
        }
        for (TaskStatus status : runningTasks) {
            JobID jobID = status.getTaskID().getJobID();
            JobInProgress job = this.taskTrackerManager.getJob(jobID);
            Pool pool = this.poolMgr.getPool(job);
            PoolSchedulable sched = pool.getSchedulable(taskType);
            int tasksLeftForPool = (Integer)tasksLeft.get(pool);
            if (!((double)tasksLeftForPool > sched.getFairShare())) continue;
            this.eventLog.log("PREEMPT", status.getTaskID(), status.getTaskTracker());
            try {
                this.taskTrackerManager.killTask(status.getTaskID(), false);
                if (--tasksToPreempt == 0) break;
                tasksLeft.put(pool, --tasksLeftForPool);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to kill task " + status.getTaskID()), (Throwable)e);
            }
        }
    }

    protected int tasksToPreempt(PoolSchedulable sched, long curTime) {
        int tasksToPreempt;
        int target;
        String pool = sched.getName();
        long minShareTimeout = this.poolMgr.getMinSharePreemptionTimeout(pool);
        long fairShareTimeout = this.poolMgr.getFairSharePreemptionTimeout();
        int tasksDueToMinShare = 0;
        int tasksDueToFairShare = 0;
        if (curTime - sched.getLastTimeAtMinShare() > minShareTimeout) {
            target = Math.min(sched.getMinShare(), sched.getDemand());
            tasksDueToMinShare = Math.max(0, target - sched.getRunningTasks());
        }
        if (curTime - sched.getLastTimeAtHalfFairShare() > fairShareTimeout) {
            target = (int)Math.min(sched.getFairShare(), (double)sched.getDemand());
            tasksDueToFairShare = Math.max(0, target - sched.getRunningTasks());
        }
        if ((tasksToPreempt = Math.max(tasksDueToMinShare, tasksDueToFairShare)) > 0) {
            String message = "Should preempt " + tasksToPreempt + " " + sched.getTaskType() + " tasks for pool " + sched.getName() + ": tasksDueToMinShare = " + tasksDueToMinShare + ", tasksDueToFairShare = " + tasksDueToFairShare;
            this.eventLog.log("INFO", message);
            LOG.info((Object)message);
        }
        return tasksToPreempt;
    }

    private List<TaskStatus> getRunningTasks(JobInProgress job, TaskType type) {
        HashSet tips = new HashSet();
        if (type == TaskType.MAP) {
            tips.addAll(job.nonLocalRunningMaps);
            for (Set set : job.runningMapCache.values()) {
                tips.addAll(set);
            }
        } else {
            tips.addAll(job.runningReduces);
        }
        ArrayList<TaskStatus> statuses = new ArrayList<TaskStatus>();
        for (TaskInProgress tip : tips) {
            for (TaskAttemptID id : tip.getActiveTasks().keySet()) {
                TaskStatus stat = tip.getTaskStatus(id);
                if (stat == null) continue;
                statuses.add(stat);
            }
        }
        return statuses;
    }

    protected boolean isRunnable(JobInProgress job) {
        JobInfo info = this.infos.get(job);
        if (info == null) {
            return false;
        }
        return info.runnable;
    }

    public synchronized Collection<JobInProgress> getJobs(String queueName) {
        if (queueName == null) {
            return null;
        }
        Pool myJobPool = this.poolMgr.getPool(queueName);
        return myJobPool.getJobs();
    }

    protected void dumpIfNecessary() {
        long now = this.clock.getTime();
        long timeDelta = now - this.lastDumpTime;
        if (timeDelta > this.dumpInterval && this.eventLog.isEnabled()) {
            this.dump();
            this.lastDumpTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dump() {
        FairSchedulerEventLog fairSchedulerEventLog = this.eventLog;
        synchronized (fairSchedulerEventLog) {
            this.eventLog.log("BEGIN_DUMP", new Object[0]);
            ArrayList<JobInProgress> jobs = new ArrayList<JobInProgress>(this.infos.keySet());
            Collections.sort(jobs, new Comparator<JobInProgress>(){

                @Override
                public int compare(JobInProgress j1, JobInProgress j2) {
                    return (int)Math.signum(j1.getStartTime() - j2.getStartTime());
                }
            });
            for (JobInProgress job : jobs) {
                JobProfile profile = job.getProfile();
                JobInfo info = this.infos.get(job);
                JobSchedulable ms = info.mapSchedulable;
                JobSchedulable rs = info.reduceSchedulable;
                this.eventLog.log("JOB", profile.getJobID(), profile.name, profile.user, job.getPriority(), this.poolMgr.getPoolName(job), job.numMapTasks, ((Schedulable)ms).getRunningTasks(), ((Schedulable)ms).getDemand(), ((Schedulable)ms).getFairShare(), ((Schedulable)ms).getWeight(), job.numReduceTasks, ((Schedulable)rs).getRunningTasks(), ((Schedulable)rs).getDemand(), ((Schedulable)rs).getFairShare(), ((Schedulable)rs).getWeight());
            }
            ArrayList<Pool> pools = new ArrayList<Pool>(this.poolMgr.getPools());
            Collections.sort(pools, new Comparator<Pool>(){

                @Override
                public int compare(Pool p1, Pool p2) {
                    if (p1.isDefaultPool()) {
                        return 1;
                    }
                    if (p2.isDefaultPool()) {
                        return -1;
                    }
                    return p1.getName().compareTo(p2.getName());
                }
            });
            for (Pool pool : pools) {
                int runningMaps = pool.getMapSchedulable().getRunningTasks();
                int runningReduces = pool.getReduceSchedulable().getRunningTasks();
                String name = pool.getName();
                this.eventLog.log("POOL", name, this.poolMgr.getPoolWeight(name), pool.getJobs().size(), this.poolMgr.getAllocation(name, TaskType.MAP), runningMaps, this.poolMgr.getAllocation(name, TaskType.REDUCE), runningReduces);
            }
            this.eventLog.log("END_DUMP", new Object[0]);
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    public FairSchedulerEventLog getEventLog() {
        return this.eventLog;
    }

    public JobInfo getJobInfo(JobInProgress job) {
        return this.infos.get(job);
    }

    boolean isPreemptionEnabled() {
        return this.preemptionEnabled;
    }

    long getLastPreemptionUpdateTime() {
        return this.lastPreemptionUpdateTime;
    }

    public void checkJobSubmission(JobInProgress job) throws UndeclaredPoolException {
        Set<String> declaredPools = this.poolMgr.getDeclaredPools();
        if (!this.allowUndeclaredPools && !declaredPools.contains(this.poolMgr.getPoolName(job))) {
            throw new UndeclaredPoolException("Pool name: '" + this.poolMgr.getPoolName(job) + "' is invalid. Add pool name to the fair scheduler allocation " + "file. Valid pools are: " + StringUtils.join((CharSequence)", ", declaredPools));
        }
    }

    private class MetricsUpdater
    implements Updater {
        private MetricsUpdater() {
        }

        public void doUpdates(MetricsContext context) {
            FairScheduler.this.updateMetrics();
        }
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
            super("FairScheduler update thread");
        }

        @Override
        public void run() {
            while (FairScheduler.this.running) {
                try {
                    Thread.sleep(FairScheduler.this.updateInterval);
                    FairScheduler.this.update();
                    FairScheduler.this.dumpIfNecessary();
                    FairScheduler.this.preemptTasksIfNecessary();
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in fair scheduler UpdateThread", (Throwable)e);
                }
            }
        }
    }

    private class JobListener
    extends JobInProgressListener {
        private JobListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobAdded(JobInProgress job) {
            FairScheduler fairScheduler = FairScheduler.this;
            synchronized (fairScheduler) {
                FairScheduler.this.eventLog.log("JOB_ADDED", job.getJobID());
                JobSchedulable mapSched = (JobSchedulable)ReflectionUtils.newInstance((Class)FairScheduler.this.conf.getClass("mapred.jobtracker.jobSchedulable", JobSchedulable.class, JobSchedulable.class), (Configuration)FairScheduler.this.conf);
                mapSched.init(FairScheduler.this, job, TaskType.MAP);
                JobSchedulable redSched = (JobSchedulable)ReflectionUtils.newInstance((Class)FairScheduler.this.conf.getClass("mapred.jobtracker.jobSchedulable", JobSchedulable.class, JobSchedulable.class), (Configuration)FairScheduler.this.conf);
                redSched.init(FairScheduler.this, job, TaskType.REDUCE);
                JobInfo info = new JobInfo(mapSched, redSched);
                FairScheduler.this.infos.put(job, info);
                FairScheduler.this.poolMgr.addJob(job);
                FairScheduler.this.update();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobRemoved(JobInProgress job) {
            FairScheduler fairScheduler = FairScheduler.this;
            synchronized (fairScheduler) {
                FairScheduler.this.eventLog.log("JOB_REMOVED", job.getJobID());
                FairScheduler.this.jobNoLongerRunning(job);
            }
        }

        public void jobUpdated(JobChangeEvent event) {
            FairScheduler.this.eventLog.log("JOB_UPDATED", event.getJobInProgress().getJobID());
        }
    }

    private class JobInitializer {
        private final int DEFAULT_NUM_THREADS = 1;
        private ThreadPoolExecutor threadPool;
        private TaskTrackerManager ttm;

        public JobInitializer(Configuration conf, TaskTrackerManager ttm) {
            int numThreads = conf.getInt("mapred.jobinit.threads", 1);
            this.threadPool = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            if (this.threadPool.prestartAllCoreThreads() != numThreads) {
                throw new RuntimeException("Failed to pre-start threads in JobInitializer");
            }
            this.ttm = ttm;
        }

        public void initJob(JobInfo jobInfo, JobInProgress job) {
            if (!FairScheduler.this.mockMode) {
                this.threadPool.execute(new InitJob(jobInfo, job));
            } else {
                new InitJob(jobInfo, job).run();
            }
        }

        void terminate() {
            LOG.info((Object)"Shutting down thread pool");
            this.threadPool.shutdownNow();
            try {
                this.threadPool.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        class InitJob
        implements Runnable {
            private JobInfo jobInfo;
            private JobInProgress job;

            public InitJob(JobInfo jobInfo, JobInProgress job) {
                this.jobInfo = jobInfo;
                this.job = job;
            }

            @Override
            public void run() {
                JobInitializer.this.ttm.initJob(this.job);
            }
        }
    }

    static class JobInfo {
        boolean runnable = false;
        volatile boolean needsInitializing = true;
        public JobSchedulable mapSchedulable;
        public JobSchedulable reduceSchedulable;
        LocalityLevel lastMapLocalityLevel;
        long timeWaitedForLocalMap;
        boolean skippedAtLastHeartbeat;

        public JobInfo(JobSchedulable mapSched, JobSchedulable reduceSched) {
            this.mapSchedulable = mapSched;
            this.reduceSchedulable = reduceSched;
            this.lastMapLocalityLevel = LocalityLevel.NODE;
        }
    }
}

