/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    public static void printDOM(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                System.out.print("<?xml version=\"1.0\" ?>");
                XMLUtils.printDOM(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                System.out.println();
                System.out.print("<");
                System.out.print(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    System.out.print(" " + attr.getNodeName().trim() + "=\"" + attr.getNodeValue().trim() + "\"");
                }
                System.out.print(">");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    XMLUtils.printDOM(children.item(i));
                }
                break;
            }
            case 5: {
                System.out.print("&");
                System.out.print(node.getNodeName().trim());
                System.out.print(";");
                break;
            }
            case 4: {
                System.out.print("<![CDATA[");
                System.out.print(node.getNodeValue().trim());
                System.out.print("]]>");
                break;
            }
            case 3: {
                System.out.println();
                System.out.print(node.getNodeValue().trim());
                break;
            }
            case 7: {
                System.out.print("<?");
                System.out.print(node.getNodeName().trim());
                String data = node.getNodeValue().trim();
                System.out.print(" ");
                System.out.print(data);
                System.out.print("?>");
                break;
            }
        }
        if (type == 1) {
            System.out.println();
            System.out.print("</");
            System.out.print(node.getNodeName().trim());
            System.out.print('>');
        }
    }

    public static String getElementValue(String elementName, Element element) throws Exception {
        String value = null;
        NodeList childNodes = element.getElementsByTagName(elementName);
        Element cn = (Element)childNodes.item(0);
        value = cn.getFirstChild().getNodeValue().trim();
        if (value == null) {
            throw new Exception("No element found with given name:" + elementName);
        }
        return value;
    }

    public static Document parse(InputStream fs) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(fs);
            return document;
        }
        catch (SAXParseException spe) {
            System.err.println("\n** Parsing error , line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.err.println(" " + spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public static void writeXmlToFile(String filename, Document document) {
        try {
            DOMSource source = new DOMSource(document);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("TransformerConfigurationException: " + e);
        }
        catch (TransformerException e) {
            System.err.println("TransformerException: " + e);
        }
    }

    public static int countByTagName(String tag, Document document) {
        NodeList list = document.getElementsByTagName(tag);
        return list.getLength();
    }
}

