/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.junit.Assert;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class MetricsAsserts {
    static final Log LOG = LogFactory.getLog(MetricsAsserts.class);

    public static MetricsRecordBuilder getMetrics(MetricsSource source) {
        MetricsBuilder mb = (MetricsBuilder)Mockito.mock(MetricsBuilder.class);
        MetricsRecordBuilder rb = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class, (Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                StringBuilder sb = new StringBuilder();
                for (Object o : args) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(o));
                }
                LOG.debug((Object)(invocation.getMethod().getName() + ": " + sb));
                return invocation.getMock();
            }
        });
        Mockito.when((Object)mb.addRecord(Mockito.anyString())).thenReturn((Object)rb);
        source.getMetrics(mb, true);
        return rb;
    }

    public static void assertGauge(String name, int expected, MetricsRecordBuilder rb) {
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((String)Mockito.eq((Object)name), Mockito.anyString(), Mockito.eq((int)expected));
    }

    public static void assertCounter(String name, int expected, MetricsRecordBuilder rb) {
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((String)Mockito.eq((Object)name), Mockito.anyString(), Mockito.eq((int)expected));
    }

    public static void assertGauge(String name, long expected, MetricsRecordBuilder rb) {
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((String)Mockito.eq((Object)name), Mockito.anyString(), Mockito.eq((long)expected));
    }

    public static void assertCounter(String name, long expected, MetricsRecordBuilder rb) {
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((String)Mockito.eq((Object)name), Mockito.anyString(), Mockito.eq((long)expected));
    }

    public static void assertGauge(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertGauge(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounterGt(String name, long greater, MetricsRecordBuilder rb) {
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((String)Mockito.eq((Object)name), Mockito.anyString(), AdditionalMatchers.gt((long)greater));
    }

    public static void assertCounterGt(String name, long greater, MetricsSource source) {
        MetricsAsserts.assertCounterGt(name, greater, MetricsAsserts.getMetrics(source));
    }

    private static void checkCaptured(ArgumentCaptor<?> captor, String name) {
        Assert.assertEquals((String)("Expected exactly one metric for name " + name), (long)1L, (long)captor.getAllValues().size());
    }

    public static long getLongGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).addGauge((String)Mockito.eq((Object)name), Mockito.anyString(), ((Long)captor.capture()).longValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Long)captor.getValue();
    }

    public static void assertGaugeGt(String name, double greater, MetricsRecordBuilder rb) {
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((String)Mockito.eq((Object)name), Mockito.anyString(), AdditionalMatchers.gt((double)greater));
    }

    public static void assertGaugeGt(String name, double greater, MetricsSource source) {
        MetricsAsserts.assertGaugeGt(name, greater, MetricsAsserts.getMetrics(source));
    }
}

