/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestMiniMRWithDFS;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.HadoopPolicyProvider;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.util.StringUtils;

public class TestServiceLevelAuthorization
extends TestCase {
    private static final String DUMMY_ACL = "nouser nogroup";
    private static final String UNKNOWN_USER = "dev,null";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServiceLevelAuthorization() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            int slaves = 4;
            Configuration conf = new Configuration();
            conf.setClass("hadoop.security.authorization.policyprovider", HadoopPolicyProvider.class, PolicyProvider.class);
            conf.setBoolean("hadoop.security.authorization", true);
            dfs = new MiniDFSCluster(conf, 4, true, null);
            fileSys = dfs.getFileSystem();
            JobConf mrConf = new JobConf(conf);
            mr = new MiniMRCluster(4, fileSys.getUri().toString(), 1, null, null, mrConf);
            mr.setInlineCleanupThreads();
            TestMiniMRWithDFS.runPI(mr, mr.createJobConf(mrConf));
            TestMiniMRWithDFS.runWordCount(mr, mr.createJobConf(mrConf));
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    private void rewriteHadoopPolicyFile(File policyFile) throws IOException {
        FileWriter fos = new FileWriter(policyFile);
        HDFSPolicyProvider policyProvider = new HDFSPolicyProvider();
        fos.write("<configuration>\n");
        for (Service service : policyProvider.getServices()) {
            String key = service.getServiceKey();
            String value = "*";
            if (key.equals("security.refresh.policy.protocol.acl")) {
                value = DUMMY_ACL;
            }
            fos.write("<property><name>" + key + "</name><value>" + value + "</value></property>\n");
            System.err.println("<property><name>" + key + "</name><value>" + value + "</value></property>\n");
        }
        fos.write("</configuration>\n");
        fos.close();
    }

    private void refreshPolicy(Configuration conf) throws IOException {
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        dfsAdmin.refreshServiceAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefresh() throws Exception {
        MiniDFSCluster dfs = null;
        try {
            int slaves = 4;
            final Configuration conf = new Configuration();
            conf.setClass("hadoop.security.authorization.policyprovider", HDFSPolicyProvider.class, PolicyProvider.class);
            conf.setBoolean("hadoop.security.authorization", true);
            dfs = new MiniDFSCluster(conf, 4, true, null);
            this.refreshPolicy(conf);
            String confDir = System.getProperty("test.build.extraconf", "build/test/extraconf");
            String HADOOP_POLICY_FILE = System.getProperty("hadoop.policy.file");
            File policyFile = new File(confDir, HADOOP_POLICY_FILE);
            String policyFileCopy = HADOOP_POLICY_FILE + ".orig";
            FileUtil.copy((File)policyFile, (FileSystem)FileSystem.getLocal((Configuration)conf), (Path)new Path(confDir, policyFileCopy), (boolean)false, (Configuration)conf);
            this.rewriteHadoopPolicyFile(new File(confDir, HADOOP_POLICY_FILE));
            this.refreshPolicy(conf);
            try {
                UserGroupInformation unknownUser = UserGroupInformation.createRemoteUser((String)"unknown");
                unknownUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        TestServiceLevelAuthorization.this.refreshPolicy(conf);
                        return null;
                    }
                });
                TestServiceLevelAuthorization.fail((String)"Refresh of NameNode's policy file cannot be successful!");
            }
            catch (Exception re) {
                System.out.println("Good, refresh worked... refresh failed with: " + StringUtils.stringifyException((Throwable)re));
            }
            finally {
                FileUtil.fullyDelete((File)new File(confDir, HADOOP_POLICY_FILE));
                FileUtil.replaceFile((File)new File(confDir, policyFileCopy), (File)new File(confDir, HADOOP_POLICY_FILE));
            }
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }
}

