/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.ConcurrentModificationException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.impl.Consumer;
import org.apache.hadoop.metrics2.impl.SinkQueue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSinkQueue {
    private static final Log LOG = LogFactory.getLog(TestSinkQueue.class);

    @Test
    public void testCommon() throws Exception {
        SinkQueue q = new SinkQueue(2);
        q.enqueue((Object)1);
        Assert.assertEquals((String)"queue front", (long)1L, (long)((Integer)q.front()).intValue());
        Assert.assertEquals((String)"queue back", (long)1L, (long)((Integer)q.back()).intValue());
        Assert.assertEquals((String)"element", (long)1L, (long)((Integer)q.dequeue()).intValue());
        Assert.assertTrue((String)"should enqueue", (boolean)q.enqueue((Object)2));
        q.consume((Consumer)new Consumer<Integer>(){

            public void consume(Integer e) {
                Assert.assertEquals((String)"element", (long)2L, (long)e.intValue());
            }
        });
        Assert.assertTrue((String)"should enqueue", (boolean)q.enqueue((Object)3));
        Assert.assertEquals((String)"element", (long)3L, (long)((Integer)q.dequeue()).intValue());
        Assert.assertEquals((String)"queue size", (long)0L, (long)q.size());
        Assert.assertEquals((String)"queue front", null, (Object)q.front());
        Assert.assertEquals((String)"queue back", null, (Object)q.back());
    }

    @Test
    public void testEmptyBlocking() throws Exception {
        this.testEmptyBlocking(0);
        this.testEmptyBlocking(100);
    }

    private void testEmptyBlocking(int awhile) throws Exception {
        final SinkQueue q = new SinkQueue(2);
        final Runnable trigger = (Runnable)Mockito.mock(Runnable.class);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Assert.assertEquals((String)"element", (long)1L, (long)((Integer)q.dequeue()).intValue());
                    q.consume((Consumer)new Consumer<Integer>(){

                        public void consume(Integer e) {
                            Assert.assertEquals((String)"element", (long)2L, (long)e.intValue());
                            trigger.run();
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted", (Throwable)e);
                }
            }
        };
        t.start();
        if (awhile > 0) {
            Thread.sleep(awhile);
        }
        q.enqueue((Object)1);
        q.enqueue((Object)2);
        t.join();
        ((Runnable)Mockito.verify((Object)trigger)).run();
    }

    @Test
    public void testFull() throws Exception {
        SinkQueue q = new SinkQueue(1);
        q.enqueue((Object)1);
        Assert.assertTrue((String)"should drop", (!q.enqueue((Object)2) ? 1 : 0) != 0);
        Assert.assertEquals((String)"element", (long)1L, (long)((Integer)q.dequeue()).intValue());
        q.enqueue((Object)3);
        q.consume((Consumer)new Consumer<Integer>(){

            public void consume(Integer e) {
                Assert.assertEquals((String)"element", (long)3L, (long)e.intValue());
            }
        });
        Assert.assertEquals((String)"queue size", (long)0L, (long)q.size());
    }

    @Test
    public void testConsumeAll() throws Exception {
        int capacity = 64;
        SinkQueue q = new SinkQueue(64);
        for (int i = 0; i < 64; ++i) {
            Assert.assertTrue((String)"should enqueue", (boolean)q.enqueue((Object)i));
        }
        Assert.assertTrue((String)"should not enqueue", (!q.enqueue((Object)64) ? 1 : 0) != 0);
        final Runnable trigger = (Runnable)Mockito.mock(Runnable.class);
        q.consumeAll((Consumer)new Consumer<Integer>(){
            private int expected = 0;

            public void consume(Integer e) {
                Assert.assertEquals((String)"element", (long)this.expected++, (long)e.intValue());
                trigger.run();
            }
        });
        ((Runnable)Mockito.verify((Object)trigger, (VerificationMode)Mockito.times((int)64))).run();
    }

    @Test
    public void testConsumerException() throws Exception {
        SinkQueue q = new SinkQueue(1);
        final RuntimeException ex = new RuntimeException("expected");
        q.enqueue((Object)1);
        try {
            q.consume((Consumer)new Consumer<Integer>(){

                public void consume(Integer e) {
                    throw ex;
                }
            });
        }
        catch (Exception expected) {
            Assert.assertSame((String)"consumer exception", (Object)ex, (Object)expected);
        }
        Assert.assertEquals((String)"queue size", (long)1L, (long)q.size());
        Assert.assertEquals((String)"element", (long)1L, (long)((Integer)q.dequeue()).intValue());
    }

    @Test
    public void testClear() {
        SinkQueue q = new SinkQueue(128);
        for (int i = 0; i < q.capacity() + 97; ++i) {
            q.enqueue((Object)i);
        }
        Assert.assertEquals((String)"queue size", (long)q.capacity(), (long)q.size());
        q.clear();
        Assert.assertEquals((String)"queue size", (long)0L, (long)q.size());
    }

    @Test
    public void testHangingConsumer() throws Exception {
        SinkQueue<Integer> q = this.newSleepingConsumerQueue(2, 1, 2);
        Assert.assertEquals((String)"queue back", (long)2L, (long)((Integer)q.back()).intValue());
        Assert.assertTrue((String)"should drop", (!q.enqueue((Object)3) ? 1 : 0) != 0);
        Assert.assertEquals((String)"queue size", (long)2L, (long)q.size());
        Assert.assertEquals((String)"queue head", (long)1L, (long)((Integer)q.front()).intValue());
        Assert.assertEquals((String)"queue back", (long)2L, (long)((Integer)q.back()).intValue());
    }

    @Test
    public void testConcurrentConsumers() throws Exception {
        final SinkQueue<Integer> q = this.newSleepingConsumerQueue(2, 1);
        Assert.assertTrue((String)"should enqueue", (boolean)q.enqueue((Object)2));
        Assert.assertEquals((String)"queue back", (long)2L, (long)((Integer)q.back()).intValue());
        Assert.assertTrue((String)"should drop", (!q.enqueue((Object)3) ? 1 : 0) != 0);
        this.shouldThrowCME(new Fun(){

            @Override
            public void run() {
                q.clear();
            }
        });
        this.shouldThrowCME(new Fun(){

            @Override
            public void run() throws Exception {
                q.consume(null);
            }
        });
        this.shouldThrowCME(new Fun(){

            @Override
            public void run() throws Exception {
                q.consumeAll(null);
            }
        });
        this.shouldThrowCME(new Fun(){

            @Override
            public void run() throws Exception {
                q.dequeue();
            }
        });
        Assert.assertEquals((String)"queue size", (long)2L, (long)q.size());
        Assert.assertEquals((String)"queue front", (long)1L, (long)((Integer)q.front()).intValue());
        Assert.assertEquals((String)"queue back", (long)2L, (long)((Integer)q.back()).intValue());
    }

    private void shouldThrowCME(Fun callback) throws Exception {
        try {
            callback.run();
        }
        catch (ConcurrentModificationException e) {
            LOG.info((Object)e);
            return;
        }
        LOG.error((Object)"should've thrown CME");
        Assert.fail((String)"should've thrown CME");
    }

    private SinkQueue<Integer> newSleepingConsumerQueue(int capacity, int ... values) throws Exception {
        final SinkQueue q = new SinkQueue(capacity);
        for (int i : values) {
            q.enqueue((Object)i);
        }
        final CountDownLatch barrier = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                    q.consume((Consumer)new Consumer<Integer>(){

                        public void consume(Integer e) throws InterruptedException {
                            LOG.info((Object)"sleeping");
                            barrier.countDown();
                            Thread.sleep(86400000L);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Interrupted", (Throwable)ex);
                }
            }
        };
        t.setName("Sleeping consumer");
        t.setDaemon(true);
        t.start();
        barrier.await();
        LOG.debug((Object)"Returning new sleeping consumer queue");
        return q;
    }

    static interface Fun {
        public void run() throws Exception;
    }
}

