/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskTrackerInstrumentation;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskTrackerInstrumentation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartup() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf jtConf = new JobConf();
            jtConf.set("mapred.tasktracker.instrumentation", "org.nowhere.FUBAR");
            mr = new MiniMRCluster(1, "file:///", 1, null, null, jtConf);
            TaskTracker tt = mr.getTaskTrackerRunner(0).getTaskTracker();
            Assert.assertEquals(TaskTrackerInstrumentation.create((TaskTracker)tt).getClass(), mr.getTaskTrackerRunner(0).getTaskTracker().getTaskTrackerInstrumentation().getClass());
        }
        finally {
            mr.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlots() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf jtConf = new JobConf();
            jtConf.set("mapred.tasktracker.instrumentation", MyTaskTrackerMetricsInst.class.getName());
            mr = new MiniMRCluster(1, "file:///", 1, null, null, jtConf);
            MyTaskTrackerMetricsInst instr = (MyTaskTrackerMetricsInst)mr.getTaskTrackerRunner(0).getTaskTracker().getTaskTrackerInstrumentation();
            JobConf conf = mr.createJobConf();
            SleepJob job = new SleepJob();
            job.setConf((Configuration)conf);
            int numMapTasks = 3;
            int numReduceTasks = 2;
            job.run(numMapTasks, numReduceTasks, 1L, 1, 1L, 1);
            MyTaskTrackerMetricsInst myTaskTrackerMetricsInst = instr;
            synchronized (myTaskTrackerMetricsInst) {
                Assert.assertEquals((long)7L, (long)instr.complete);
                Assert.assertEquals((long)7L, (long)instr.end);
                Assert.assertEquals((long)7L, (long)instr.launch);
            }
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static class MyTaskTrackerMetricsInst
    extends TaskTrackerInstrumentation {
        public int complete = 0;
        public int launch = 0;
        public int end = 0;

        public MyTaskTrackerMetricsInst(TaskTracker tracker) {
            super(tracker);
        }

        public void completeTask(TaskAttemptID t) {
            ++this.complete;
        }

        public void reportTaskLaunch(TaskAttemptID t, File stdout, File stderr) {
            ++this.launch;
        }

        public void reportTaskEnd(TaskAttemptID t) {
            ++this.end;
        }
    }
}

