/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.util.Progressable;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestMerger {
    @Test
    public void testUncompressed() throws IOException {
        this.testMergeShouldReturnProperProgress(this.getUncompressedSegments());
    }

    @Test
    public void testCompressed() throws IOException {
        this.testMergeShouldReturnProperProgress(this.getCompressedSegments());
    }

    public void testMergeShouldReturnProperProgress(List<Merger.Segment<Text, Text>> segments) throws IOException {
        Configuration conf = new Configuration();
        JobConf jobConf = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path tmpDir = new Path("localpath");
        Class keyClass = jobConf.getMapOutputKeyClass();
        Class valueClass = jobConf.getMapOutputValueClass();
        RawComparator comparator = jobConf.getOutputKeyComparator();
        Counters.Counter readsCounter = new Counters.Counter();
        Counters.Counter writesCounter = new Counters.Counter();
        RawKeyValueIterator mergeQueue = Merger.merge((Configuration)conf, (FileSystem)fs, (Class)keyClass, (Class)valueClass, segments, (int)2, (Path)tmpDir, (RawComparator)comparator, (Progressable)this.getReporter(), (Counters.Counter)readsCounter, (Counters.Counter)writesCounter);
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(mergeQueue.getProgress().get()));
    }

    private Progressable getReporter() {
        Progressable reporter = new Progressable(){

            public void progress() {
            }
        };
        return reporter;
    }

    private List<Merger.Segment<Text, Text>> getUncompressedSegments() throws IOException {
        ArrayList<Merger.Segment<Text, Text>> segments = new ArrayList<Merger.Segment<Text, Text>>();
        for (int i = 1; i < 10; ++i) {
            segments.add(this.getUncompressedSegment(i));
        }
        return segments;
    }

    private List<Merger.Segment<Text, Text>> getCompressedSegments() throws IOException {
        ArrayList<Merger.Segment<Text, Text>> segments = new ArrayList<Merger.Segment<Text, Text>>();
        for (int i = 1; i < 10; ++i) {
            segments.add(this.getCompressedSegment(i));
        }
        return segments;
    }

    private Merger.Segment<Text, Text> getUncompressedSegment(int i) throws IOException {
        return new Merger.Segment(this.getReader(i), false);
    }

    private Merger.Segment<Text, Text> getCompressedSegment(int i) throws IOException {
        return new Merger.Segment(this.getReader(i), false, 3000L);
    }

    private IFile.Reader<Text, Text> getReader(int i) throws IOException {
        IFile.Reader readerMock = (IFile.Reader)Mockito.mock(IFile.Reader.class);
        Mockito.when((Object)readerMock.getPosition()).thenReturn((Object)0L).thenReturn((Object)10L).thenReturn((Object)20L);
        Mockito.when((Object)readerMock.next((DataInputBuffer)Matchers.any(DataInputBuffer.class), (DataInputBuffer)Matchers.any(DataInputBuffer.class))).thenAnswer(this.getAnswer("Segment" + i));
        return readerMock;
    }

    private Answer<?> getAnswer(final String segmentName) {
        return new Answer<Object>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                DataInputBuffer key = (DataInputBuffer)args[0];
                DataInputBuffer value = (DataInputBuffer)args[1];
                if (this.i++ == 2) {
                    return false;
                }
                key.reset(("Segement Key " + segmentName + this.i).getBytes(), 20);
                value.reset(("Segement Value" + segmentName + this.i).getBytes(), 20);
                return true;
            }
        };
    }
}

