/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterWithLinuxTaskController;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TestTaskTrackerLocalization;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;

public class TestLocalizationWithLinuxTaskController
extends TestTaskTrackerLocalization {
    private static final Log LOG = LogFactory.getLog(TestLocalizationWithLinuxTaskController.class);
    private File configFile;
    private static String taskTrackerUserName;

    @Override
    protected boolean canRun() {
        return ClusterWithLinuxTaskController.shouldRun();
    }

    @Override
    public void setUp() throws Exception {
        if (!this.canRun()) {
            return;
        }
        super.setUp();
        taskTrackerUserName = UserGroupInformation.getLoginUser().getShortUserName();
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.canRun()) {
            return;
        }
        super.tearDown();
        if (this.configFile != null) {
            this.configFile.delete();
        }
    }

    @Override
    protected TaskController getTaskController() {
        return new ClusterWithLinuxTaskController.MyLinuxTaskController();
    }

    @Override
    protected UserGroupInformation getJobOwner() {
        String ugi = System.getProperty("taskcontroller-ugi");
        String[] splits = ugi.split(",");
        return UserGroupInformation.createUserForTesting((String)splits[0], (String[])new String[]{splits[1]});
    }

    @Override
    public void testTaskControllerSetup() {
    }

    @Override
    protected void checkUserLocalization() throws IOException {
        for (String dir : this.localDirs) {
            File localDir = new File(dir);
            Assert.assertTrue((String)("mapred.local.dir " + localDir + " isn'task created!"), (boolean)localDir.exists());
            File taskTrackerSubDir = new File(localDir, "taskTracker");
            Assert.assertTrue((String)("taskTracker sub-dir in the local-dir " + localDir + "is not created!"), (boolean)taskTrackerSubDir.exists());
            String expectedDirPerms = taskTrackerUserName.equals(this.task.getUser()) ? "drwxrws---" : "dr-xrws---";
            File userDir = new File(taskTrackerSubDir, this.task.getUser());
            Assert.assertTrue((String)("user-dir in taskTrackerSubdir " + taskTrackerSubDir + "is not created!"), (boolean)userDir.exists());
            TestLocalizationWithLinuxTaskController.checkFilePermissions(userDir.getAbsolutePath(), expectedDirPerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
            File jobCache = new File(userDir, "jobcache");
            Assert.assertTrue((String)("jobcache in the userDir " + userDir + " isn't created!"), (boolean)jobCache.exists());
            TestLocalizationWithLinuxTaskController.checkFilePermissions(jobCache.getAbsolutePath(), expectedDirPerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
            File distributedCacheDir = new File(localDir, TaskTracker.getPrivateDistributedCacheDir((String)this.task.getUser()));
            Assert.assertTrue((String)("distributed cache dir " + distributedCacheDir + " doesn't exists!"), (boolean)distributedCacheDir.exists());
            TestLocalizationWithLinuxTaskController.checkFilePermissions(distributedCacheDir.getAbsolutePath(), expectedDirPerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        }
    }

    @Override
    protected void checkJobLocalization() throws IOException {
        String expectedDirPerms = taskTrackerUserName.equals(this.task.getUser()) ? "drwxrws---" : "dr-xrws---";
        String expectedFilePerms = taskTrackerUserName.equals(this.task.getUser()) ? "-rwxrwx---" : "-r-xrwx---";
        for (String localDir : this.trackerFConf.getStrings("mapred.local.dir")) {
            File jobDir = new File(localDir, TaskTracker.getLocalJobDir((String)this.task.getUser(), (String)this.jobId.toString()));
            TestLocalizationWithLinuxTaskController.checkFilePermissions(jobDir.getAbsolutePath(), expectedDirPerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        }
        ArrayList<Path> dirs = new ArrayList<Path>();
        Path jarsDir = lDirAlloc.getLocalPathToRead(TaskTracker.getJobJarsDir((String)this.task.getUser(), (String)this.jobId.toString()), (Configuration)this.trackerFConf);
        dirs.add(jarsDir);
        dirs.add(new Path(jarsDir, "lib"));
        for (Path dir : dirs) {
            TestLocalizationWithLinuxTaskController.checkFilePermissions(dir.toUri().getPath(), expectedDirPerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        }
        Path jobWorkDir = lDirAlloc.getLocalPathToRead(TaskTracker.getJobWorkDir((String)this.task.getUser(), (String)this.jobId.toString()), (Configuration)this.trackerFConf);
        TestLocalizationWithLinuxTaskController.checkFilePermissions(jobWorkDir.toUri().getPath(), "drwxrws---", this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        ArrayList<Path> files = new ArrayList<Path>();
        files.add(lDirAlloc.getLocalPathToRead(TaskTracker.getLocalJobConfFile((String)this.task.getUser(), (String)this.jobId.toString()), (Configuration)this.trackerFConf));
        files.add(lDirAlloc.getLocalPathToRead(TaskTracker.getJobJarFile((String)this.task.getUser(), (String)this.jobId.toString()), (Configuration)this.trackerFConf));
        files.add(new Path(jarsDir, "lib/lib1.jar"));
        files.add(new Path(jarsDir, "lib/lib2.jar"));
        for (Path file : files) {
            TestLocalizationWithLinuxTaskController.checkFilePermissions(file.toUri().getPath(), expectedFilePerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        }
        File jobLogDir = TaskLog.getJobDir((JobID)this.jobId);
        TestLocalizationWithLinuxTaskController.checkFilePermissions(jobLogDir.toString(), expectedDirPerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        TestLocalizationWithLinuxTaskController.checkFilePermissions(jobLogDir.toString() + "/" + TaskTracker.jobACLsFile, expectedFilePerms, this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        this.validateJobACLsFileContent();
    }

    @Override
    protected void checkTaskLocalization() throws IOException {
        ArrayList<Path> dirs = new ArrayList<Path>();
        dirs.add(lDirAlloc.getLocalPathToRead(TaskTracker.getLocalTaskDir((String)this.task.getUser(), (String)this.jobId.toString(), (String)this.taskId.toString(), (boolean)this.task.isTaskCleanupTask()), (Configuration)this.trackerFConf));
        dirs.add(this.attemptWorkDir);
        dirs.add(new Path(this.attemptWorkDir, "tmp"));
        dirs.add(new Path(this.attemptLogFiles[1].getParentFile().getAbsolutePath()));
        for (Path dir : dirs) {
            TestLocalizationWithLinuxTaskController.checkFilePermissions(dir.toUri().getPath(), "drwxrws---", this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        }
        ArrayList<Path> files = new ArrayList<Path>();
        files.add(lDirAlloc.getLocalPathToRead(TaskTracker.getTaskConfFile((String)this.task.getUser(), (String)this.task.getJobID().toString(), (String)this.task.getTaskID().toString(), (boolean)this.task.isTaskCleanupTask()), (Configuration)this.trackerFConf));
        for (Path file : files) {
            TestLocalizationWithLinuxTaskController.checkFilePermissions(file.toUri().getPath(), "-rwxrwx---", this.task.getUser(), ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        }
    }
}

