/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FakeObjectUtilities;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.StaticMapping;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobInProgress {
    static final Log LOG = LogFactory.getLog(TestJobInProgress.class);
    private static MiniMRCluster mrCluster;
    private static MiniDFSCluster dfsCluster;
    private static JobTracker jt;
    static final String[] trackers;
    static final String[] hosts;
    static final String[] racks;
    private static Path TEST_DIR;
    private static int numSlaves;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.jobtracker.address", "localhost:0");
        conf.set("mapreduce.jobtracker.http.address", "0.0.0.0:0");
        conf.setClass("topology.node.switch.mapping.impl", StaticMapping.class, DNSToSwitchMapping.class);
        dfsCluster = new MiniDFSCluster(conf, numSlaves, true, null);
        mrCluster = new MiniMRCluster(numSlaves, dfsCluster.getFileSystem().getUri().toString(), 1);
        jt = mrCluster.getJobTrackerRunner().getJobTracker();
        for (int i = 0; i < hosts.length; ++i) {
            StaticMapping.addNodeToRack(hosts[i], racks[i]);
        }
        for (String s : trackers) {
            FakeObjectUtilities.establishFirstContact(jt, s);
        }
    }

    @Test
    public void testPendingMapTaskCount() throws Exception {
        this.launchTask(FailMapTaskJob.class, IdentityReducer.class);
        this.checkTaskCounts();
    }

    @Test
    public void testSlowStartAndFailurePercent() throws Exception {
        this.launchTaskSlowStart(FailMapTaskJob.class, IdentityReducer.class);
        this.checkTaskCounts();
    }

    @Test
    public void testPendingReduceTaskCount() throws Exception {
        this.launchTask(IdentityMapper.class, FailReduceTaskJob.class);
        this.checkTaskCounts();
    }

    private void testRunningTaskCount(boolean speculation, boolean locality) throws Exception {
        LOG.info((Object)("Testing running jobs with speculation : " + speculation + ", locality : " + locality));
        dfsCluster.getFileSystem().delete(TEST_DIR, true);
        Path mapSignalFile = new Path(TEST_DIR, "map-signal");
        Path redSignalFile = new Path(TEST_DIR, "reduce-signal");
        JobConf job = this.configure(UtilsForTests.WaitingMapper.class, IdentityReducer.class, 1, 1, locality);
        job.set(UtilsForTests.getTaskSignalParameter(true), mapSignalFile.toString());
        job.set(UtilsForTests.getTaskSignalParameter(false), redSignalFile.toString());
        job.setFloat("mapred.reduce.slowstart.completed.maps", 0.0f);
        job.setSpeculativeExecution(speculation);
        JobClient jc = new JobClient(job);
        RunningJob running = jc.submitJob(job);
        JobTracker jobtracker = mrCluster.getJobTrackerRunner().getJobTracker();
        JobInProgress jip = jobtracker.getJob(running.getID());
        LOG.info((Object)("Running job " + jip.getJobID()));
        LOG.info((Object)("Waiting for job " + jip.getJobID() + " to be ready"));
        this.waitTillReady(jip, job);
        HashSet uniqueTasks = new HashSet();
        for (Map.Entry s : jip.getRunningMapCache().entrySet()) {
            uniqueTasks.addAll((Collection)s.getValue());
        }
        uniqueTasks.addAll(jip.getNonLocalRunningMaps());
        Assert.assertEquals((String)("Running map count doesnt match for jobs with speculation " + speculation + ", and locality " + locality), (long)jip.runningMaps(), (long)uniqueTasks.size());
        Assert.assertEquals((String)("Running reducer count doesnt match for jobs with speculation " + speculation + ", and locality " + locality), (long)jip.runningReduces(), (long)jip.getRunningReduces().size());
        LOG.info((Object)"Signaling the tasks");
        UtilsForTests.signalTasks(dfsCluster, dfsCluster.getFileSystem(), mapSignalFile.toString(), redSignalFile.toString(), numSlaves);
        LOG.info((Object)("Waiting for job " + jip.getJobID() + " to be complete"));
        UtilsForTests.waitTillDone(jc);
        dfsCluster.getFileSystem().delete(TEST_DIR, true);
    }

    private void waitTillReady(JobInProgress jip, JobConf job) {
        while (jip.runningMaps() < job.getNumMapTasks()) {
            UtilsForTests.waitFor(10L);
        }
        while (jip.runningReduces() < job.getNumReduceTasks()) {
            UtilsForTests.waitFor(10L);
        }
    }

    @Test
    public void testRunningTaskCount() throws Exception {
        this.testRunningTaskCount(false, true);
        this.testRunningTaskCount(true, true);
        this.testRunningTaskCount(false, false);
        this.testRunningTaskCount(true, false);
    }

    @Test
    public void testLocality() throws Exception {
        NetworkTopology nt = new NetworkTopology();
        NodeBase r1n1 = new NodeBase("/default/rack1/node1");
        nt.add((Node)r1n1);
        NodeBase r1n2 = new NodeBase("/default/rack1/node2");
        nt.add((Node)r1n2);
        NodeBase r2n3 = new NodeBase("/default/rack2/node3");
        nt.add((Node)r2n3);
        LOG.debug((Object)("r1n1 parent: " + r1n1.getParent() + "\n" + "r1n2 parent: " + r1n2.getParent() + "\n" + "r2n3 parent: " + r2n3.getParent()));
        Assert.assertEquals((long)0L, (long)JobInProgress.getMatchingLevelForNodes((Node)r1n1, (Node)r1n1, (int)3));
        Assert.assertEquals((long)1L, (long)JobInProgress.getMatchingLevelForNodes((Node)r1n1, (Node)r1n2, (int)3));
        Assert.assertEquals((long)2L, (long)JobInProgress.getMatchingLevelForNodes((Node)r1n1, (Node)r2n3, (int)3));
    }

    @AfterClass
    public static void tearDown() throws Exception {
        mrCluster.shutdown();
        dfsCluster.shutdown();
    }

    void launchTaskSlowStart(Class MapClass3, Class ReduceClass2) throws Exception {
        JobConf job = this.configure(MapClass3, ReduceClass2, 5, 10, true);
        job.setFloat("mapred.reduce.slowstart.completed.maps", 1.0f);
        job.setInt("mapred.max.map.failures.percent", 100);
        try {
            JobClient.runJob((JobConf)job);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    void launchTask(Class MapClass3, Class ReduceClass2) throws Exception {
        JobConf job = this.configure(MapClass3, ReduceClass2, 5, 10, true);
        try {
            JobClient.runJob((JobConf)job);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    JobConf configure(Class MapClass3, Class ReduceClass2, int maps, int reducers, boolean locality) throws Exception {
        JobConf jobConf = mrCluster.createJobConf();
        Path inDir = new Path("./failjob/input");
        Path outDir = new Path("./failjob/output");
        String input = "Test failing job.\n One more line";
        FileSystem inFs = inDir.getFileSystem((Configuration)jobConf);
        FileSystem outFs = outDir.getFileSystem((Configuration)jobConf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("create directory failed" + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        jobConf.setJobName("failmaptask");
        if (locality) {
            jobConf.setInputFormat(TextInputFormat.class);
        } else {
            jobConf.setInputFormat(UtilsForTests.RandomInputFormat.class);
        }
        jobConf.setOutputKeyClass(Text.class);
        jobConf.setOutputValueClass(Text.class);
        jobConf.setMapperClass(MapClass3);
        jobConf.setCombinerClass(ReduceClass2);
        jobConf.setReducerClass(ReduceClass2);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outDir);
        jobConf.setNumMapTasks(maps);
        jobConf.setNumReduceTasks(reducers);
        return jobConf;
    }

    void checkTaskCounts() {
        JobStatus[] status;
        for (JobStatus js : status = jt.getAllJobs()) {
            JobInProgress jip = jt.getJob(js.getJobID());
            Counters counter = jip.getJobCounters();
            long totalTaskCount = counter.getCounter((Enum)JobInProgress.Counter.TOTAL_LAUNCHED_MAPS) + counter.getCounter((Enum)JobInProgress.Counter.TOTAL_LAUNCHED_REDUCES);
            while ((long)jip.getNumTaskCompletionEvents() < totalTaskCount) {
                Assert.assertEquals((Object)true, (Object)(jip.runningMaps() >= 0 ? 1 : 0));
                Assert.assertEquals((Object)true, (Object)(jip.pendingMaps() >= 0 ? 1 : 0));
                Assert.assertEquals((Object)true, (Object)(jip.runningReduces() >= 0 ? 1 : 0));
                Assert.assertEquals((Object)true, (Object)(jip.pendingReduces() >= 0 ? 1 : 0));
            }
        }
    }

    @Test
    public void testScheduleReducesConsiderFailedMapTips() throws Exception {
        JobInProgress jip = (JobInProgress)Mockito.mock(JobInProgress.class);
        Mockito.when((Object)jip.scheduleReduces()).thenCallRealMethod();
        jip.failedMapTIPs = 10;
        jip.finishedMapTasks = 50;
        jip.completedMapsForReduceSlowstart = 60;
        Assert.assertTrue((String)"The Reduce is not scheduled", (boolean)jip.scheduleReduces());
    }

    static {
        trackers = new String[]{"tracker_tracker1.r1.com:1000", "tracker_tracker2.r1.com:1000", "tracker_tracker3.r2.com:1000", "tracker_tracker4.r3.com:1000"};
        hosts = new String[]{"tracker1.r1.com", "tracker2.r1.com", "tracker3.r2.com", "tracker4.r3.com"};
        racks = new String[]{"/r1", "/r1", "/r2", "/r3"};
        TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), "jip-testing");
        numSlaves = 4;
    }

    public static class FailReduceTaskJob
    extends MapReduceBase
    implements Reducer {
        public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Failing Reduce task");
            }
            throw new IllegalArgumentException("Failing Reduce task");
        }
    }

    public static class FailMapTaskJob
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Interrupted MAP task");
            }
            throw new IllegalArgumentException("Failing MAP task");
        }
    }
}

