/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.util.Progressable;

public class TestFileOutputCommitter
extends TestCase {
    private static Path outDir = new Path(System.getProperty("test.build.data", "."), "output");
    private static String attempt = "attempt_200707121733_0001_m_000000_0";
    private static TaskAttemptID taskID = TaskAttemptID.forName((String)attempt);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommitter() throws Exception {
        JobConf job = new JobConf();
        job.set("mapred.task.id", attempt);
        job.setOutputCommitter(FileOutputCommitter.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
        JobContext jContext = new JobContext(job, (JobID)taskID.getJobID());
        TaskAttemptContext tContext = new TaskAttemptContext(job, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)committer.getTempTaskOutputPath(tContext));
        committer.setupJob(jContext);
        committer.setupTask(tContext);
        String file = "test.txt";
        Reporter reporter = Reporter.NULL;
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)job);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((FileSystem)localFs, job, file, (Progressable)reporter);
        Text key1 = new Text("key1");
        Text key2 = new Text("key2");
        Text val1 = new Text("val1");
        Text val2 = new Text("val2");
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)key1, (Object)val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)val1);
            theRecordWriter.write((Object)nullWritable, (Object)val2);
            theRecordWriter.write((Object)key2, (Object)nullWritable);
            theRecordWriter.write((Object)key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)key2, (Object)val2);
        }
        finally {
            theRecordWriter.close(reporter);
        }
        committer.commitTask(tContext);
        committer.commitJob(jContext);
        File expectedFile = new File(new Path(outDir, file).toString());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(key1).append('\t').append(val1).append("\n");
        expectedOutput.append(val1).append("\n");
        expectedOutput.append(val2).append("\n");
        expectedOutput.append(key2).append("\n");
        expectedOutput.append(key1).append("\n");
        expectedOutput.append(key2).append('\t').append(val2).append("\n");
        String output = UtilsForTests.slurp(expectedFile);
        TestFileOutputCommitter.assertEquals((String)output, (String)expectedOutput.toString());
    }

    public static void main(String[] args) throws Exception {
        new TestFileOutputCommitter().testCommitter();
    }
}

