/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;

class FakeCompressor
implements Compressor {
    private boolean finish;
    private boolean finished;
    int nread;
    int nwrite;
    byte[] userBuf;
    int userBufOff;
    int userBufLen;

    FakeCompressor() {
    }

    public int compress(byte[] b, int off, int len) throws IOException {
        int n = Math.min(len, this.userBufLen);
        if (this.userBuf != null && b != null) {
            System.arraycopy(this.userBuf, this.userBufOff, b, off, n);
        }
        this.userBufOff += n;
        this.userBufLen -= n;
        this.nwrite += n;
        if (this.finish && this.userBufLen <= 0) {
            this.finished = true;
        }
        return n;
    }

    public void end() {
    }

    public void finish() {
        this.finish = true;
    }

    public boolean finished() {
        return this.finished;
    }

    public long getBytesRead() {
        return this.nread;
    }

    public long getBytesWritten() {
        return this.nwrite;
    }

    public boolean needsInput() {
        return this.userBufLen <= 0;
    }

    public void reset() {
        this.finish = false;
        this.finished = false;
        this.nread = 0;
        this.nwrite = 0;
        this.userBuf = null;
        this.userBufOff = 0;
        this.userBufLen = 0;
    }

    public void setDictionary(byte[] b, int off, int len) {
    }

    public void setInput(byte[] b, int off, int len) {
        this.nread += len;
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
    }

    public void reinit(Configuration conf) {
    }
}

