/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeRecovery {
    private static final Log LOG = LogFactory.getLog(TestNameNodeRecovery.class);
    private static HdfsConstants.StartupOption recoverStartOpt = HdfsConstants.StartupOption.RECOVER;

    static final void pad(RandomAccessFile rwf, byte b, int amt) throws IOException {
        byte[] buf = new byte[1024];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        while (amt > 0) {
            int len = amt < buf.length ? amt : buf.length;
            rwf.write(buf, 0, len);
            amt -= len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testNameNodeRecoveryImpl(Corruptor corruptor) throws IOException {
        String TEST_PATH = "/test/path/dir";
        String TEST_PATH2 = "/alt/test/path";
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.edits.toleration.length", -1);
        MiniDFSCluster cluster = new MiniDFSCluster(0, conf, 0, true, true, false, HdfsConstants.StartupOption.FORMAT, null, null, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        fileSys.mkdirs(new Path("/test/path/dir"));
        fileSys.mkdirs(new Path("/alt/test/path"));
        List nameEditsDirs = (List)FSNamesystem.getNamespaceEditsDirs((Configuration)conf);
        cluster.shutdown();
        File dir = (File)nameEditsDirs.get(0);
        File editFile = new File(new File(dir, "current"), FSImage.NameNodeFile.EDITS.getName());
        Assert.assertTrue((String)("Should exist: " + editFile), (boolean)editFile.exists());
        corruptor.corrupt(editFile);
        try {
            LOG.debug((Object)"trying to start normally (this should fail)...");
            cluster = new MiniDFSCluster(0, conf, 0, false, true, false, HdfsConstants.StartupOption.REGULAR, null, null, null);
            cluster.waitActive();
            if (corruptor.fatalCorruption()) {
                Assert.fail((String)"expected the truncated edit log to prevent normal startup");
            }
        }
        catch (IOException e) {
            if (!corruptor.fatalCorruption()) {
                Assert.fail((String)"expected to be able to start up normally, but couldn't.");
            }
        }
        finally {
            cluster.shutdown();
        }
        try {
            LOG.debug((Object)"running recovery...");
            cluster = new MiniDFSCluster(0, conf, 0, false, true, false, HdfsConstants.StartupOption.RECOVER, null, null, null);
            cluster.waitActive();
        }
        catch (IOException e) {
            Assert.fail((String)("caught IOException while trying to recover. message was " + e.getMessage() + "\nstack trace\n" + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            cluster.shutdown();
        }
        try {
            cluster = new MiniDFSCluster(0, conf, 0, false, true, false, HdfsConstants.StartupOption.REGULAR, null, null, null);
            cluster.waitActive();
            Assert.assertTrue((boolean)cluster.getFileSystem().exists(new Path("/test/path/dir")));
        }
        catch (IOException e) {
            Assert.fail((String)("failed to recover.  Error message: " + e.getMessage()));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=180000L)
    public void testRecoverTruncatedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new TruncatingCorruptor());
        LOG.debug((Object)"testRecoverTruncatedEditLog: successfully recovered the truncated edit log");
    }

    @Test(timeout=180000L)
    public void testRecoverPaddedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new PaddingCorruptor());
        LOG.debug((Object)"testRecoverPaddedEditLog: successfully recovered the padded edit log");
    }

    @Test(timeout=180000L)
    public void testRecoverZeroPaddedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new SafePaddingCorruptor(0));
    }

    @Test(timeout=180000L)
    public void testRecoverNegativeOnePaddedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new SafePaddingCorruptor(-1));
    }

    static {
        recoverStartOpt.setForce(2);
    }

    static class SafePaddingCorruptor
    implements Corruptor {
        private byte padByte;

        public SafePaddingCorruptor(byte padByte) {
            this.padByte = padByte;
            assert (this.padByte == 0 || this.padByte == -1);
        }

        @Override
        public void corrupt(File editFile) throws IOException {
            RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
            rwf.seek(editFile.length());
            rwf.write(-1);
            TestNameNodeRecovery.pad(rwf, this.padByte, 0x200400);
            rwf.close();
        }

        @Override
        public boolean fatalCorruption() {
            return false;
        }
    }

    static class PaddingCorruptor
    implements Corruptor {
        PaddingCorruptor() {
        }

        @Override
        public void corrupt(File editFile) throws IOException {
            RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
            rwf.seek(editFile.length());
            TestNameNodeRecovery.pad(rwf, (byte)0, 0x200400);
            rwf.write(68);
            rwf.close();
        }

        @Override
        public boolean fatalCorruption() {
            return true;
        }
    }

    static class TruncatingCorruptor
    implements Corruptor {
        TruncatingCorruptor() {
        }

        @Override
        public void corrupt(File editFile) throws IOException {
            long fileLen = editFile.length();
            RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
            rwf.setLength(fileLen - 1L);
            rwf.close();
        }

        @Override
        public boolean fatalCorruption() {
            return true;
        }
    }

    static interface Corruptor {
        public void corrupt(File var1) throws IOException;

        public boolean fatalCorruption();
    }
}

