/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileAppend4;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSyncingWriterInterrupted {
    static final Log LOG = LogFactory.getLog(TestFileAppend4.class);
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.support.broken.append", true);
        this.conf.setInt("dfs.client.block.recovery.retries", 1);
    }

    @Test(timeout=90000L)
    public void testWriterInterrupted() throws Exception {
        int repl = 3;
        int numWrites = 20000;
        MiniDFSCluster cluster = new MiniDFSCluster(this.conf, repl, true, null);
        FileSystem fs1 = cluster.getFileSystem();
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
        Path path = new Path("/testWriterInterrupted");
        FSDataOutputStream stm = fs1.create(path);
        byte[] toWrite = AppendTestUtil.randomBytes(0L, 5);
        CountDownLatch countdown = new CountDownLatch(1);
        AtomicReference<Throwable> thrown = new AtomicReference<Throwable>();
        AppendTestUtil.WriterThread writerThread = new AppendTestUtil.WriterThread(stm, toWrite, thrown, countdown, numWrites);
        writerThread.start();
        countdown.countDown();
        while (writerThread.getNumWritten() == 0 && thrown.get() == null && writerThread.isAlive()) {
            System.err.println("Waiting for writer to start");
            Thread.sleep(10L);
        }
        Assert.assertTrue((boolean)writerThread.isAlive());
        if (thrown.get() != null) {
            throw new RuntimeException(thrown.get());
        }
        AppendTestUtil.loseLeases(fs1);
        AppendTestUtil.recoverFile(cluster, fs2, path);
        while (thrown.get() == null) {
            LOG.info((Object)"Waiting for writer thread to get expected exception");
            Thread.sleep(1000L);
        }
        Assert.assertNotNull((Object)thrown.get());
        int expectedEdits = writerThread.getNumWritten();
        int gotEdits = (int)(fs2.getFileStatus(path).getLen() / (long)toWrite.length);
        Assert.assertTrue((String)("Expected at least " + expectedEdits + " edits, got " + gotEdits), (gotEdits >= expectedEdits ? 1 : 0) != 0);
    }
}

