/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.mapred.CapacitySchedulerQueue;
import org.apache.hadoop.mapred.CapacityTaskScheduler;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.StringUtils;

public class CapacitySchedulerServlet
extends HttpServlet {
    private static final long serialVersionUID = 9104070533067306659L;
    private transient CapacityTaskScheduler scheduler;
    private transient JobTracker jobTracker;

    public void init() throws ServletException {
        super.init();
        ServletContext servletContext = this.getServletContext();
        this.scheduler = (CapacityTaskScheduler)((Object)servletContext.getAttribute("scheduler"));
        this.jobTracker = (JobTracker)this.scheduler.taskTrackerManager;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        String hostname = StringUtils.simpleHostname((String)this.jobTracker.getJobTrackerMachine());
        out.print("<html><head>");
        out.printf("<title>%s Job Scheduler Admininstration</title>\n", hostname);
        out.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n");
        out.print("<script type=\"text/javascript\" src=\"/static/sorttable.js\"></script> \n");
        out.print("</head><body>\n");
        out.printf("<h1><a href=\"/jobtracker.jsp\">%s</a> Job Scheduler Administration</h1>\n", hostname);
        this.showQueues(out);
        out.print("</body></html>\n");
        out.close();
        ServletOutputStream servletOut = response.getOutputStream();
        baos.writeTo((OutputStream)servletOut);
        servletOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showQueues(PrintWriter out) throws IOException {
        CapacityTaskScheduler capacityTaskScheduler = this.scheduler;
        synchronized (capacityTaskScheduler) {
            out.print("<h2>Queues</h2>\n");
            out.print("<table border=\"2\" cellpadding=\"5\"  cellspacing=\"2\" class=\"sortable\"> \n");
            out.print("<tr><th>Queue</th><th>Running Jobs</th><th>Pending Jobs</th><th>Capacity Percentage</th><th>Map Task Capacity</th><th>Map Task Used Capacity</th><th>Running Maps</th><th>Reduce Task Capacity</th><th>Reduce Task Used Capacity</th><th>Running Reduces </tr>\n");
            for (CapacitySchedulerQueue queue : this.scheduler.getQueueInfoMap().values()) {
                String queueName = queue.getQueueName();
                out.print("<tr>\n");
                out.printf("<td><a href=\"jobqueue_details.jsp?queueName=%s\">%s</a></td>\n", queueName, queueName);
                out.printf("<td>%s</td>\n", queue.getNumRunningJobs() + queue.getNumInitializingJobs());
                out.printf("<td>%s</td>\n", queue.getNumWaitingJobs());
                out.printf("<td>%.1f%%</td>\n", Float.valueOf(queue.getCapacityPercent()));
                int mapCapacity = queue.getCapacity(TaskType.MAP);
                int mapSlotsOccupied = queue.getNumSlotsOccupied(TaskType.MAP);
                int reduceSlotsOccupied = queue.getNumSlotsOccupied(TaskType.REDUCE);
                float occupiedSlotsAsPercent = mapCapacity != 0 ? (float)mapSlotsOccupied * 100.0f / (float)mapCapacity : 0.0f;
                out.printf("<td>%s</td>\n", mapCapacity);
                out.printf("<td>%s (%.1f%% of Capacity)</td>\n", mapSlotsOccupied, Float.valueOf(occupiedSlotsAsPercent));
                out.printf("<td>%s</td>\n", queue.getNumRunningTasks(TaskType.MAP));
                int reduceCapacity = queue.getCapacity(TaskType.REDUCE);
                float redOccupiedSlotsAsPercent = reduceCapacity != 0 ? (float)reduceSlotsOccupied * 100.0f / (float)mapCapacity : 0.0f;
                out.printf("<td>%s</td>\n", reduceCapacity);
                out.printf("<td>%s (%.1f%% of Capacity)</td>\n", reduceSlotsOccupied, Float.valueOf(redOccupiedSlotsAsPercent));
                out.printf("<td>%s</td>\n", queue.getNumRunningTasks(TaskType.REDUCE));
            }
            out.print("</table>\n");
        }
    }
}

