/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoEventType;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterEvent;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.executor.IoEventQueueHandler;
import org.apache.mina.filter.executor.OrderedThreadPoolExecutor;

public class ExecutorFilter
extends IoFilterAdapter {
    private final EnumSet<IoEventType> eventTypes;
    private final Executor executor;
    private final boolean createdExecutor;

    public ExecutorFilter() {
        this(16, (IoEventType[])null);
    }

    public ExecutorFilter(int maximumPoolSize) {
        this(0, maximumPoolSize, (IoEventType[])null);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize) {
        this(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, (IoEventType[])null);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, (IoEventType[])null);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, IoEventQueueHandler queueHandler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), queueHandler, (IoEventType[])null);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, (IoEventQueueHandler)null, (IoEventType[])null);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, IoEventQueueHandler queueHandler) {
        this((Executor)new OrderedThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, queueHandler), true, (IoEventType[])null);
    }

    public ExecutorFilter(IoEventType ... eventTypes) {
        this(16, eventTypes);
    }

    public ExecutorFilter(int maximumPoolSize, IoEventType ... eventTypes) {
        this(0, maximumPoolSize, eventTypes);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, IoEventType ... eventTypes) {
        this(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, eventTypes);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, IoEventType ... eventTypes) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), eventTypes);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, IoEventQueueHandler queueHandler, IoEventType ... eventTypes) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), queueHandler, eventTypes);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, IoEventType ... eventTypes) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, (IoEventQueueHandler)null, eventTypes);
    }

    public ExecutorFilter(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, IoEventQueueHandler queueHandler, IoEventType ... eventTypes) {
        this((Executor)new OrderedThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, queueHandler), true, eventTypes);
    }

    public ExecutorFilter(Executor executor) {
        this(executor, false, (IoEventType[])null);
    }

    public ExecutorFilter(Executor executor, IoEventType ... eventTypes) {
        this(executor, false, eventTypes);
    }

    private ExecutorFilter(Executor executor, boolean createdExecutor, IoEventType ... eventTypes) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (eventTypes == null || eventTypes.length == 0) {
            eventTypes = new IoEventType[]{IoEventType.EXCEPTION_CAUGHT, IoEventType.MESSAGE_RECEIVED, IoEventType.MESSAGE_SENT, IoEventType.SESSION_CLOSED, IoEventType.SESSION_IDLE, IoEventType.SESSION_OPENED};
        }
        for (IoEventType t : eventTypes) {
            if (t != IoEventType.SESSION_CREATED) continue;
            throw new IllegalArgumentException((Object)((Object)IoEventType.SESSION_CREATED) + " is not allowed.");
        }
        this.executor = executor;
        this.createdExecutor = createdExecutor;
        ArrayList eventTypeCollection = new ArrayList(eventTypes.length);
        Collections.addAll(eventTypeCollection, eventTypes);
        this.eventTypes = EnumSet.copyOf(eventTypeCollection);
    }

    public void destroy() {
        if (this.createdExecutor) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    public final Executor getExecutor() {
        return this.executor;
    }

    protected void fireEvent(IoFilterEvent event) {
        this.getExecutor().execute(event);
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
    }

    public final void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        nextFilter.sessionCreated(session);
    }

    public final void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        if (this.eventTypes.contains((Object)IoEventType.SESSION_OPENED)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.SESSION_OPENED, session, null));
        } else {
            nextFilter.sessionOpened(session);
        }
    }

    public final void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        if (this.eventTypes.contains((Object)IoEventType.SESSION_CLOSED)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.SESSION_CLOSED, session, null));
        } else {
            nextFilter.sessionClosed(session);
        }
    }

    public final void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        if (this.eventTypes.contains((Object)IoEventType.SESSION_IDLE)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.SESSION_IDLE, session, status));
        } else {
            nextFilter.sessionIdle(session, status);
        }
    }

    public final void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        if (this.eventTypes.contains((Object)IoEventType.EXCEPTION_CAUGHT)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.EXCEPTION_CAUGHT, session, cause));
        } else {
            nextFilter.exceptionCaught(session, cause);
        }
    }

    public final void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (this.eventTypes.contains((Object)IoEventType.MESSAGE_RECEIVED)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.MESSAGE_RECEIVED, session, message));
        } else {
            nextFilter.messageReceived(session, message);
        }
    }

    public final void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        if (this.eventTypes.contains((Object)IoEventType.MESSAGE_SENT)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.MESSAGE_SENT, session, writeRequest));
        } else {
            nextFilter.messageSent(session, writeRequest);
        }
    }

    public final void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        if (this.eventTypes.contains((Object)IoEventType.WRITE)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.WRITE, session, writeRequest));
        } else {
            nextFilter.filterWrite(session, writeRequest);
        }
    }

    public final void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (this.eventTypes.contains((Object)IoEventType.CLOSE)) {
            this.fireEvent(new IoFilterEvent(nextFilter, IoEventType.CLOSE, session, null));
        } else {
            nextFilter.filterClose(session);
        }
    }
}

