/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.ReadFuture;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.WriteRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IoSession {
    public long getId();

    public IoService getService();

    public IoHandler getHandler();

    public IoSessionConfig getConfig();

    public IoFilterChain getFilterChain();

    public TransportMetadata getTransportMetadata();

    public ReadFuture read();

    public WriteFuture write(Object var1);

    public WriteFuture write(Object var1, SocketAddress var2);

    public CloseFuture close();

    public CloseFuture closeOnFlush();

    public CloseFuture close(boolean var1);

    @Deprecated
    public Object getAttachment();

    @Deprecated
    public Object setAttachment(Object var1);

    public Object getAttribute(Object var1);

    public Object getAttribute(Object var1, Object var2);

    public Object setAttribute(Object var1, Object var2);

    public Object setAttribute(Object var1);

    public Object setAttributeIfAbsent(Object var1, Object var2);

    public Object setAttributeIfAbsent(Object var1);

    public Object removeAttribute(Object var1);

    public boolean removeAttribute(Object var1, Object var2);

    public boolean replaceAttribute(Object var1, Object var2, Object var3);

    public boolean containsAttribute(Object var1);

    public Set<Object> getAttributeKeys();

    public boolean isConnected();

    public boolean isClosing();

    public CloseFuture getCloseFuture();

    public SocketAddress getRemoteAddress();

    public SocketAddress getLocalAddress();

    public SocketAddress getServiceAddress();

    public TrafficMask getTrafficMask();

    public void setTrafficMask(TrafficMask var1);

    public void suspendRead();

    public void suspendWrite();

    public void resumeRead();

    public void resumeWrite();

    public long getReadBytes();

    public long getWrittenBytes();

    public long getReadMessages();

    public long getWrittenMessages();

    public double getReadBytesThroughput();

    public double getWrittenBytesThroughput();

    public double getReadMessagesThroughput();

    public double getWrittenMessagesThroughput();

    public int getScheduledWriteMessages();

    public long getScheduledWriteBytes();

    public Object getCurrentWriteMessage();

    public WriteRequest getCurrentWriteRequest();

    public long getCreationTime();

    public long getLastIoTime();

    public long getLastReadTime();

    public long getLastWriteTime();

    public boolean isIdle(IdleStatus var1);

    public boolean isReaderIdle();

    public boolean isWriterIdle();

    public boolean isBothIdle();

    public int getIdleCount(IdleStatus var1);

    public int getReaderIdleCount();

    public int getWriterIdleCount();

    public int getBothIdleCount();

    public long getLastIdleTime(IdleStatus var1);

    public long getLastReaderIdleTime();

    public long getLastWriterIdleTime();

    public long getLastBothIdleTime();
}

