/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.AbstractIoService;
import org.apache.mina.common.AbstractIoSession;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.common.WriteTimeoutException;
import org.apache.mina.util.ConcurrentHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdleStatusChecker {
    private final Set<AbstractIoSession> sessions = new ConcurrentHashSet<AbstractIoSession>();
    private final Set<AbstractIoService> services = new ConcurrentHashSet<AbstractIoService>();
    private final NotifyingTask notifyingTask = new NotifyingTaskImpl();
    private final IoFutureListener<IoFuture> sessionCloseListener = new SessionCloseListener();

    public void addSession(AbstractIoSession session) {
        this.sessions.add(session);
        session.getCloseFuture().addListener(this.sessionCloseListener);
    }

    public void addService(AbstractIoService service) {
        this.services.add(service);
    }

    public void removeSession(AbstractIoSession session) {
        this.sessions.remove(session);
    }

    public void removeService(AbstractIoService service) {
        this.services.remove(service);
    }

    public NotifyingTask getNotifyingTask() {
        return this.notifyingTask;
    }

    public static void notifyIdleness(Iterator<? extends IoSession> sessions, long currentTime) {
        IoSession s = null;
        while (sessions.hasNext()) {
            s = sessions.next();
            IdleStatusChecker.notifyIdleSession(s, currentTime);
        }
    }

    public static void notifyIdleness(IoService service, long currentTime) {
        IdleStatusChecker.notifyIdleness(service, currentTime, true);
    }

    private static void notifyIdleness(IoService service, long currentTime, boolean includeSessions) {
        if (!(service instanceof AbstractIoService)) {
            return;
        }
        ((AbstractIoService)service).notifyIdleness(currentTime);
        if (includeSessions) {
            IdleStatusChecker.notifyIdleness(service.getManagedSessions().iterator(), currentTime);
        }
    }

    public static void notifyIdleSession(IoSession session, long currentTime) {
        if (session instanceof AbstractIoSession) {
            AbstractIoSession s = (AbstractIoSession)session;
            IdleStatusChecker.notifyIdleSession1(s, currentTime, s.getConfig().getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(s.getLastIoTime(), s.getLastIdleTime(IdleStatus.BOTH_IDLE)));
            IdleStatusChecker.notifyIdleSession1(s, currentTime, s.getConfig().getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(s.getLastReadTime(), s.getLastIdleTime(IdleStatus.READER_IDLE)));
            IdleStatusChecker.notifyIdleSession1(s, currentTime, s.getConfig().getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(s.getLastWriteTime(), s.getLastIdleTime(IdleStatus.WRITER_IDLE)));
            IdleStatusChecker.notifyWriteTimeout(s, currentTime);
            IdleStatusChecker.updateThroughput(s, currentTime);
        } else {
            IdleStatusChecker.notifyIdleSession0(session, currentTime, session.getConfig().getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
            IdleStatusChecker.notifyIdleSession0(session, currentTime, session.getConfig().getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
            IdleStatusChecker.notifyIdleSession0(session, currentTime, session.getConfig().getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        }
    }

    private static void notifyIdleSession0(IoSession session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.getFilterChain().fireSessionIdle(status);
        }
    }

    private static void notifyIdleSession1(AbstractIoSession session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.getFilterChain().fireSessionIdle(status);
        }
    }

    private static void notifyWriteTimeout(AbstractIoSession session, long currentTime) {
        WriteRequest request;
        long writeTimeout = session.getConfig().getWriteTimeoutInMillis();
        if (writeTimeout > 0L && currentTime - session.getLastWriteTime() >= writeTimeout && !session.getWriteRequestQueue().isEmpty(session) && (request = session.getCurrentWriteRequest()) != null) {
            session.setCurrentWriteRequest(null);
            WriteTimeoutException cause = new WriteTimeoutException(request);
            request.getFuture().setException(cause);
            session.getFilterChain().fireExceptionCaught(cause);
            session.close();
        }
    }

    private static void updateThroughput(AbstractIoSession session, long currentTime) {
        session.updateThroughput(currentTime, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionCloseListener
    implements IoFutureListener<IoFuture> {
        private SessionCloseListener() {
        }

        @Override
        public void operationComplete(IoFuture future) {
            IdleStatusChecker.this.removeSession((AbstractIoSession)future.getSession());
        }
    }

    private class NotifyingTaskImpl
    implements NotifyingTask {
        private volatile boolean cancelled;
        private volatile Thread thread;

        private NotifyingTaskImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                this.thread = Thread.currentThread();
                block5: while (true) {
                    while (!this.cancelled) {
                        long currentTime = System.currentTimeMillis();
                        this.notifyServices(currentTime);
                        this.notifySessions(currentTime);
                        try {
                            Thread.sleep(1000L);
                            continue block5;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break block7;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    this.thread = null;
                }
            }
        }

        public void cancel() {
            this.cancelled = true;
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        private void notifyServices(long currentTime) {
            for (AbstractIoService service : IdleStatusChecker.this.services) {
                if (!service.isActive()) continue;
                IdleStatusChecker.notifyIdleness(service, currentTime, false);
            }
        }

        private void notifySessions(long currentTime) {
            for (AbstractIoSession session : IdleStatusChecker.this.sessions) {
                if (!session.isConnected()) continue;
                IdleStatusChecker.notifyIdleSession(session, currentTime);
            }
        }
    }

    public static interface NotifyingTask
    extends Runnable {
        public void cancel();
    }
}

