/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.distcp2.CopyListing;
import org.apache.hadoop.tools.distcp2.DistCpOptions;
import org.apache.hadoop.tools.distcp2.GlobbedCopyListing;

public class FileBasedCopyListing
extends CopyListing {
    private final CopyListing globbedListing;

    public FileBasedCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
        this.globbedListing = new GlobbedCopyListing(this.getConf(), credentials);
    }

    @Override
    protected void validatePaths(DistCpOptions options) throws IOException, CopyListing.InvalidInputException {
    }

    @Override
    public void doBuildListing(Path pathToListFile, DistCpOptions options) throws IOException {
        DistCpOptions newOption = new DistCpOptions(options);
        newOption.setSourcePaths(this.fetchFileList(options.getSourceFileListing()));
        this.globbedListing.buildListing(pathToListFile, newOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> fetchFileList(Path sourceListing) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fs = sourceListing.getFileSystem(this.getConf());
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader((InputStream)fs.open(sourceListing)));
            String line = input.readLine();
            while (line != null) {
                result.add(new Path(line));
                line = input.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(input);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)input);
        return result;
    }

    @Override
    protected long getBytesToCopy() {
        return this.globbedListing.getBytesToCopy();
    }

    @Override
    protected long getNumberOfPaths() {
        return this.globbedListing.getNumberOfPaths();
    }
}

