/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.AbstractUserManager;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.ConcurrentLoginRequest;
import org.apache.ftpserver.usermanager.TransferRatePermission;
import org.apache.ftpserver.usermanager.TransferRateRequest;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.usermanager.WritePermission;
import org.apache.ftpserver.usermanager.WriteRequest;
import org.apache.ftpserver.util.BaseProperties;
import org.apache.ftpserver.util.EncryptUtils;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUserManager
extends AbstractUserManager {
    private final Logger LOG = LoggerFactory.getLogger(PropertiesUserManager.class);
    private static final String DEPRECATED_PREFIX = "FtpServer.user.";
    private static final String PREFIX = "ftpserver.user.";
    private BaseProperties userDataProp;
    private File userDataFile = new File("./res/user.gen");
    private boolean isPasswordEncrypt = true;
    private boolean isConfigured = false;

    public void setPropFile(File propFile) {
        if (this.isConfigured) {
            throw new IllegalStateException("Must be called before configure()");
        }
        this.userDataFile = propFile;
    }

    public boolean isEncryptPassword() {
        return this.isPasswordEncrypt;
    }

    public void setEncryptPasswords(boolean encryptPassword) {
        if (this.isConfigured) {
            throw new IllegalStateException("Must be called before configure()");
        }
        this.isPasswordEncrypt = encryptPassword;
    }

    public void setPropPasswordEncrypt(boolean encryptPassword) {
        this.setEncryptPasswords(encryptPassword);
    }

    public void configure() {
        this.isConfigured = true;
        File dir = this.userDataFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            String dirName = dir.getAbsolutePath();
            throw new FtpServerConfigurationException("Cannot create directory for user data file : " + dirName);
        }
        if (!this.userDataFile.exists()) {
            try {
                this.userDataFile.createNewFile();
            }
            catch (IOException e) {
                throw new FtpServerConfigurationException("Cannot user data file : " + this.userDataFile.getAbsolutePath(), e);
            }
        }
        try {
            this.userDataProp = new BaseProperties(this.userDataFile);
        }
        catch (IOException e) {
            throw new FtpServerConfigurationException("Error loading user data file : " + this.userDataFile.getAbsolutePath(), e);
        }
        this.convertDeprecatedPropertyNames();
    }

    private void convertDeprecatedPropertyNames() {
        Enumeration<?> keys = this.userDataProp.propertyNames();
        boolean doSave = false;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(DEPRECATED_PREFIX)) continue;
            String newKey = PREFIX + key.substring(DEPRECATED_PREFIX.length());
            this.userDataProp.setProperty(newKey, this.userDataProp.getProperty(key));
            this.userDataProp.remove(key);
            doSave = true;
        }
        if (doSave) {
            try {
                this.saveUserData();
            }
            catch (FtpException e) {
                throw new FtpServerConfigurationException("Failed to save updated user data", e);
            }
        }
    }

    public synchronized void save(User usr) throws FtpException {
        if (usr.getName() == null) {
            throw new NullPointerException("User name is null.");
        }
        String thisPrefix = PREFIX + usr.getName() + '.';
        this.userDataProp.setProperty(thisPrefix + "userpassword", this.getPassword(usr));
        String home = usr.getHomeDirectory();
        if (home == null) {
            home = "/";
        }
        this.userDataProp.setProperty(thisPrefix + "homedirectory", home);
        this.userDataProp.setProperty(thisPrefix + "enableflag", usr.getEnabled());
        this.userDataProp.setProperty(thisPrefix + "writepermission", usr.authorize((AuthorizationRequest)new WriteRequest()) != null);
        this.userDataProp.setProperty(thisPrefix + "idletime", usr.getMaxIdleTime());
        TransferRateRequest transferRateRequest = new TransferRateRequest();
        transferRateRequest = (TransferRateRequest)usr.authorize((AuthorizationRequest)transferRateRequest);
        if (transferRateRequest != null) {
            this.userDataProp.setProperty(thisPrefix + "uploadrate", transferRateRequest.getMaxUploadRate());
            this.userDataProp.setProperty(thisPrefix + "downloadrate", transferRateRequest.getMaxDownloadRate());
        } else {
            this.userDataProp.remove(thisPrefix + "uploadrate");
            this.userDataProp.remove(thisPrefix + "downloadrate");
        }
        ConcurrentLoginRequest concurrentLoginRequest = new ConcurrentLoginRequest(0, 0);
        concurrentLoginRequest = (ConcurrentLoginRequest)usr.authorize((AuthorizationRequest)concurrentLoginRequest);
        if (concurrentLoginRequest != null) {
            this.userDataProp.setProperty(thisPrefix + "maxloginnumber", concurrentLoginRequest.getMaxConcurrentLogins());
            this.userDataProp.setProperty(thisPrefix + "maxloginperip", concurrentLoginRequest.getMaxConcurrentLoginsPerIP());
        } else {
            this.userDataProp.remove(thisPrefix + "maxloginnumber");
            this.userDataProp.remove(thisPrefix + "maxloginperip");
        }
        this.saveUserData();
    }

    private void saveUserData() throws FtpException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.userDataFile);
            this.userDataProp.store(fos, "Generated file - don't edit (please)");
        }
        catch (IOException ex) {
            try {
                this.LOG.error("Failed saving user data", (Throwable)ex);
                throw new FtpException("Failed saving user data", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(fos);
                throw throwable;
            }
        }
        IoUtils.close(fos);
    }

    public synchronized void delete(String usrName) throws FtpException {
        String thisPrefix = PREFIX + usrName + '.';
        Enumeration<?> propNames = this.userDataProp.propertyNames();
        ArrayList<String> remKeys = new ArrayList<String>();
        while (propNames.hasMoreElements()) {
            String thisKey = propNames.nextElement().toString();
            if (!thisKey.startsWith(thisPrefix)) continue;
            remKeys.add(thisKey);
        }
        Iterator remKeysIt = remKeys.iterator();
        while (remKeysIt.hasNext()) {
            this.userDataProp.remove(((String)remKeysIt.next()).toString());
        }
        this.saveUserData();
    }

    private String getPassword(User usr) {
        String name = usr.getName();
        String password = usr.getPassword();
        if (password != null) {
            if (this.isPasswordEncrypt) {
                password = EncryptUtils.encryptMD5(password);
            }
        } else {
            String blankPassword = "";
            if (this.isPasswordEncrypt) {
                blankPassword = EncryptUtils.encryptMD5("");
            }
            if (this.doesExist(name)) {
                String key = PREFIX + name + '.' + "userpassword";
                password = this.userDataProp.getProperty(key, blankPassword);
            } else {
                password = blankPassword;
            }
        }
        return password;
    }

    public synchronized String[] getAllUserNames() {
        String suffix = ".homedirectory";
        ArrayList<String> ulst = new ArrayList<String>();
        Enumeration<?> allKeys = this.userDataProp.propertyNames();
        int prefixlen = PREFIX.length();
        int suffixlen = suffix.length();
        while (allKeys.hasMoreElements()) {
            String key = (String)allKeys.nextElement();
            if (!key.endsWith(suffix)) continue;
            String name = key.substring(prefixlen);
            int endIndex = name.length() - suffixlen;
            name = name.substring(0, endIndex);
            ulst.add(name);
        }
        Collections.sort(ulst);
        return ulst.toArray(new String[0]);
    }

    public synchronized User getUserByName(String userName) {
        if (!this.doesExist(userName)) {
            return null;
        }
        String baseKey = PREFIX + userName + '.';
        BaseUser user = new BaseUser();
        user.setName(userName);
        user.setEnabled(this.userDataProp.getBoolean(baseKey + "enableflag", true));
        user.setHomeDirectory(this.userDataProp.getProperty(baseKey + "homedirectory", "/"));
        ArrayList<Object> authorities = new ArrayList<Object>();
        if (this.userDataProp.getBoolean(baseKey + "writepermission", false)) {
            authorities.add(new WritePermission());
        }
        int maxLogin = this.userDataProp.getInteger(baseKey + "maxloginnumber", 0);
        int maxLoginPerIP = this.userDataProp.getInteger(baseKey + "maxloginperip", 0);
        authorities.add(new ConcurrentLoginPermission(maxLogin, maxLoginPerIP));
        int uploadRate = this.userDataProp.getInteger(baseKey + "uploadrate", 0);
        int downloadRate = this.userDataProp.getInteger(baseKey + "downloadrate", 0);
        authorities.add(new TransferRatePermission(downloadRate, uploadRate));
        user.setAuthorities(authorities.toArray(new Authority[0]));
        user.setMaxIdleTime(this.userDataProp.getInteger(baseKey + "idletime", 0));
        return user;
    }

    public synchronized boolean doesExist(String name) {
        String key = PREFIX + name + '.' + "homedirectory";
        return this.userDataProp.containsKey(key);
    }

    public synchronized User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            UsernamePasswordAuthentication upauth = (UsernamePasswordAuthentication)authentication;
            String user = upauth.getUsername();
            String password = upauth.getPassword();
            if (user == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (password == null) {
                password = "";
            }
            String passVal = this.userDataProp.getProperty(PREFIX + user + '.' + "userpassword");
            if (this.isPasswordEncrypt) {
                password = EncryptUtils.encryptMD5(password);
            }
            if (password.equals(passVal)) {
                return this.getUserByName(user);
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        if (authentication instanceof AnonymousAuthentication) {
            if (this.doesExist("anonymous")) {
                return this.getUserByName("anonymous");
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        throw new IllegalArgumentException("Authentication not supported by this user manager");
    }

    public synchronized void dispose() {
        if (this.userDataProp != null) {
            this.userDataProp.clear();
            this.userDataProp = null;
        }
    }
}

