/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ssl.AliasKeyManager;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.ExtendedAliasKeyManager;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.util.ClassUtils;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSslConfiguration
implements SslConfiguration {
    private final Logger LOG = LoggerFactory.getLogger(DefaultSslConfiguration.class);
    private File keystoreFile = new File("./res/.keystore");
    private String keystorePass;
    private String keystoreType = KeyStore.getDefaultType();
    private String keystoreAlgorithm = "SunX509";
    private File trustStoreFile;
    private String trustStorePass;
    private String trustStoreType = KeyStore.getDefaultType();
    private String trustStoreAlgorithm = "SunX509";
    private String sslProtocol = "TLS";
    private ClientAuth clientAuthReqd = ClientAuth.NONE;
    private String keyPass;
    private String keyAlias;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private HashMap<String, SSLContext> sslContextMap = new HashMap();
    private String[] enabledCipherSuites;

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keyStoreFile) {
        this.keystoreFile = keyStoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePass;
    }

    public void setKeystorePassword(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeystoreAlgorithm() {
        return this.keystoreAlgorithm;
    }

    public void setKeystoreAlgorithm(String keystoreAlgorithm) {
        this.keystoreAlgorithm = keystoreAlgorithm;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setClientAuthentication(String clientAuthReqd) {
        this.clientAuthReqd = "true".equalsIgnoreCase(clientAuthReqd) || "yes".equalsIgnoreCase(clientAuthReqd) ? ClientAuth.NEED : ("want".equalsIgnoreCase(clientAuthReqd) ? ClientAuth.WANT : ClientAuth.NONE);
    }

    public String getKeyPassword() {
        return this.keyPass;
    }

    public void setKeyPassword(String keyPass) {
        this.keyPass = keyPass;
    }

    public File getTruststoreFile() {
        return this.trustStoreFile;
    }

    public void setTruststoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTruststorePassword() {
        return this.trustStorePass;
    }

    public void setTruststorePassword(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public String getTruststoreType() {
        return this.trustStoreType;
    }

    public void setTruststoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTruststoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTruststoreAlgorithm(String trustStoreAlgorithm) {
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadStore(File storeFile, String storeType, String storePass) throws IOException, GeneralSecurityException {
        KeyStore keyStore;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(storeFile);
            KeyStore store = KeyStore.getInstance(storeType);
            store.load(fin, storePass.toCharArray());
            keyStore = store;
        }
        catch (Throwable throwable) {
            IoUtils.close(fin);
            throw throwable;
        }
        IoUtils.close(fin);
        return keyStore;
    }

    public synchronized void init() {
        try {
            KeyStore keyStore = this.loadStore(this.keystoreFile, this.keystoreType, this.keystorePass);
            KeyStore trustStore = this.trustStoreFile != null ? this.loadStore(this.trustStoreFile, this.trustStoreType, this.trustStorePass) : keyStore;
            this.keyManagerFactory = KeyManagerFactory.getInstance(this.keystoreAlgorithm);
            this.keyManagerFactory.init(keyStore, this.keyPass.toCharArray());
            this.trustManagerFactory = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
            this.trustManagerFactory.init(trustStore);
        }
        catch (Exception ex) {
            this.LOG.error("DefaultSsl.configure()", (Throwable)ex);
            throw new FtpServerConfigurationException("DefaultSsl.configure()", ex);
        }
    }

    private synchronized void lazyInit() {
        if (this.keyManagerFactory == null) {
            this.init();
        }
    }

    public synchronized SSLContext getSSLContext(String protocol) throws GeneralSecurityException {
        SSLContext ctx;
        this.lazyInit();
        if (protocol == null) {
            protocol = this.sslProtocol;
        }
        if ((ctx = this.sslContextMap.get(protocol)) != null) {
            return ctx;
        }
        ctx = SSLContext.getInstance(protocol);
        KeyManager[] keyManagers = this.keyManagerFactory.getKeyManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            if (ClassUtils.extendsClass(keyManagers[i].getClass(), "javax.net.ssl.X509ExtendedKeyManager")) {
                keyManagers[i] = new ExtendedAliasKeyManager(keyManagers[i], this.keyAlias);
                continue;
            }
            if (!(keyManagers[i] instanceof X509KeyManager)) continue;
            keyManagers[i] = new AliasKeyManager(keyManagers[i], this.keyAlias);
        }
        ctx = SSLContext.getInstance(protocol);
        ctx.init(keyManagers, this.trustManagerFactory.getTrustManagers(), null);
        this.sslContextMap.put(protocol, ctx);
        return ctx;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuthReqd;
    }

    public SSLContext getSSLContext() throws GeneralSecurityException {
        return this.getSSLContext(this.sslProtocol);
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }
}

