/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.MessageResource;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageResourceImpl
implements MessageResource {
    private final Logger LOG = LoggerFactory.getLogger(MessageResourceImpl.class);
    private static final String RESOURCE_PATH = "org/apache/ftpserver/message/";
    private String[] languages;
    private HashMap<String, PropertiesPair> messages;
    private File customMessageDirectory;

    public String[] getLanguages() {
        return this.languages;
    }

    public void setLanguages(String[] languages) {
        this.languages = languages;
    }

    public File getCustomMessageDirectory() {
        return this.customMessageDirectory;
    }

    public void setCustomMessageDirectory(File customMessageDirectory) {
        this.customMessageDirectory = customMessageDirectory;
    }

    public void configure() throws FtpException {
        this.messages = new HashMap();
        if (this.languages != null) {
            for (String language : this.languages) {
                PropertiesPair pair = this.createPropertiesPair(language);
                this.messages.put(language, pair);
            }
        }
        PropertiesPair pair = this.createPropertiesPair(null);
        this.messages.put(null, pair);
    }

    private PropertiesPair createPropertiesPair(String lang) throws FtpException {
        PropertiesPair pair = new PropertiesPair();
        String defaultResourceName = lang == null ? "org/apache/ftpserver/message/FtpStatus.properties" : "org/apache/ftpserver/message/FtpStatus_" + lang + ".properties";
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(defaultResourceName);
            if (in != null) {
                pair.defaultProperties.load(in);
            }
        }
        catch (Exception ex) {
            try {
                this.LOG.warn("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
                throw new FtpException("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(in);
                throw throwable;
            }
        }
        IoUtils.close(in);
        File resourceFile = null;
        resourceFile = lang == null ? new File(this.customMessageDirectory, "FtpStatus.gen") : new File(this.customMessageDirectory, "FtpStatus_" + lang + ".gen");
        in = null;
        try {
            if (resourceFile.exists()) {
                in = new FileInputStream(resourceFile);
                pair.customProperties.load(in);
            }
        }
        catch (Exception ex) {
            this.LOG.warn("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
            throw new FtpException("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
        }
        finally {
            IoUtils.close(in);
        }
        return pair;
    }

    public String[] getAvailableLanguages() {
        if (this.languages == null) {
            return null;
        }
        return (String[])this.languages.clone();
    }

    public String getMessage(int code, String subId, String language) {
        String key = String.valueOf(code);
        if (subId != null) {
            key = key + '.' + subId;
        }
        String value = null;
        PropertiesPair pair = null;
        if (language != null && (pair = this.messages.get(language = language.toLowerCase())) != null && (value = pair.customProperties.getProperty(key)) == null) {
            value = pair.defaultProperties.getProperty(key);
        }
        if (value == null && (pair = this.messages.get(null)) != null && (value = pair.customProperties.getProperty(key)) == null) {
            value = pair.defaultProperties.getProperty(key);
        }
        return value;
    }

    public Properties getMessages(String language) {
        Properties messages = new Properties();
        PropertiesPair pair = this.messages.get(null);
        if (pair != null) {
            messages.putAll((Map<?, ?>)pair.defaultProperties);
            messages.putAll((Map<?, ?>)pair.customProperties);
        }
        if (language != null && (pair = this.messages.get(language = language.toLowerCase())) != null) {
            messages.putAll((Map<?, ?>)pair.defaultProperties);
            messages.putAll((Map<?, ?>)pair.customProperties);
        }
        return messages;
    }

    public void save(Properties prop, String language) throws FtpException {
        if (prop == null) {
            return;
        }
        if (prop.isEmpty()) {
            return;
        }
        File resourceFile = null;
        if (language == null) {
            resourceFile = new File(this.customMessageDirectory, "FtpStatus.gen");
        } else {
            language = language.toLowerCase();
            resourceFile = new File(this.customMessageDirectory, "FtpStatus_" + language + ".gen");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(resourceFile);
            prop.store(out, "Custom Messages");
        }
        catch (IOException ex) {
            try {
                this.LOG.error("MessageResourceImpl.save()", (Throwable)ex);
                throw new FtpException("MessageResourceImpl.save()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close(out);
        PropertiesPair pair = this.messages.get(language);
        if (pair == null) {
            pair = new PropertiesPair();
            this.messages.put(language, pair);
        }
        pair.customProperties = prop;
    }

    public void dispose() {
        for (String language : this.messages.keySet()) {
            PropertiesPair pair = this.messages.get(language);
            pair.customProperties.clear();
            pair.defaultProperties.clear();
        }
        this.messages.clear();
    }

    private static class PropertiesPair {
        public Properties defaultProperties = new Properties();
        public Properties customProperties = new Properties();

        private PropertiesPair() {
        }
    }
}

