/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STOU
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(STOU.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        block33: {
            try {
                DataConnection dataConnection;
                FtpletEnum ftpletRet;
                InetAddress address;
                ServerDataConnectionFactory connFactory = session.getDataConnection();
                if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                    session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                    return;
                }
                session.resetState();
                FtpletContainer ftpletContainer = context.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onUploadUniqueStart(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
                String pathName = request.getArgument();
                FileObject file = null;
                try {
                    FileObject dir;
                    String filePrefix = pathName == null ? "ftp.dat" : ((dir = session.getFileSystemView().getFileObject(pathName)).isDirectory() ? pathName + "/ftp.dat" : pathName);
                    file = session.getFileSystemView().getFileObject(filePrefix);
                    if (file != null) {
                        file = this.getUniqueFile(session, file);
                    }
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", (Throwable)ex);
                }
                if (file == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 550, "STOU", null));
                    return;
                }
                String fileName = file.getFullName();
                if (!file.hasWritePermission()) {
                    session.write(FtpReplyUtil.translate(session, request, context, 550, "STOU.permission", fileName));
                    return;
                }
                session.write(new DefaultFtpReply(150, "FILE: " + fileName));
                boolean failure = false;
                OutputStream os = null;
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception getting the input data stream", (Throwable)e);
                    session.write(FtpReplyUtil.translate(session, request, context, 425, "STOU", fileName));
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                try {
                    os = file.createOutputStream(0L);
                    long transSz = dataConnection.transferFromClient(os);
                    String userName = session.getUser().getName();
                    this.LOG.info("File upload : " + userName + " - " + fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                    if (ftpStat != null) {
                        ftpStat.setUpload(session, file, transSz);
                    }
                }
                catch (SocketException ex) {
                    this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                    failure = true;
                    session.write(FtpReplyUtil.translate(session, request, context, 426, "STOU", fileName));
                }
                catch (IOException ex) {
                    this.LOG.debug("IOException during data transfer", (Throwable)ex);
                    failure = true;
                    session.write(FtpReplyUtil.translate(session, request, context, 551, "STOU", fileName));
                }
                finally {
                    IoUtils.close(os);
                }
                if (failure) break block33;
                session.write(FtpReplyUtil.translate(session, request, context, 226, "STOU", fileName));
                try {
                    ftpletRet = ftpletContainer.onUploadUniqueEnd(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
            }
            finally {
                session.getDataConnection().closeDataConnection();
            }
        }
    }

    protected FileObject getUniqueFile(FtpIoSession session, FileObject oldFile) throws FtpException {
        FileObject newFile = oldFile;
        FileSystemView fsView = session.getFileSystemView();
        String fileName = newFile.getFullName();
        while (newFile.doesExist() && (newFile = fsView.getFileObject(fileName + '.' + System.currentTimeMillis())) != null) {
        }
        return newFile;
    }
}

