/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FileSystemManager;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.UserMetadata;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PASS
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(PASS.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        boolean success = false;
        ServerFtpStatistics stat = (ServerFtpStatistics)context.getFtpStatistics();
        try {
            int maxAnonLogin;
            int currAnonLogin;
            boolean anonymous;
            session.resetState();
            String password = request.getArgument();
            if (password == null) {
                session.write(FtpReplyUtil.translate(session, request, context, 501, "PASS", null));
                return;
            }
            String userName = session.getUserArgument();
            if (userName == null && session.getUser() == null) {
                session.write(FtpReplyUtil.translate(session, request, context, 503, "PASS", null));
                return;
            }
            if (session.isLoggedIn()) {
                session.write(FtpReplyUtil.translate(session, request, context, 202, "PASS", null));
                return;
            }
            boolean bl = anonymous = userName != null && userName.equals("anonymous");
            if (anonymous && (currAnonLogin = stat.getCurrentAnonymousLoginNumber()) >= (maxAnonLogin = context.getConnectionConfig().getMaxAnonymousLogins())) {
                session.write(FtpReplyUtil.translate(session, request, context, 421, "PASS.anonymous", null));
                return;
            }
            int currLogin = stat.getCurrentLoginNumber();
            int maxLogin = context.getConnectionConfig().getMaxLogins();
            if (maxLogin != 0 && currLogin >= maxLogin) {
                session.write(FtpReplyUtil.translate(session, request, context, 421, "PASS.login", null));
                return;
            }
            UserManager userManager = context.getUserManager();
            User authenticatedUser = null;
            try {
                UserMetadata userMetadata = new UserMetadata();
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    userMetadata.setInetAddress(((InetSocketAddress)session.getRemoteAddress()).getAddress());
                }
                userMetadata.setCertificateChain(session.getClientCertificates());
                Object auth = anonymous ? new AnonymousAuthentication(userMetadata) : new UsernamePasswordAuthentication(userName, password, userMetadata);
                authenticatedUser = userManager.authenticate((Authentication)auth);
            }
            catch (AuthenticationFailedException e) {
                authenticatedUser = null;
                this.LOG.warn("User failed to log in");
            }
            catch (Exception e) {
                authenticatedUser = null;
                this.LOG.warn("PASS.execute()", (Throwable)e);
            }
            User oldUser = session.getUser();
            String oldUserArgument = session.getUserArgument();
            int oldMaxIdleTime = session.getMaxIdleTime();
            if (authenticatedUser != null) {
                session.setUser(authenticatedUser);
                session.setUserArgument(null);
                session.setMaxIdleTime(authenticatedUser.getMaxIdleTime());
                success = true;
            } else {
                session.setUser(null);
            }
            FtpletContainer ftpletContainer = context.getFtpletContainer();
            if (ftpletContainer != null) {
                FtpletEnum ftpletRet;
                try {
                    ftpletRet = ftpletContainer.onLogin(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    success = false;
                }
            }
            if (!success) {
                session.setUser(oldUser);
                session.setUserArgument(oldUserArgument);
                session.setMaxIdleTime(oldMaxIdleTime);
                this.delayAfterLoginFailure(context.getConnectionConfig().getLoginFailureDelay());
                this.LOG.warn("Login failure - " + userName);
                session.write(FtpReplyUtil.translate(session, request, context, 530, "PASS", userName));
                stat.setLoginFail(session);
                session.increaseFailedLogins();
                int maxAllowedLoginFailues = context.getConnectionConfig().getMaxLoginFailures();
                if (maxAllowedLoginFailues != 0 && session.getFailedLogins() >= maxAllowedLoginFailues) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                }
                return;
            }
            FileSystemManager fmanager = context.getFileSystemManager();
            FileSystemView fsview = fmanager.createFileSystemView(authenticatedUser);
            session.setLogin(fsview);
            stat.setLogin(session);
            session.write(FtpReplyUtil.translate(session, request, context, 230, "PASS", userName));
            if (anonymous) {
                this.LOG.info("Anonymous login success - " + password);
            } else {
                this.LOG.info("Login success - " + userName);
            }
        }
        finally {
            if (!success) {
                session.reinitialize();
            }
        }
    }

    private void delayAfterLoginFailure(int loginFailureDelay) {
        if (loginFailureDelay > 0) {
            this.LOG.debug("Waiting for " + loginFailureDelay + " milliseconds due to login failure");
            try {
                Thread.sleep(loginFailureDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

