/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.File;
import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MKD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(MKD.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        FtpletEnum ftpletRet;
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null || fileName.indexOf(File.pathSeparatorChar) > -1) {
            session.write(FtpReplyUtil.translate(session, request, context, 501, "MKD", null));
            return;
        }
        FtpletContainer ftpletContainer = context.getFtpletContainer();
        try {
            ftpletRet = ftpletContainer.onMkdirStart(session.getFtpletSession(), request);
        }
        catch (Exception e) {
            this.LOG.debug("Ftplet container threw exception", (Throwable)e);
            ftpletRet = FtpletEnum.RET_DISCONNECT;
        }
        if (ftpletRet == FtpletEnum.RET_SKIP) {
            return;
        }
        if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
            session.closeOnFlush().awaitUninterruptibly(10000L);
            return;
        }
        FileObject file = null;
        try {
            file = session.getFileSystemView().getFileObject(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "MKD.invalid", fileName));
            return;
        }
        fileName = file.getFullName();
        if (!file.hasWritePermission()) {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "MKD.permission", fileName));
            return;
        }
        if (file.doesExist()) {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "MKD.exists", fileName));
            return;
        }
        if (file.mkdir()) {
            session.write(FtpReplyUtil.translate(session, request, context, 257, "MKD", fileName));
            String userName = session.getUser().getName();
            this.LOG.info("Directory create : " + userName + " - " + fileName);
            ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
            ftpStat.setMkdir(session, file);
            try {
                ftpletRet = ftpletContainer.onMkdirEnd(session.getFtpletSession(), request);
            }
            catch (Exception e) {
                this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                ftpletRet = FtpletEnum.RET_DISCONNECT;
            }
            if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                session.closeOnFlush().awaitUninterruptibly(10000L);
                return;
            }
        } else {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "MKD", fileName));
        }
    }
}

