/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.mina.common.IoFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTH
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(AUTH.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        if (!request.hasArgument()) {
            session.write(FtpReplyUtil.translate(session, request, context, 501, "AUTH", null));
            return;
        }
        if (session.getListener().getSsl() == null) {
            session.write(FtpReplyUtil.translate(session, request, context, 431, "AUTH", null));
            return;
        }
        String authType = request.getArgument().toUpperCase();
        if (authType.equals("SSL")) {
            try {
                this.secureSession(session, "SSL");
                session.write(FtpReplyUtil.translate(session, request, context, 234, "AUTH.SSL", null));
            }
            catch (FtpException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.LOG.warn("AUTH.execute()", (Throwable)ex);
                throw new FtpException("AUTH.execute()", (Throwable)ex);
            }
        } else if (authType.equals("TLS")) {
            try {
                this.secureSession(session, "TLS");
                session.write(FtpReplyUtil.translate(session, request, context, 234, "AUTH.TLS", null));
            }
            catch (FtpException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.LOG.warn("AUTH.execute()", (Throwable)ex);
                throw new FtpException("AUTH.execute()", (Throwable)ex);
            }
        } else {
            session.write(FtpReplyUtil.translate(session, request, context, 502, "AUTH", null));
        }
    }

    private void secureSession(FtpIoSession session, String type) throws GeneralSecurityException, FtpException {
        SslFilter sslFilter;
        SslConfiguration ssl = session.getListener().getSsl();
        if (ssl != null) {
            session.setAttribute(SslFilter.DISABLE_ENCRYPTION_ONCE);
            sslFilter = new SslFilter(ssl.getSSLContext());
            if (ssl.getClientAuth() == ClientAuth.NEED) {
                sslFilter.setNeedClientAuth(true);
            } else if (ssl.getClientAuth() == ClientAuth.WANT) {
                sslFilter.setWantClientAuth(true);
            }
            if (ssl.getEnabledCipherSuites() != null) {
                sslFilter.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
            }
        } else {
            throw new FtpException("Socket factory SSL not configured");
        }
        session.getFilterChain().addFirst("sslSessionFilter", (IoFilter)sslFilter);
    }
}

