/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Hashtable;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FileObserver;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.interfaces.StatisticsObserver;

public class FtpStatisticsImpl
implements ServerFtpStatistics {
    private StatisticsObserver observer = null;
    private FileObserver fileObserver = null;
    private Date startTime = new Date();
    private int uploadCount = 0;
    private int downloadCount = 0;
    private int deleteCount = 0;
    private int mkdirCount = 0;
    private int rmdirCount = 0;
    private int currLogins = 0;
    private int totalLogins = 0;
    private int totalFailedLogins = 0;
    private int currAnonLogins = 0;
    private int totalAnonLogins = 0;
    private int currConnections = 0;
    private int totalConnections = 0;
    private long bytesUpload = 0L;
    private long bytesDownload = 0L;
    Hashtable<String, Hashtable<String, Integer>> userLoginTable = new Hashtable();
    public static final String LOGIN_NUMBER = "login_number";

    public void setObserver(StatisticsObserver observer) {
        this.observer = observer;
    }

    public void setFileObserver(FileObserver observer) {
        this.fileObserver = observer;
    }

    public Date getStartTime() {
        return (Date)this.startTime.clone();
    }

    public int getTotalUploadNumber() {
        return this.uploadCount;
    }

    public int getTotalDownloadNumber() {
        return this.downloadCount;
    }

    public int getTotalDeleteNumber() {
        return this.deleteCount;
    }

    public long getTotalUploadSize() {
        return this.bytesUpload;
    }

    public long getTotalDownloadSize() {
        return this.bytesDownload;
    }

    public int getTotalDirectoryCreated() {
        return this.mkdirCount;
    }

    public int getTotalDirectoryRemoved() {
        return this.mkdirCount;
    }

    public int getTotalConnectionNumber() {
        return this.totalConnections;
    }

    public int getCurrentConnectionNumber() {
        return this.currConnections;
    }

    public int getTotalLoginNumber() {
        return this.totalLogins;
    }

    public int getTotalFailedLoginNumber() {
        return this.totalFailedLogins;
    }

    public int getCurrentLoginNumber() {
        return this.currLogins;
    }

    public int getTotalAnonymousLoginNumber() {
        return this.totalAnonLogins;
    }

    public int getCurrentAnonymousLoginNumber() {
        return this.currAnonLogins;
    }

    public int getCurrentUserLoginNumber(User user) {
        Hashtable<String, Integer> statisticsTable = this.userLoginTable.get(user.getName());
        if (statisticsTable == null) {
            return 0;
        }
        Integer loginNumber = statisticsTable.get(LOGIN_NUMBER);
        if (loginNumber == null) {
            return 0;
        }
        return loginNumber;
    }

    public int getCurrentUserLoginNumber(User user, InetAddress ipAddress) {
        Hashtable<String, Integer> statisticsTable = this.userLoginTable.get(user.getName());
        if (statisticsTable == null) {
            return 0;
        }
        Integer loginNumber = statisticsTable.get(ipAddress.getHostAddress());
        if (loginNumber == null) {
            return 0;
        }
        return loginNumber;
    }

    public void setUpload(FtpIoSession session, FileObject file, long size) {
        ++this.uploadCount;
        this.bytesUpload += size;
        this.notifyUpload(session, file, size);
    }

    public void setDownload(FtpIoSession session, FileObject file, long size) {
        ++this.downloadCount;
        this.bytesDownload += size;
        this.notifyDownload(session, file, size);
    }

    public void setDelete(FtpIoSession session, FileObject file) {
        ++this.deleteCount;
        this.notifyDelete(session, file);
    }

    public void setMkdir(FtpIoSession session, FileObject file) {
        ++this.mkdirCount;
        this.notifyMkdir(session, file);
    }

    public void setRmdir(FtpIoSession session, FileObject file) {
        ++this.rmdirCount;
        this.notifyRmdir(session, file);
    }

    public void setOpenConnection(FtpIoSession session) {
        ++this.currConnections;
        ++this.totalConnections;
        this.notifyOpenConnection(session);
    }

    public void setCloseConnection(FtpIoSession session) {
        if (this.currConnections > 0) {
            --this.currConnections;
        }
        this.notifyCloseConnection(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogin(FtpIoSession session) {
        ++this.currLogins;
        ++this.totalLogins;
        User user = session.getUser();
        if ("anonymous".equals(user.getName())) {
            ++this.currAnonLogins;
            ++this.totalAnonLogins;
        }
        User user2 = user;
        synchronized (user2) {
            Hashtable<String, Integer> statisticsTable = this.userLoginTable.get(user.getName());
            if (statisticsTable == null) {
                statisticsTable = new Hashtable();
                this.userLoginTable.put(user.getName(), statisticsTable);
                statisticsTable.put(LOGIN_NUMBER, new Integer(1));
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    String address = ((InetSocketAddress)session.getRemoteAddress()).getAddress().getHostAddress();
                    statisticsTable.put(address, new Integer(1));
                }
            } else {
                Integer loginNumber = statisticsTable.get(LOGIN_NUMBER);
                statisticsTable.put(LOGIN_NUMBER, new Integer(loginNumber + 1));
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    String address = ((InetSocketAddress)session.getRemoteAddress()).getAddress().getHostAddress();
                    Integer loginNumberPerIP = statisticsTable.get(address);
                    if (loginNumberPerIP == null) {
                        statisticsTable.put(address, new Integer(1));
                    } else {
                        statisticsTable.put(address, new Integer(loginNumberPerIP + 1));
                    }
                }
            }
        }
        this.notifyLogin(session);
    }

    public void setLoginFail(FtpIoSession session) {
        ++this.totalFailedLogins;
        this.notifyLoginFail(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogout(FtpIoSession session) {
        User user = session.getUser();
        if (user == null) {
            return;
        }
        --this.currLogins;
        if ("anonymous".equals(user.getName())) {
            --this.currAnonLogins;
        }
        User user2 = user;
        synchronized (user2) {
            Hashtable<String, Integer> statisticsTable = this.userLoginTable.get(user.getName());
            if (statisticsTable != null) {
                String address;
                Integer loginNumberPerIP;
                Integer loginNumber = statisticsTable.get(LOGIN_NUMBER);
                statisticsTable.put(LOGIN_NUMBER, new Integer(loginNumber - 1));
                if (session.getRemoteAddress() instanceof InetSocketAddress && (loginNumberPerIP = statisticsTable.get(address = ((InetSocketAddress)session.getRemoteAddress()).getAddress().getHostAddress())) != null) {
                    if (loginNumberPerIP <= 1) {
                        statisticsTable.remove(address);
                    } else {
                        statisticsTable.put(address, new Integer(loginNumberPerIP - 1));
                    }
                }
            }
        }
        this.notifyLogout(session);
    }

    private void notifyUpload(FtpIoSession session, FileObject file, long size) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyUpload();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyUpload(session, file, size);
        }
    }

    private void notifyDownload(FtpIoSession session, FileObject file, long size) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyDownload();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyDownload(session, file, size);
        }
    }

    private void notifyDelete(FtpIoSession session, FileObject file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyDelete();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyDelete(session, file);
        }
    }

    private void notifyMkdir(FtpIoSession session, FileObject file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyMkdir();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyMkdir(session, file);
        }
    }

    private void notifyRmdir(FtpIoSession session, FileObject file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyRmdir();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyRmdir(session, file);
        }
    }

    private void notifyOpenConnection(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyOpenConnection();
        }
    }

    private void notifyCloseConnection(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyCloseConnection();
        }
    }

    private void notifyLogin(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            User user = session.getUser();
            boolean anonymous = false;
            if (user != null) {
                String login = user.getName();
                anonymous = login != null && login.equals("anonymous");
            }
            observer.notifyLogin(anonymous);
        }
    }

    private void notifyLoginFail(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null && session.getRemoteAddress() instanceof InetSocketAddress) {
            observer.notifyLoginFail(((InetSocketAddress)session.getRemoteAddress()).getAddress());
        }
    }

    private void notifyLogout(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            User user = session.getUser();
            boolean anonymous = false;
            if (user != null) {
                String login = user.getName();
                anonymous = login != null && login.equals("anonymous");
            }
            observer.notifyLogout(anonymous);
        }
    }

    public void resetStatisticsCounters() {
        this.startTime = new Date();
        this.uploadCount = 0;
        this.downloadCount = 0;
        this.deleteCount = 0;
        this.mkdirCount = 0;
        this.rmdirCount = 0;
        this.totalLogins = 0;
        this.totalFailedLogins = 0;
        this.totalAnonLogins = 0;
        this.totalConnections = 0;
        this.bytesUpload = 0L;
        this.bytesDownload = 0L;
    }
}

