#-------------------------------------------------------------------------------
macro (EXTERNAL_HDF4_LIBRARY compress_type libtype)
  set (HDF45_BUILD_XDR_LIB OFF)
  if (WIN32)
    set (HDF45_BUILD_XDR_LIB ON)
  endif ()
  if (${compress_type} MATCHES "SVN")
    EXTERNALPROJECT_ADD (HDF4
        SVN_REPOSITORY ${HDF4_URL}
        # [SVN_REVISION rev]
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF4_BUILD_TOOLS:BOOL=OFF
            -DHDF4_BUILD_FORTRAN:BOOL=OFF
            -DHDF4_BUILD_EXAMPLES:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF4_BUILD_XDR_LIB:BOOL=${HDF45_BUILD_XDR_LIB}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF4_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF4_ALLOW_EXTERNAL_SUPPORT:STRING="SVN"
            -DJPEG_SVN_URL:STRING=${JPEG_SVN_URL}
            -DZLIB_SVN_URL:STRING=${ZLIB_SVN_URL}
            -DSZIP_SVN_URL:STRING=${SZIP_SVN_URL}
            -DHDF4_ENABLE_JPEG_LIB_SUPPORT:BOOL=${HDF_ENABLE_JPEG_LIB_SUPPORT}
            -DHDF4_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF4_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF4_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    )
  elseif (${compress_type} MATCHES "GIT")
    EXTERNALPROJECT_ADD (HDF4
        GIT_REPOSITORY ${HDF4_URL}
        GIT_TAG ${HDF4_BRANCH}
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF4_BUILD_TOOLS:BOOL=OFF
            -DHDF4_BUILD_FORTRAN:BOOL=OFF
            -DHDF4_BUILD_EXAMPLES:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF4_BUILD_XDR_LIB:BOOL=${HDF45_BUILD_XDR_LIB}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF4_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF4_ALLOW_EXTERNAL_SUPPORT:STRING="GIT"
            -DJPEG_GIT_URL:STRING=${JPEG_GIT_URL}
            -DJPEG_GIT_BRANCH:STRING=${JPEG_GIT_BRANCH}
            -DZLIB_GIT_URL:STRING=${ZLIB_GIT_URL}
            -DZLIB_GIT_BRANCH:STRING=${ZLIB_GIT_BRANCH}
            -DSZIP_GIT_URL:STRING=${SZIP_GIT_URL}
            -DSZIP_GIT_BRANCH:STRING=${SZIP_GIT_BRANCH}
            -DHDF4_ENABLE_JPEG_LIB_SUPPORT:BOOL=${HDF_ENABLE_JPEG_LIB_SUPPORT}
            -DHDF4_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF4_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF4_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    )
  endif ()
  if (${compress_type} MATCHES "TGZ")
    EXTERNALPROJECT_ADD (HDF4
        URL ${HDF4_URL}
        URL_MD5 ""
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF4_BUILD_TOOLS:BOOL=OFF
            -DHDF4_BUILD_FORTRAN:BOOL=OFF
            -DHDF4_BUILD_EXAMPLES:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF4_BUILD_XDR_LIB:BOOL=${HDF45_BUILD_XDR_LIB}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF4_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF4_ALLOW_EXTERNAL_SUPPORT:STRING="TGZ"
            -DTGZPATH:STRING=${TGZPATH}
            -DJPEG_TGZ_NAME:STRING=${JPEG_TGZ_NAME}
            -DZLIB_TGZ_NAME:STRING=${ZLIB_TGZ_NAME}
            -DSZIP_TGZ_NAME:STRING=${SZIP_TGZ_NAME}
            -DHDF4_ENABLE_JPEG_LIB_SUPPORT:BOOL=${HDF_ENABLE_JPEG_LIB_SUPPORT}
            -DHDF4_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF4_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF4_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    )
  endif ()
  externalproject_get_property (HDF4 BINARY_DIR SOURCE_DIR)

  ##include (${BINARY_DIR}/${HDF4_PACKAGE_NAME}${HDF_PACKAGE_EXT}-targets.cmake)
  # Create imported target hdf4-static
  add_library (hdf-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (hdf-static "hdf" STATIC "")
  add_library (mfhdf-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (mfhdf-static "mfhdf" STATIC "")
  add_dependencies (HDF4 hdf-static mfhdf-static)
  set (HDF4_STATIC_LIBRARY "hdf-static;mfhdf-static")
  set (MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES "hdf-static")
  if (HDF45_BUILD_XDR_LIB)
    add_library (xdr-static STATIC IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (xdr-static "xdr" STATIC "")
    add_dependencies (HDF4 xdr-static)
    set (HDF4_STATIC_LIBRARY "${HDF4_STATIC_LIBRARY};xdr-static")
    set (MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES "xdr-static;${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}")
  endif ()
  set (HDF4_LIBRARIES ${HDF4_STATIC_LIBRARY})
  if (BUILD_SHARED_LIBS)
    add_library (hdf-shared SHARED IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (hdf-shared "hdf" SHARED "")
    add_library (mfhdf-shared SHARED IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (mfhdf-shared "mfhdf" SHARED} "")
    add_dependencies (HDF4 hdf-shared mfhdf-shared)
    set (HDF4_SHARED_LIBRARY "hdf-shared;mfhdf-shared")
    set (MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES "hdf-shared")
    if (HDF45_BUILD_XDR_LIB)
      add_library (xdr-shared SHARED IMPORTED)
      HDF_IMPORT_SET_LIB_OPTIONS (xdr-shared "xdr" SHARED "")
      add_dependencies (HDF4 xdr-shared)
      set (HDF4_SHARED_LIBRARY "${HDF4_SHARED_LIBRARY};xdr-shared")
      set (MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES "xdr-shared;${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}")
    endif ()
  endif ()
  if (HDF_ENABLE_JPEG_LIB_SUPPORT)
    add_library(jpeg-static STATIC IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (jpeg-static "jpeg" STATIC "")
    add_dependencies (HDF4 jpeg-static)
    set (JPEG_STATIC_LIBRARY "jpeg-static")
    set (JPEG_LIBRARIES ${JPEG_STATIC_LIBRARY})
    set (HDF4_STATIC_LIBRARY "${HDF4_STATIC_LIBRARY};${JPEG_STATIC_LIBRARY}")
    if (BUILD_SHARED_LIBS)
      # Create imported target jpeg-shared
      add_library(jpeg-shared SHARED IMPORTED)
      HDF_IMPORT_SET_LIB_OPTIONS (jpeg-shared "jpeg" SHARED "")
      add_dependencies (HDF4 jpeg-shared)
      set (JPEG_SHARED_LIBRARY "jpeg-shared")
      set (JPEG_LIBRARIES ${JPEG_LIBRARIES} ${JPEG_SHARED_LIBRARY})
      set (HDF4_SHARED_LIBRARY "${HDF4_SHARED_LIBRARY};${JPEG_SHARED_LIBRARY}")
    endif ()
  endif ()
  if (HDF_ENABLE_Z_LIB_SUPPORT)
    if (NOT ZLIB_LIBRARIES)
       if (WIN32)
        set (ZLIB_LIB_NAME "zlib")
      else ()
        set (ZLIB_LIB_NAME "z")
      endif ()
      add_library(zlib-static STATIC IMPORTED)
      HDF_IMPORT_SET_LIB_OPTIONS (zlib-static ${ZLIB_LIB_NAME} STATIC "")
      set (ZLIB_STATIC_LIBRARY "zlib-static")
      set (ZLIB_LIBRARIES ${ZLIB_STATIC_LIBRARY})
    endif ()
    add_dependencies (HDF4 zlib-static)
    set (HDF4_STATIC_LIBRARY "${HDF4_STATIC_LIBRARY};${ZLIB_STATIC_LIBRARY}")
    if (BUILD_SHARED_LIBS)
      if (NOT ZLIB_LIBRARIES)
        # Create imported target zlib-shared
        add_library(zlib-shared SHARED IMPORTED)
        HDF_IMPORT_SET_LIB_OPTIONS (zlib-shared ${ZLIB_LIB_NAME} SHARED "")
        set (ZLIB_SHARED_LIBRARY "zlib-shared")
        set (ZLIB_LIBRARIES ${ZLIB_LIBRARIES} ${ZLIB_SHARED_LIBRARY})
      endif ()
      add_dependencies (HDF4 zlib-shared)
      set (HDF4_SHARED_LIBRARY "${HDF4_SHARED_LIBRARY};${ZLIB_SHARED_LIBRARY}")
    endif ()
    set (HDF4_ZLIB "TRUE")
  endif ()
  if (HDF_ENABLE_SZIP_SUPPORT)
    if (NOT SZIP_LIBRARIES)
      add_library(szip-static STATIC IMPORTED)
      HDF_IMPORT_SET_LIB_OPTIONS (szip-static "szip" STATIC "")
      set (SZIP_STATIC_LIBRARY "szip-static")
      set (SZIP_LIBRARIES ${SZIP_STATIC_LIBRARY})
    endif ()
    set (HDF4_STATIC_LIBRARY "${HDF4_STATIC_LIBRARY};${SZIP_STATIC_LIBRARY}")
    add_dependencies (HDF4 szip-static)
    if (BUILD_SHARED_LIBS)
      if (NOT SZIP_LIBRARIES)
        # Create imported target szip-shared
        add_library(szip-shared SHARED IMPORTED)
        HDF_IMPORT_SET_LIB_OPTIONS (szip-shared "szip" SHARED "")
        set (SZIP_SHARED_LIBRARY "szip-shared")
        set (SZIP_LIBRARIES ${SZIP_LIBRARIES} ${SZIP_SHARED_LIBRARY})
      endif ()
      add_dependencies (HDF4 szip-shared)
      set (HDF4_SHARED_LIBRARY "${HDF4_SHARED_LIBRARY};${SZIP_SHARED_LIBRARY}")
    endif ()
    set (HDF4_SZIP "TRUE")
  endif ()

  if (${libtype} MATCHES "SHARED")
    set_target_properties (hdf-shared PROPERTIES
        IMPORTED_LINK_INTERFACE_LIBRARIES "jpeg-shared;zlib-shared;szip-shared"
    )
    set_target_properties (mfhdf-shared PROPERTIES
        IMPORTED_LINK_INTERFACE_LIBRARIES "${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}"
    )
  else ()
    set_target_properties (hdf-static PROPERTIES
        IMPORTED_LINK_INTERFACE_LIBRARIES "jpeg-static;zlib-static;szip-static"
        IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    )
    set_target_properties (mfhdf-static PROPERTIES
        IMPORTED_LINK_INTERFACE_LIBRARIES "${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}"
        IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    )
    if (HDF45_BUILD_XDR_LIB)
      set_target_properties (xdr-static PROPERTIES
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    )
    endif ()
    if (HDF_ENABLE_JPEG_LIB_SUPPORT)
      set_target_properties (jpeg-static PROPERTIES
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
    endif ()
    if (HDF_ENABLE_Z_LIB_SUPPORT)
      set_target_properties (zlib-static PROPERTIES
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
    endif ()
    if (HDF_ENABLE_SZIP_SUPPORT)
      set_target_properties (szip-static PROPERTIES
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
    endif ()
  endif ()
  if (HDF_ENABLE_JPEG_LIB_SUPPORT)
    set (JPEG_INCLUDE_DIR "${BINARY_DIR}/JPEG-prefix/src/JPEG/src")
    set (JPEG_INCLUDE_DIR_GEN "${BINARY_DIR}/JPEG-prefix/src/JPEG-build" PARENT_SCOPE)
    set (H425_HAVE_JPEGLIB_H 1)
    set (H425_HAVE_LIBJPEG 1)
    set (H425_JPEGLIB_HEADER "jpeglib.h")
    set (JPEG_INCLUDE_DIRS ${JPEG_INCLUDE_DIR_GEN} ${JPEG_INCLUDE_DIR})
    set (JPEG_FOUND 1 PARENT_SCOPE)
  endif ()
  if (HDF_ENABLE_Z_LIB_SUPPORT AND HDF4_ZLIB)
    set (ZLIB_INCLUDE_DIR "${BINARY_DIR}/ZLIB-prefix/src/ZLIB/src")
    set (ZLIB_INCLUDE_DIR_GEN "${BINARY_DIR}/ZLIB-prefix/src/ZLIB-build" PARENT_SCOPE)
    set (H425_HAVE_FILTER_DEFLATE 1)
    set (H425_HAVE_ZLIB_H 1)
    set (H425_HAVE_LIBZ 1)
    set (H425_ZLIB_HEADER "zlib.h")
    set (ZLIB_INCLUDE_DIRS ${ZLIB_INCLUDE_DIR_GEN} ${ZLIB_INCLUDE_DIR})
    set (ZLIB_FOUND 1 PARENT_SCOPE)
  endif ()
  if (HDF_ENABLE_SZIP_SUPPORT AND HDF4_SZIP)
    set (SZIP_INCLUDE_DIR "${BINARY_DIR}/SZIP-prefix/src/SZIP/src")
    set (SZIP_INCLUDE_DIR_GEN "${BINARY_DIR}/SZIP-prefix/src/SZIP-build" PARENT_SCOPE)
    set (H425_HAVE_FILTER_SZIP 1)
    set (H425_HAVE_SZLIB_H 1)
    set (H425_HAVE_LIBSZ 1)
    set (SZIP_INCLUDE_DIRS ${SZIP_INCLUDE_DIR_GEN} ${SZIP_INCLUDE_DIR})
    set (SZIP_FOUND 1 PARENT_SCOPE)
  endif ()
#  file (READ ${BINARY_DIR}/h4config.h _h4config_h_contents)
#  string (REGEX REPLACE ".*#define[ \t]+H4_VERSION[ \t]+\"([0-9A-Za-z.]+)\".*" "\\1" HDF4_VERSION_STRING ${_h4config_h_contents})

  set (HDF4_LIBRARIES ${HDF4_STATIC_LIBRARY})
  if (BUILD_SHARED_LIBS)
    set (HDF4_LIBRARIES ${HDF4_LIBRARIES} ${HDF4_SHARED_LIBRARY})
  endif ()
  message ("HDF4_LIBRARIES is ${HDF4_LIBRARIES}\n")

  set (HDF4_INCLUDE_DIR_GEN "${BINARY_DIR}")
  set (HDF4_HDF_INCLUDE_DIR "${SOURCE_DIR}/hdf/src")
  set (HDF4_MFHDF_INCLUDE_DIR "${SOURCE_DIR}/mfhdf/libsrc")
  set (HDF4_INCLUDE_DIR ${HDF4_HDF_INCLUDE_DIR} ${HDF4_MFHDF_INCLUDE_DIR})
  set (HDF4_FOUND 1)
  set (HDF4_INCLUDE_DIRS ${HDF4_INCLUDE_DIR_GEN} ${HDF4_INCLUDE_DIR})
endmacro ()

#-------------------------------------------------------------------------------
macro (PACKAGE_HDF4_LIBRARY compress_type libtype)
  add_custom_target (HDF4-GenHeader-Copy ALL
      COMMAND ${CMAKE_COMMAND} -E copy_if_different ${HDF4_INCLUDE_DIR_GEN}/h4config.h ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/
      COMMENT "Copying ${HDF4_INCLUDE_DIR_GEN}/h4config.h to ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/"
  )
  set (EXTERNAL_HEADER_LIST ${EXTERNAL_HEADER_LIST} ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/h4config.h)
  if (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "GIT" OR ${compress_type} MATCHES "TGZ")
    add_dependencies (HDF4-GenHeader-Copy HDF4)
    install (
        FILES ${HDF4_INCLUDE_DIR_GEN}/libhdf4.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  else ()
    get_filename_component (HDF4SETTINGS "${HDF4_INCLUDE_DIR}/../lib" ABSOLUTE)
    install (
        FILES ${HDF4SETTINGS}/libhdf4.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  endif ()
endmacro ()

macro (HDF4_SUPPORT link_hdf)
  set (CMAKE_MODULE_PATH ${HDF_RESOURCES_DIR} ${CMAKE_MODULE_PATH})
  set (CMAKE_POSITION_INDEPENDENT_CODE ON)

  if (NOT H4H5_HDF4_HEADER)
    if (NOT HDF4_USE_EXTERNAL)
      if (USE_SHARED_LIBS)
        set (FIND_HDF_COMPONENTS C shared static)
      else ()
        set (FIND_HDF_COMPONENTS C static)
      endif ()
      message (STATUS "HDF4 find comps: ${FIND_HDF_COMPONENTS}")
      set (SEARCH_PACKAGE_NAME ${HDF4_PACKAGE_NAME})

      find_package (HDF4 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
      message (STATUS "HDF4 C libs:${HDF4_FOUND} static:${HDF4_static_C_FOUND} and shared:${HDF4_shared_C_FOUND}")
    endif ()
    if (HDF4_FOUND)
      if (NOT TARGET hdf4::hdp)
        add_executable (hdf4::hdp IMPORTED)
      endif()
      if (NOT TARGET hdf4::hdiff)
        add_executable (hdf4::hdiff IMPORTED)
      endif()
      if (NOT HDF4_static_C_FOUND AND NOT HDF4_shared_C_FOUND)
        set (FIND_HDF_COMPONENTS C)

        find_package (HDF4 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
        message (STATUS "HDF4 libs:${HDF4_FOUND} C:${HDF4_C_FOUND}")
        set (HDF4_LINK_LIBS ${HDF4_LINK_LIBS} ${HDF4_LIBRARIES})
        if (HDF4_BUILD_SHARED_LIBS)
          add_definitions (-DH4_BUILT_AS_DYNAMIC_LIB)
        else ()
          add_definitions (-DH4_BUILT_AS_STATIC_LIB)
        endif ()
        if (USE_SHARED_LIBS AND WIN32)
          set_property (TARGET hdf4::hdp PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdpdll")
          set_property (TARGET hdf4::hdiff PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdiffdll")
        else ()
          set_property (TARGET hdf4::hdp PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdp")
          set_property (TARGET hdf4::hdiff PROPERTY IMPORTED_LOCATION "${HDF4_TOOLS_DIR}/hdiff")
        endif ()
        set (HDF4_DUMP_EXECUTABLE $<TARGET_FILE:hdf4::hdp>)
        set (HDF4_DIFF_EXECUTABLE $<TARGET_FILE:hdf4::hdiff>)
      else ()
        if (USE_SHARED_LIBS AND HDF4_shared_C_FOUND)
          set (HDF4_LINK_SHLIBS ${HDF4_LINK_SHLIBS} ${HDF4_C_SHARED_LIBRARY})
        endif ()
        if (HDF4_static_C_FOUND)
          set (HDF4_LINK_LIBS ${HDF4_LINK_LIBS} ${HDF4_C_STATIC_LIBRARY})
        endif ()
        set (HDF4_DUMP_EXECUTABLE $<TARGET_FILE:hdf4::hdp>)
        set (HDF4_DIFF_EXECUTABLE $<TARGET_FILE:hdf4::hdiff>)
      endif ()
    endif ()
    if (HDF4_FOUND)
      message (STATUS "HDF4-${HDF4_VERSION_STRING} found: INC=${HDF4_INCLUDE_DIR} TOOLS=${HDF4_TOOLS_DIR}")
      if (USE_SHARED_LIBS AND NOT HDF4_BUILD_SHARED_LIBS)
        message (STATUS "HDF4 build type does match requested type")
      endif ()
      set (H4H5_HAVE_HDF_H 1)
      set (H4H5_HAVE_HDF4 1)
      set (H4H5_HDF4_HEADER "hdf.h")
      set (HDF4_INCLUDE_DIR_GEN ${HDF4_INCLUDE_DIR})
      set (HDF4_INCLUDE_DIRS ${HDF4_INCLUDE_DIR})
    else ()
      if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        # May need to build JPEG with PIC on x64 machines with gcc
        # Need to use CMAKE_ANSI_CFLAGS define so that compiler test works
        if (NOT CMAKE_ANSI_CFLAGS)
          set (CMAKE_ANSI_CFLAGS " ")
        endif ()
        if (BUILD_JPEG_WITH_PIC)
          set (CMAKE_ANSI_CFLAGS "${CMAKE_ANSI_CFLAGS} -fPIC")
        endif ()

        EXTERNAL_HDF4_LIBRARY (${HDF_ALLOW_EXTERNAL_SUPPORT} ${LIB_TYPE})
        set (H4H5_HAVE_HDF_H 1)
        set (H4H5_HAVE_HDF4 1)
        set (H4H5_HDF4_HEADER "hdf.h")
        message (STATUS "HDF4 is built")
        if (USE_SHARED_LIBS)
          set (HDF4_LINK_LIBS ${HDF4_LINK_LIBS} ${HDF4_SHARED_LIBRARY})
          add_definitions (-DH4_BUILT_AS_DYNAMIC_LIB)
        else ()
          set (HDF4_LINK_LIBS ${HDF4_LINK_LIBS} ${HDF4_STATIC_LIBRARY})
          add_definitions (-DH4_BUILT_AS_STATIC_LIB)
        endif ()
      else ()
        message (FATAL_ERROR " HDF4 is Required for H4H5Tools")
      endif ()
    endif ()
  else ()
    # This project is being called from within another and HDF4 is already configured
    set (H4H5_HAVE_HDF_H 1)
    set (H4H5_HAVE_HDF4 1)
  endif ()
  message (STATUS "HDF4 link libs: ${HDF4_LINK_LIBS}")
  if (BUILD_SHARED_LIBS)
    message (STATUS "HDF4 shared link libs: ${HDF4_LINK_SHLIBS}")
  endif ()

  if (NOT HDF4_LIBRARY)
    set (HDF4_LIBRARY ${HDF4_LIBRARIES})
  endif ()
  INCLUDE_DIRECTORIES (${HDF4_INCLUDE_DIRS})
  set (HDF4_FOUND 1)
  set (HDF4_INCLUDE_DIR_GEN ${HDF4_INCLUDE_DIR_GEN})
  set (HDF4_VERSION_STRING ${HDF4_VERSION_STRING})
  if (WIN32)
    set(CMAKE_TEST_LIB_DIRECTORY "${CMAKE_TEST_LIB_DIRECTORY};${HDF4_TOOLS_DIR}")
  else ()
    set(CMAKE_TEST_LIB_DIRECTORY "${CMAKE_TEST_LIB_DIRECTORY};${HDF4_LIBRARY_PATH}")
  endif ()
endmacro ()

#-------------------------------------------------------------------------------
macro (EXTERNAL_HDF5_LIBRARY compress_type libtype)
  if (${compress_type} MATCHES "SVN")
    EXTERNALPROJECT_ADD (HDF5
        SVN_REPOSITORY ${HDF5_URL}
        # [SVN_REVISION rev]
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_BUILD_TOOLS:BOOL=OFF
            -DHDF5_BUILD_EXAMPLES:BOOL=OFF
            -DHDF5_BUILD_HL_LIB:BOOL=OFF
            -DHDF5_BUILD_CPP_LIB:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="SVN"
            -DZLIB_SVN_URL:STRING=${ZLIB_SVN_URL}
            -DSZIP_SVN_URL:STRING=${SZIP_SVN_URL}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    )
  endif ()
  if (${compress_type} MATCHES "GIT")
    EXTERNALPROJECT_ADD (HDF5
        GIT_REPOSITORY ${HDF5_URL}
        GIT_TAG ${HDF5_BRANCH}
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_BUILD_TOOLS:BOOL=OFF
            -DHDF5_BUILD_EXAMPLES:BOOL=OFF
            -DHDF5_BUILD_HL_LIB:BOOL=OFF
            -DHDF5_BUILD_CPP_LIB:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="GIT"
            -DZLIB_GIT_URL:STRING=${ZLIB_GIT_URL}
            -DZLIB_GIT_BRANCH:STRING=${ZLIB_GIT_BRANCH}
            -DSZIP_GIT_URL:STRING=${SZIP_GIT_URL}
            -DSZIP_GIT_BRANCH:STRING=${SZIP_GIT_BRANCH}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    )
  endif ()
  if (${compress_type} MATCHES "TGZ")
    EXTERNALPROJECT_ADD (HDF5
        URL ${HDF5_URL}
        URL_MD5 ""
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_BUILD_TOOLS:BOOL=OFF
            -DHDF5_BUILD_EXAMPLES:BOOL=OFF
            -DHDF5_BUILD_HL_LIB:BOOL=OFF
            -DHDF5_BUILD_CPP_LIB:BOOL=OFF
            -DBUILD_TESTING:BOOL=OFF
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="TGZ"
            -DTGZPATH:STRING=${TGZPATH}
            -DZLIB_TGZ_NAME:STRING=${ZLIB_TGZ_NAME}
            -DSZIP_TGZ_NAME:STRING=${SZIP_TGZ_NAME}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    )
  endif ()
  externalproject_get_property (HDF5 BINARY_DIR SOURCE_DIR)

  # Create imported target hdf5
  add_library (hdf5-static STATIC IMPORTED)
  HDF_IMPORT_SET_LIB_OPTIONS (hdf5-static "hdf5" STATIC "")
  add_dependencies (HDF5 hdf5-static)
  set (HDF5_STATIC_LIBRARY "hdf5-static")
  if (BUILD_SHARED_LIBS)
    add_library (hdf5-shared SHARED IMPORTED)
    HDF_IMPORT_SET_LIB_OPTIONS (hdf5-shared "hdf5" SHARED "")
    add_dependencies (HDF5 hdf5-shared)
    set (HDF5_SHARED_LIBRARY "hdf5-shared")
  endif ()
  if (HDF_ENABLE_Z_LIB_SUPPORT)
    if (NOT ZLIB_LIBRARIES)
      add_library (zlib-static STATIC IMPORTED)
      HDF_IMPORT_SET_LIB_OPTIONS (zlib-static "zlib" STATIC "")
      set (ZLIB_STATIC_LIBRARY "zlib-static")
      set (ZLIB_LIBRARIES ${ZLIB_STATIC_LIBRARY})
    endif ()
    add_dependencies (HDF5 zlib-static)
    set (HDF5_STATIC_LIBRARY "${HDF5_STATIC_LIBRARY};${ZLIB_STATIC_LIBRARY}")
    if (BUILD_SHARED_LIBS)
      if (NOT ZLIB_LIBRARIES)
        add_library (zlib-shared SHARED IMPORTED)
        HDF_IMPORT_SET_LIB_OPTIONS (zlib-shared "zlib" SHARED "")
        set (ZLIB_SHARED_LIBRARY "zlib-shared")
        set (ZLIB_LIBRARIES ${ZLIB_LIBRARIES} ${ZLIB_SHARED_LIBRARY})
      endif ()
      add_dependencies (HDF5 zlib-shared)
      set (HDF5_SHARED_LIBRARY "${HDF5_SHARED_LIBRARY};${ZLIB_SHARED_LIBRARY}")
    endif ()
    set (HDF5_ZLIB "TRUE")
  endif ()
  if (HDF_ENABLE_SZIP_SUPPORT)
    if (NOT SZIP_LIBRARIES)
      add_library (szip-static STATIC IMPORTED)
      HDF_IMPORT_SET_LIB_OPTIONS (szip-static "szip" STATIC "")
      set (SZIP_STATIC_LIBRARY "szip-static")
      set (SZIP_LIBRARIES ${SZIP_STATIC_LIBRARY})
    endif ()
    add_dependencies (HDF5 szip-static)
    set (HDF5_STATIC_LIBRARY "${HDF5_STATIC_LIBRARY};${SZIP_STATIC_LIBRARY}")
    if (BUILD_SHARED_LIBS)
      if (NOT SZIP_LIBRARIES)
        add_library (szip-shared SHARED IMPORTED)
        HDF_IMPORT_SET_LIB_OPTIONS (szip-shared "szip" SHARED "")
        set (SZIP_SHARED_LIBRARY "szip-shared")
        set (SZIP_LIBRARIES ${SZIP_LIBRARIES} ${SZIP_SHARED_LIBRARY})
      endif ()
      add_dependencies (HDF5 szip-shared)
      set (HDF5_SHARED_LIBRARY "${HDF5_SHARED_LIBRARY};${SZIP_SHARED_LIBRARY}")
    endif ()
    set (HDF5_SZIP "TRUE")
   endif ()

  if (${libtype} MATCHES "SHARED")
    if (WIN32)
      set_target_properties (hdf5-shared PROPERTIES
          IMPORTED_LINK_INTERFACE_LIBRARIES "zlib-shared;szip-shared"
      )
    else ()
      set_target_properties (hdf5-shared PROPERTIES
          IMPORTED_LINK_INTERFACE_LIBRARIES "dl;zlib-shared;szip-shared"
      )
    endif ()
  else ()
    set_target_properties (hdf5-static PROPERTIES
        IMPORTED_LINK_INTERFACE_LIBRARIES "zlib-static;szip-static"
        IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    )
  endif ()
  if (HDF_ENABLE_Z_LIB_SUPPORT AND HDF5_ZLIB)
    set (ZLIB_INCLUDE_DIR "${BINARY_DIR}/ZLIB-prefix/src/ZLIB/src")
    set (ZLIB_INCLUDE_DIR_GEN "${BINARY_DIR}/ZLIB-prefix/src/ZLIB-build")
    set (H425_HAVE_FILTER_DEFLATE 1)
    set (H425_HAVE_ZLIB_H 1)
    set (H425_HAVE_LIBZ 1)
    set (H425_ZLIB_HEADER "zlib.h")
    set (ZLIB_INCLUDE_DIRS ${ZLIB_INCLUDE_DIR_GEN} ${ZLIB_INCLUDE_DIR})
   endif ()
  if (HDF_ENABLE_SZIP_SUPPORT AND HDF5_SZIP)
    set (SZIP_INCLUDE_DIR "${BINARY_DIR}/SZIP-prefix/src/SZIP/src")
    set (SZIP_INCLUDE_DIR_GEN "${BINARY_DIR}/SZIP-prefix/src/SZIP-build")
    set (H425_HAVE_FILTER_SZIP 1)
    set (H425_HAVE_SZLIB_H 1)
    set (H425_HAVE_LIBSZ 1)
    set (SZIP_INCLUDE_DIRS ${SZIP_INCLUDE_DIR_GEN} ${SZIP_INCLUDE_DIR})
  endif ()
#  file (READ ${BINARY_DIR}/H5pubconf.h _h5pubconf_h_contents)
#  string (REGEX REPLACE ".*#define[ \t]+H5_VERSION[ \t]+\"([0-9A-Za-z.]+)\".*" "\\1" HDF5_VERSION_STRING ${_h5pubconf_h_contents})

  set (HDF5_INCLUDE_DIR_GEN "${BINARY_DIR}")
  set (HDF5_INCLUDE_DIR "${SOURCE_DIR}/src")
  set (HDF5_FOUND 1)

  set (HDF5_LIBRARIES ${HDF5_STATIC_LIBRARY})
  if (BUILD_SHARED_LIBS)
    set (HDF5_LIBRARIES ${HDF5_LIBRARIES} ${HDF5_SHARED_LIBRARY})
  endif ()

  message ("HDF5_LIBRARIES is ${HDF5_LIBRARIES}\n")
  set (HDF5_INCLUDE_DIRS ${HDF5_INCLUDE_DIR_GEN} ${HDF5_INCLUDE_DIR})
endmacro ()

#-------------------------------------------------------------------------------
macro (PACKAGE_HDF5_LIBRARY compress_type libtype)
  add_custom_target (HDF5-GenHeader-Copy ALL
      COMMAND ${CMAKE_COMMAND} -E copy_if_different ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/
      COMMENT "Copying ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h to ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/"
  )
  set (EXTERNAL_HEADER_LIST ${EXTERNAL_HEADER_LIST} ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/H5pubconf.h)
  if (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "GIT" OR ${compress_type} MATCHES "TGZ")
    add_dependencies (HDF5-GenHeader-Copy HDF5)
    install (
        FILES ${HDF5_INCLUDE_DIR_GEN}/libhdf5.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  else ()
    get_filename_component (HDF5SETTINGS "${HDF5_INCLUDE_DIR}/../lib" ABSOLUTE)
    install (
        FILES ${HDF5SETTINGS}/libhdf5.settings
        DESTINATION ${H4H5_INSTALL_LIB_DIR}
        COMPONENT libraries
    )
  endif ()
endmacro ()

macro (HDF5_SUPPORT link_hdf)
  set (CMAKE_MODULE_PATH ${HDF_RESOURCES_DIR} ${CMAKE_MODULE_PATH})
  set (CMAKE_POSITION_INDEPENDENT_CODE ON)

  if (NOT HDF5_HDF5_HEADER)
    if (NOT HDF5_USE_EXTERNAL)
      if (USE_SHARED_LIBS)
        set (FIND_HDF_COMPONENTS C HL shared static)
      else ()
        set (FIND_HDF_COMPONENTS C HL static)
      endif ()
      message (STATUS "HDF5 find comps: ${FIND_HDF_COMPONENTS}")
      set (SEARCH_PACKAGE_NAME ${HDF5_PACKAGE_NAME})

      find_package (HDF5 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
      message (STATUS "HDF5 C libs:${HDF5_FOUND} static:${HDF5_static_C_FOUND} and shared:${HDF5_shared_C_FOUND}")
      if (HDF5_FOUND)
        if (NOT TARGET hdf5::h5dump)
          add_executable (hdf5::h5dump IMPORTED)
        endif()
        if (NOT TARGET hdf5::h5diff)
          add_executable (hdf5::h5diff IMPORTED)
        endif()
        set (HDF5_DUMP_EXECUTABLE $<TARGET_FILE:hdf5::h5dump>)
        set (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:hdf5::h5diff>)
        if (NOT HDF5_static_C_FOUND AND NOT HDF5_shared_C_FOUND)
          #find library from non-dual-binary package
          set (FIND_HDF_COMPONENTS C HL)

          find_package (HDF5 NAMES ${SEARCH_PACKAGE_NAME} COMPONENTS ${FIND_HDF_COMPONENTS})
          message (STATUS "HDF5 libs:${HDF5_FOUND} C:${HDF5_C_FOUND}")
          set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_LIBRARIES})
          if (HDF5_BUILD_SHARED_LIBS)
            add_definitions (-DH5_BUILT_AS_DYNAMIC_LIB)
          else ()
            add_definitions (-DH5_BUILT_AS_STATIC_LIB)
          endif ()
          if (USE_SHARED_LIBS AND WIN32)
            set_property (TARGET hdf5::h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dumpdll")
            set_property (TARGET hdf5::h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diffdll")
          else ()
            set_property (TARGET hdf5::h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump")
            set_property (TARGET hdf5::h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff")
          endif ()
          set (HDF5_DUMP_EXECUTABLE $<TARGET_FILE:hdf5::h5dump>)
          set (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:hdf5::h5diff>)
        else ()
          if (USE_SHARED_LIBS)
            if(HDF5_shared_C_FOUND)
              set (HDF5_LINK_SHLIBS ${HDF5_LINK_SHLIBS} ${HDF5_C_SHARED_LIBRARY})
              set (HDF5_LIBRARY_PATH ${PACKAGE_PREFIX_DIR}/lib)
            endif ()
            if (HDF5_shared_HL_FOUND)
              set (HDF5_LINK_SHLIBS ${HDF5_LINK_SHLIBS} ${HDF5_HL_SHARED_LIBRARY})
            endif ()
            set_property (TARGET hdf5::h5dump-shared PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump-shared")
            set_property (TARGET hdf5::h5diff-shared PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff-shared")
          endif ()
          if (HDF5_static_C_FOUND)
            set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_C_STATIC_LIBRARY} ${HDF5_HL_STATIC_LIBRARY})
            set_property (TARGET hdf5::h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump")
            set_property (TARGET hdf5::h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff")
          endif ()
        endif ()
      else ()
        find_package (HDF5) # Legacy find
        #Legacy find_package does not set HDF5_BUILD_SHARED_LIBS, so we set it here
        if (USE_SHARED_LIBS AND EXISTS "${HDF5_LIBRARY_DIRS}/libhdf5.so")
          set (HDF5_BUILD_SHARED_LIBS 1)
        else ()
          set (HDF5_BUILD_SHARED_LIBS 0)
        endif ()
        set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_LIBRARIES})
        set (LINK_LIBS ${LINK_LIBS} ${HDF5_LIBRARIES})
        add_executable (hdf5::h5dump IMPORTED)
        add_executable (hdf5::h5diff IMPORTED)
        set_property (TARGET hdf5::h5dump PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5dump")
        set_property (TARGET hdf5::h5diff PROPERTY IMPORTED_LOCATION "${HDF5_TOOLS_DIR}/h5diff")
        set (HDF5_DUMP_EXECUTABLE $<TARGET_FILE:hdf5::h5dump>)
        set (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:hdf5::h5diff>)
      endif ()
    endif ()

    if (HDF5_FOUND)
      message (STATUS "HDF5 found: INC=${HDF5_INCLUDE_DIR}")
      if (USE_SHARED_LIBS AND NOT HDF5_BUILD_SHARED_LIBS)
        message (STATUS "HDF5 build type does match requested type")
      endif ()
      set (H4H5_HAVE_H5PUBCONF_H 1)
      set (H4H5_HAVE_HDF5 1)
      set (H4H5_HDF5_HEADER "h5pubconf.h")
      set (HDF5_INCLUDE_DIR_GEN ${HDF5_INCLUDE_DIR})
      set (HDF5_INCLUDE_DIRS ${HDF5_INCLUDE_DIR})
    else ()
      if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        EXTERNAL_HDF5_LIBRARY (${HDF_ALLOW_EXTERNAL_SUPPORT} ${LIB_TYPE})
        set (H4H5_HAVE_H5PUBCONF_H 1)
        set (H4H5_HAVE_HDF5 1)
        set (H4H5_HDF5_HEADER "h5pubconf.h")
        message (STATUS "HDF5 is built")
        if (USE_SHARED_LIBS)
            set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_SHARED_LIBRARY})
          add_definitions (-DH5_BUILT_AS_DYNAMIC_LIB)
        else ()
            set (HDF5_LINK_LIBS ${HDF5_LINK_LIBS} ${HDF5_STATIC_LIBRARY})
          add_definitions (-DH5_BUILT_AS_STATIC_LIB)
        endif ()
      else ()
        message (FATAL_ERROR " HDF5 is Required for H4H5Tools")
      endif ()
    endif ()
  else ()
    # This project is being called from within another and HDF5 is already configured
    set (H4H5_HAVE_H5PUBCONF_H 1)
    set (H4H5_HAVE_HDF5 1)
  endif ()

  message (STATUS "HDF5 link libs: ${HDF5_LINK_LIBS}")
  if (BUILD_SHARED_LIBS)
    message (STATUS "HDF5 shared link libs: ${HDF5_LINK_SHLIBS}")
  endif ()

  if (NOT HDF5_LIBRARY)
    set (HDF5_LIBRARY ${HDF5_LIBRARIES})
  endif ()
  INCLUDE_DIRECTORIES (${HDF5_INCLUDE_DIRS})
  set (HDF5_FOUND 1)
  set (HDF5_INCLUDE_DIR_GEN ${HDF5_INCLUDE_DIR_GEN})
  set (HDF5_VERSION_STRING ${HDF5_VERSION_STRING})
endmacro ()
