IF( NOT TARGET UI )
  MESSAGE( FATAL_ERROR "Include file UICPack.cmake require the target UI to exist. Please add UI/build/CMakeLists.txt as subdirectory first." )
ENDIF( NOT TARGET UI )

# Add all sources, they are added to a variable called UI_SRCS defined
# in the included file. All header files are added to a variable called
# UI_HEADERS.
INCLUDE( ${UI_SOURCE_DIR}/UISourceFiles.txt )

# If cpack should be configured.
IF( GENERATE_CPACK_PROJECT )
    set( CPACK_ALL_INSTALL_TYPES Full Developer )
    SET(CMAKE_MODULE_PATH ${UI_SOURCE_DIR}/modules )
    SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "UI. A cross platform toolkit that extends H3DAPI with haptic user interface widgets.")
    SET(CPACK_PACKAGE_VENDOR "SenseGraphics AB")
    SET(CPACK_PACKAGE_CONTACT "support@sensegraphics.com" )
    SET(CPACK_PACKAGE_DESCRIPTION_FILE "${UI_SOURCE_DIR}/../ReadMe")
    SET(CPACK_RESOURCE_FILE_LICENSE "${UI_SOURCE_DIR}/../LICENSE")
    SET(CPACK_INSTALL_CMAKE_PROJECTS "${CMAKE_CURRENT_BINARY_DIR};UI;ALL;/" )
    SET(CPACK_PACKAGE_INSTALL_DIRECTORY "H3D" )
    
    # File patterns to ignore, common for all operating systems.
  SET( UI_CPACK_IGNORE_PATTERNS /\\\\.svn/
                  \\\\.obj$
                  \\\\.ncb$
                  \\\\.log$
                  \\\\.suo$
                  \\\\.zip$
                  \\\\.dir/
                  \\\\.user$
                  \\\\.cv$
                  "/Debug(.)*/"
                  "/debug(.)*/"
                  /Release
                  /release
                  /linux
                  /build/win32/
                  /build/vc9
                  /build/vc8
                  /build/vc7
                  /osx
                  /doxygen_log\\\\.txt$
                  "~$" )
                  
    SET(CPACK_PACKAGE_VERSION_MAJOR ${UI_MAJOR_VERSION})
    SET(CPACK_PACKAGE_VERSION_MINOR ${UI_MINOR_VERSION})
    SET(CPACK_PACKAGE_VERSION_PATCH ${UI_BUILD_VERSION})
    
    IF( WIN32 AND NOT UNIX )
    SET(CPACK_NSIS_INSTALL_ROOT "C:" )
    SET(CPACK_NSIS_ENABLE_UNINSTALL_BEFORE_INSTALL "ON" )  
    SET( CPACK_PACKAGE_START_MENU_NAME "UI" )
      
    # Extra links to start menu if values are "ON"
    SET( CPACK_ADD_UIDOC_LINKS "ON" )
    SET( CPACK_ADD_H3DLOAD_DEMOS_LINKS "ON" )
    SET( CPACK_ADD_UI_DEMOS_LINKS "ON" )
  
    # External binary directory to add to path.
    SET( CPACK_EXTERNAL_BIN "bin32" )
    SET( CPACK_H3D_64_BIT "FALSE" )
    IF( CMAKE_SIZEOF_VOID_P EQUAL 8 )
      SET( CPACK_EXTERNAL_BIN "bin64" )
      SET( CPACK_H3D_64_BIT "TRUE" )
    ENDIF( CMAKE_SIZEOF_VOID_P EQUAL 8 )
    
    # Do not modify path.
    SET( CPACK_NSIS_MODIFY_PATH "ON" )

    SET(CPACK_IGNORE_FILES ${UI_CPACK_IGNORE_PATTERNS} )
    #SET(CPACK_INSTALLED_DIRECTORIES "${UI_SOURCE_DIR}/../../UI;." )
  ELSE(WIN32 AND NOT UNIX)
    SET(CPACK_SOURCE_IGNORE_FILES ${UI_CPACK_IGNORE_PATTERNS} )
    SET(CPACK_SOURCE_INSTALLED_DIRECTORIES "${UI_SOURCE_DIR}/../../UI;UI" )
  ENDIF(WIN32 AND NOT UNIX)
  
  INSTALL( FILES ${UI_SOURCE_DIR}/../changelog
                 ${UI_SOURCE_DIR}/../LICENSE
                 ${UI_SOURCE_DIR}/../ReadMe
      DESTINATION UI
      COMPONENT UI_cpack_sources )
  
    # Install src files.
  INSTALL( FILES ${UI_SRCS}
      DESTINATION UI/src
      COMPONENT UI_cpack_sources )
  
  # Install header files
  INSTALL( FILES ${UI_HEADERS}
      DESTINATION UI/include/H3D/UI
      COMPONENT UI_cpack_headers )

  # UI.cmake that goes to headers is not needed unless sources is required.
  INSTALL( FILES ${UI_SOURCE_DIR}/../include/H3D/UI/UI.cmake
      DESTINATION UI/include/H3D/UI
      COMPONENT UI_cpack_sources )
  
  INSTALL( DIRECTORY ${UI_SOURCE_DIR}/../x3d
      DESTINATION UI
      COMPONENT UI_cpack_sources)
  
  INSTALL( FILES  ${UI_SOURCE_DIR}/CMakeLists.txt
          ${UI_SOURCE_DIR}/UI.rc.cmake
          ${UI_SOURCE_DIR}/UICPack.cmake
          ${UI_SOURCE_DIR}/UISourceFiles.txt
          ${UI_SOURCE_DIR}/UpdateResourceFile.exe
      DESTINATION UI/build
      COMPONENT UI_cpack_sources)
  
  INSTALL( DIRECTORY ${UI_SOURCE_DIR}/modules
      DESTINATION UI/build
      COMPONENT UI_cpack_sources)
  
  IF( ( EXISTS ${UI_SOURCE_DIR}/../doc/UI.tag ) AND ( EXISTS ${UI_SOURCE_DIR}/../doc/html ) )
    # Install documentation
    INSTALL( FILES ${UI_SOURCE_DIR}/../doc/UI.tag
             DESTINATION UI/doc
             COMPONENT UI_cpack_headers)
    INSTALL( DIRECTORY ${UI_SOURCE_DIR}/../doc/html
             DESTINATION UI/doc
             COMPONENT UI_cpack_headers)
  ENDIF( ( EXISTS ${UI_SOURCE_DIR}/../doc/UI.tag ) AND ( EXISTS ${UI_SOURCE_DIR}/../doc/html ) )
  
  # setting names and dependencies between components and also grouping them.
  set(CPACK_COMPONENT_UI_CPACK_RUNTIME_DISPLAY_NAME "Runtime")
  set(CPACK_COMPONENT_UI_CPACK_RUNTIME_DESCRIPTION "The runtime libraries (dlls) for UI.")
    set(CPACK_COMPONENT_UI_CPACK_RUNTIME_DEPENDS H3DAPI_cpack_runtime )
  set(CPACK_COMPONENT_UI_CPACK_RUNTIME_GROUP "UI_cpack_group")
  set(CPACK_COMPONENT_UI_CPACK_RUNTIME_INSTALL_TYPES Developer Full)
  
  set(CPACK_COMPONENT_UI_CPACK_LIBRARIES_DISPLAY_NAME "Libraries")
  set(CPACK_COMPONENT_UI_CPACK_LIBRARIES_DESCRIPTION "UI libraries")
  set(CPACK_COMPONENT_UI_CPACK_LIBRARIES_DEPENDS H3DAPI_cpack_libraries UI_cpack_headers )
  set(CPACK_COMPONENT_UI_CPACK_LIBRARIES_GROUP "UI_cpack_group")
  set(CPACK_COMPONENT_UI_CPACK_LIBRARIES_INSTALL_TYPES Developer Full)
  
  set(CPACK_COMPONENT_UI_CPACK_HEADERS_DISPLAY_NAME "C++ Headers")
  set(CPACK_COMPONENT_UI_CPACK_HEADERS_DESCRIPTION "UI C++ Header, need to build against UI")
  set(CPACK_COMPONENT_UI_CPACK_HEADERS_DEPENDS H3DAPI_cpack_headers UI_cpack_libraries )
  set(CPACK_COMPONENT_UI_CPACK_HEADERS_GROUP "UI_cpack_group")
  set(CPACK_COMPONENT_UI_CPACK_HEADERS_INSTALL_TYPES Developer Full)
  
  set(CPACK_COMPONENT_UI_CPACK_SOURCES_DISPLAY_NAME "C++ Source")
  set(CPACK_COMPONENT_UI_CPACK_SOURCES_DESCRIPTION "Everything needed to build UI")
  set(CPACK_COMPONENT_UI_CPACK_SOURCES_DEPENDS H3DAPI_cpack_sources UI_cpack_headers )
  set(CPACK_COMPONENT_UI_CPACK_SOURCES_GROUP "UI_cpack_group")
  set(CPACK_COMPONENT_UI_CPACK_SOURCES_INSTALL_TYPES Full)
  
  set(CPACK_COMPONENT_GROUP_UI_CPACK_GROUP_DISPLAY_NAME "UI")
  set(CPACK_COMPONENT_GROUP_UI_CPACK_GROUP_DESCRIPTION "UI contains haptic user interface nodes. E.g. 3D buttons and sliders which can be touched by a haptics device.")
  
  # Add a cache variable H3D_cmake_runtime_path to point to cmake binary.
  SET (H3D_cmake_runtime_path_default "")
  IF( NOT DEFINED H3D_cmake_runtime_path )
    IF( WIN32 AND NOT UNIX )
      SET (VERSION_CMAKES "4.0" "3.9" "3.8" "3.7" "3.6" "3.5" "3.4" "3.3" "3.2" "3.1" "3.0" "2.9" "2.8" "2.7" "2.6")
      foreach (version_cmake ${VERSION_CMAKES} )
        IF (EXISTS "C:/Program Files/CMake ${version_cmake}/bin/cmake.exe")
          SET( H3D_cmake_runtime_path_default "C:/Program Files/CMake ${version_cmake}/bin/cmake.exe" )
          break()
        ENDIF (EXISTS "C:/Program Files/CMake ${version_cmake}/bin/cmake.exe")
        
        IF (EXISTS "C:/Program Files (x86)/CMake ${version_cmake}/bin/cmake.exe")
          SET( H3D_cmake_runtime_path_default "C:/Program Files (x86)/CMake ${version_cmake}/bin/cmake.exe" )
          break()
        ENDIF (EXISTS "C:/Program Files (x86)/CMake ${version_cmake}/bin/cmake.exe")
        
        IF ( EXISTS "C:/Program/CMake ${version_cmake}/bin/cmake.exe")
          SET( H3D_cmake_runtime_path_default "C:/Program/CMake ${version_cmake}/bin/cmake.exe" )
          break()
        ENDIF ( EXISTS "C:/Program/CMake ${version_cmake}/bin/cmake.exe")
      endforeach (version_cmake )
    ELSE( WIN32 AND NOT UNIX )
      SET( H3D_cmake_runtime_path_default "cmake" )
    ENDIF( WIN32 AND NOT UNIX )
    SET( H3D_cmake_runtime_path ${H3D_cmake_runtime_path_default} CACHE FILEPATH "The path to the cmake runtime." )
    MARK_AS_ADVANCED(H3D_cmake_runtime_path)
  ENDIF( NOT DEFINED H3D_cmake_runtime_path )
  
  IF(UNIX)
    SET(CPACK_SOURCE_INSTALLED_DIRECTORIES "${UI_SOURCE_DIR}/..;/" )  
    SET(CPACK_SOURCE_GENERATOR TGZ ZIP ) 
    SET(CPACK_SOURCE_PACKAGE_FILE_NAME "h3dui-${UI_MAJOR_VERSION}.${UI_MINOR_VERSION}.${UI_BUILD_VERSION}") 


    SET( UI_CPACK_IGNORE_PATTERNS ${UI_CPACK_IGNORE_PATTERNS}
            "/CVS/;/.svn/;/.bzr/;/.hg/;/.git.*/;.swp$;.#;/#;~$")
    SET(CPACK_SOURCE_IGNORE_FILES ${UI_CPACK_IGNORE_PATTERNS} )
  ENDIF( UNIX )


  IF( H3D_cmake_runtime_path )
    SET( INSTALL_RUNTIME_AND_LIBRARIES_ONLY_POST_BUILD ${INSTALL_RUNTIME_AND_LIBRARIES_ONLY_POST_BUILD}
                                                       COMMAND ${H3D_cmake_runtime_path} 
                                                       ARGS -DBUILD_TYPE=$(Configuration) -DCOMPONENT=UI_cpack_runtime -P cmake_install.cmake 
                                                       COMMAND ${H3D_cmake_runtime_path} 
                                                       ARGS -DBUILD_TYPE=$(Configuration) -DCOMPONENT=UI_cpack_libraries -P cmake_install.cmake)
      
    IF (NOT H3D_USE_DEPENDENCIES_ONLY)
      ADD_CUSTOM_COMMAND( OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/DummyFile
                          COMMAND echo )
      ADD_CUSTOM_TARGET( INSTALL_RUNTIME_AND_LIBRARIES_ONLY
                         DEPENDS ${CMAKE_CURRENT_BINARY_DIR}/DummyFile )
      
      ADD_CUSTOM_COMMAND( TARGET INSTALL_RUNTIME_AND_LIBRARIES_ONLY
                          POST_BUILD
                          ${INSTALL_RUNTIME_AND_LIBRARIES_ONLY_POST_BUILD} )
      ADD_DEPENDENCIES( INSTALL_RUNTIME_AND_LIBRARIES_ONLY UI ${INSTALL_RUNTIME_AND_LIBRARIES_ONLY_DEPENDENCIES} )
    ENDIF (NOT H3D_USE_DEPENDENCIES_ONLY)
  ELSE( H3D_cmake_runtime_path )
    MESSAGE (STATUS "H3D_cmake_runtime_path is not set, please set it to continue")
  ENDIF( H3D_cmake_runtime_path )
  
  IF( NOT H3D_USE_DEPENDENCIES_ONLY)
    INCLUDE(CPack)
  ENDIF( NOT H3D_USE_DEPENDENCIES_ONLY)
ENDIF( GENERATE_CPACK_PROJECT )