//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2014, SenseGraphics AB
//
//    This file is part of MedX3D.
//
//    MedX3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    MedX3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with MedX3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file MedX3DDemoComposedVolumeStyleOptions.h
/// \brief Header file for MedX3DDemoComposedVolumeStyleOptions. Subclass of
/// ComposedVolumeStyleOptions, which is generated by wxFormBuilder.
///
//
//
//////////////////////////////////////////////////////////////////////////////
#ifndef __MedX3DDemoComposedVolumeStyleOptions__
#define __MedX3DDemoComposedVolumeStyleOptions__

#include <H3D/MedX3D/ComposedVolumeStyle.h>

#include "MedX3DDemo.h"

/** Implementing ComposedVolumeStyleOptions */
class MedX3DDemoComposedVolumeStyleOptions : public ComposedVolumeStyleOptions
{

  // The node we are controlling the values of.
  H3DUtil::AutoRef< H3D::ComposedVolumeStyle > composed_style;
  
  // The panels with options for each render style in the composed style.
  vector< wxPanel * > style_options; 
public:
  /** Constructor */
  MedX3DDemoComposedVolumeStyleOptions( wxWindow* parent,
                                        H3D::ComposedVolumeStyle * style );
                                        
  // Add the style to the composable node adding a gui as well. The 
  // position is the position to put it in. If -1 it is added to the end.
  void insertStyle( H3D::X3DComposableVolumeRenderStyleNode *s, 
                    unsigned int pos = -1 );
                    
  // Remove the style option panel given. 
  void removeStyleOption( wxPanel *s );                  
  
  // Get the position of the panel given in the style_options vector. 
  // -1 if it does not exist.
  int getStyleOptionPosition( wxPanel *p );
};

#endif // __MedX3DDemoComposedVolumeStyleOptions__
