# (c) SenseGraphics 2010. Written for MOOG
# Convert from IndexedFaceSet to IndexedTriangleSet for those IndexedFaceSets
# that are generated by other programs and have only 3-vertex polygons.
# The program will not work if the IndexedFaceSet contains a polygon with more than
# 3 vertices.
# Syntax: h3dload ifs2its.x3d [source_file] [destination_file]
# Demo: h3dload ifs2its.x3d face.x3d face_converted.x3d

from H3DInterface import *
import re
from ifs2itslib import ifs2its
import sys

def replacecallback(r):
#  try:
  IFS = createX3DNodeFromString(r.group(0))[0]
  print 'Found \"', IFS.getName(), '\". Converting...'
  its = ifs2its(IFS)
  print "Conversion done."
  return its
#  except:
#    return r.group(0)


# Arguments check
if len(sys.argv) < 4:
  print 'Error. Not enough argument.\n'
  print 'Syntax: h3dload ifs2its.x3d [source_file] [destination_file]\n'
  sys.exit()

print 'Opening file %s' % sys.argv[2]
s = open(sys.argv[2], 'r').read()

# match face_deformable.IFS and convert
print 'Looking for IndexedFaceSets...'
reg = re.compile(r'<IndexedFaceSet(.*?)</IndexedFaceSet>', re.DOTALL)
s = reg.sub(replacecallback, s)

#print "Result:"
#print s

print 'Writing to file %s' % sys.argv[3]
open(sys.argv[3], 'w').write(s)
print 'Done. Exiting...'
sys.exit()
