/*
 modinfo - get title from various module formats
 ----------------------------------------------------------------
 Copyright (C) 2001 by Dirk Jagdmann <doj@cubic.org>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void P(char *s)
{
  int i=strlen(s)-1;
  while(i>0 && s[i-1]==32)
    s[--i]=0;
  while(i>=0)
    {
      if((unsigned char)s[i]>127 || (unsigned char)s[i]<32)
        s[i]='.';
      i--;
    }
  printf("%s\n", s);
}

bool m669(FILE *f)
{
  char buf[109];

  rewind(f);
  if(fgets(buf, 3, f) == NULL)
    exit(1);

  if(strncmp(buf, "if", 2))
    if(strncmp(buf, "JN", 2))
      return false;
  
  if(fseek(f, 2, SEEK_SET) < 0)
    exit(1);
  if(fgets(buf, 108, f) == NULL)
    exit(1);
  
  buf[108]=0;
  P(buf);

  return true;
}

bool MOD(FILE *f)
{
  const char *sig[] = {
    "4CHN",
    "6CHN",
    "8CHN",
    "CD81",
    "FLT4",
    "M!K!",
    "M.K.",
    "OCTA",
  };

  char buf[21];

  if(fseek(f, 1080, SEEK_SET) < 0)
    exit(1);
  if(fgets(buf, 5, f) == NULL)
    exit(1);
  buf[4]=0;

  bool flag=false;
  for(unsigned int i=0; i<sizeof(sig)/sizeof(char*); i++)
    if(!strncmp(buf, sig[i], 4))
      {
       flag=true;
       break;
      }
  if(!flag)
    return false;

  rewind(f);
  if(fgets(buf, 20, f) == NULL)
    exit(1);
  
  buf[20]=0;
  P(buf);

  return true;
}

bool XM(FILE *f)
{
  char buf[21];
  rewind(f);
  if(fgets(buf, 18, f) == NULL)
    exit(1);

  if(strncmp(buf, "Extended Module: ", 17))
    return false;

  if(fseek(f, 17, SEEK_SET) < 0)
    exit(1);
  if(fgets(buf, 20, f) == NULL)
    exit(1);

  buf[20]=0;
  P(buf);

  return true;
}

bool MTM(FILE *f)
{
  char buf[21];
  rewind(f);
  if(fgets(buf, 4, f) == NULL)
    exit(1);

  if(strncmp(buf, "MTM", 3))
    return false;

  if(fseek(f, 4, SEEK_SET) < 0)
    exit(1);
  if(fgets(buf, 20, f) == NULL)
    exit(1);

  buf[20]=0;
  P(buf);

  return true;
}

bool PSID(FILE *f)
{
  char buf[33];
  rewind(f);
  if(fgets(buf, 5, f) == NULL)
    exit(1);

  if(strncmp(buf, "PSID", 4))
    if(strncmp(buf, "RSID", 4))
      return false;

  if(fseek(f, 0x16, SEEK_SET) < 0)
    exit(1);
  for(int i=1; i<=3; i++)
    {
      if(fgets(buf, 33, f) == NULL)
        exit(1);
      printf("%s ", buf);
    }
  printf("\n");
  return true;
}

bool IT(FILE *f)
{
  char buf[27];
  rewind(f);
  if(fgets(buf, 5, f) == NULL)
    exit(1);

  if(strncmp(buf, "IMPM", 4))
    return false;

  if(fseek(f, 4, SEEK_SET) < 0)
    exit(1);
  if(fgets(buf, 26, f) == NULL)
    exit(1);

  buf[26]=0;
  P(buf);

  return true;
}

bool S3M(FILE *f)
{
  rewind(f);

  char buf[0x20];
  fread(buf, 0x20, 1, f);
  if(buf[0x1C]==0x1A && buf[0x1D]==16)
    {
      P(buf);
      return true;
    }

  return false;
}

static void help()
{
  fprintf(stderr,
          "modinfo: show titles from modules\n"
          "usage:   modinfo filename\n"
          "currently the following file types are recognized:\n"
          "669, it, mod, mtm, psid, s3m, xm\n"
          "comments go to Dirk Jagdmann <doj@cubic.org> http://llg.cubic.org\n"
          );
  exit(1);
}

int main(int argc, char **argv)
{
  if(argc<2)
    help();

  if(!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help"))
    help();

  FILE *f=fopen(argv[1], "r");
  if(f==0)
    {
      fprintf(stderr, "could not open %s: %s\n", argv[1],
strerror(errno));
      return 1;
    }

  if(IT(f));
  else if(PSID(f));
  else if(MTM(f));
  else if(m669(f));
  else if(XM(f));
  else if(MOD(f));
  else if(S3M(f));
  else fprintf(stderr, "not recognized\n");

  fclose(f);
  return 0;
}
