/* -*- Mode: C; c-basic-offset: 4 -*- */
/* GTK DBF Editor -- a simple dbf editor built with GTK+
 * Copyright (C) 2001-2011 Steffen Macke
 *
 * dbf.h: dbf editing functionality
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include "shapefil.h"

#define MAX_PATH 255

extern gboolean application_is_closing;
extern GtkWidget *dbf_editor_window;
extern GladeXML *glade_xml;
extern DBFHandle dbfh_file;
extern int n_current_record;
extern gchar *dbf_encoding;

void dbf_create_widgets (gchar * filename, GtkBox * vbox_fields);
void create_dbf_file_selection (GtkBox * vbox_fields);
void dbf_remove_widgets (GtkBox * vbox_fields);

void dbf_display_record (GtkWidget * dbf_editor_window, gint n_record);
void dbf_display_last_record (GtkWidget * dbf_editor_window);
void dbf_display_next_record (GtkWidget * dbf_editor_window);
void dbf_display_previous_record (GtkWidget * dbf_editor_window);
void dbf_add_record (GtkWidget * dbf_editor_window);

/* fill DBFHandle */
gboolean dbf_open_file (gchar * filename);

/* load file, fill widgets */
gboolean dbf_load_file (gchar * filename);
void dbf_close_file ();
gboolean dbf_can_close ();
void dbf_save_file ();
int dbf_get_field_number (char *field_name);



G_MODULE_EXPORT void
on_entry_changed (GtkEditable * editable, gpointer user_data);

G_MODULE_EXPORT gboolean
on_entry_focus_out_event (GtkWidget * widget,
			  GdkEventFocus * event, gpointer user_data);

void window_display_status_message (GtkWidget * dbf_editor_window,
				    gchar * message);

void set_dbf_has_changed ();
