/*
 * nodoka_rc_style.h
 * This file is part of gtk-nodoka-engine
 *
 * Copyright (C) 2007, 2008 - Martin Sourada, Daniel Geiger
 *
 * gtk-nodoka-engine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtk-nodoka-engine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gtk-nodoka-engine; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */ 

#include <gtk/gtk.h>

typedef struct _NodokaRcStyle NodokaRcStyle;
typedef struct _NodokaRcStyleClass NodokaRcStyleClass;

G_GNUC_INTERNAL extern GType nodoka_type_rc_style;

#define NODOKA_TYPE_RC_STYLE              nodoka_type_rc_style
#define NODOKA_RC_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), NODOKA_TYPE_RC_STYLE, NodokaRcStyle))
#define NODOKA_RC_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), NODOKA_TYPE_RC_STYLE, NodokaRcStyleClass))
#define NODOKA_IS_RC_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), NODOKA_TYPE_RC_STYLE))
#define NODOKA_IS_RC_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), NODOKA_TYPE_RC_STYLE))
#define NODOKA_RC_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), NODOKA_TYPE_RC_STYLE, NodokaRcStyleClass))

typedef enum
{
	NDK_FLAG_CONTRAST = 1 << 0,
	NDK_FLAG_HILIGHT_RATIO = 1 << 1,
	NDK_FLAG_ROUNDNESS = 1 << 2,
	NDK_FLAG_MENUBARSTYLE = 1 << 3,
	NDK_FLAG_TOOLBARSTYLE = 1 << 4,
	NDK_FLAG_LISTVIEWHEADERSTYLE = 1 << 5,
	NDK_FLAG_LISTVIEWSTYLE = 1 << 6,
	NDK_FLAG_SCROLLBARSTYLE = 1 << 7,
	NDK_FLAG_SCROLLBAR_COLOR = 1 << 8,
	NDK_FLAG_ANIMATION = 1 << 9,
	NDK_FLAG_GRADIENTS = 1 << 10,
	NDK_FLAG_STRIPES = 1 << 11,
	NDK_FLAG_BULLETCOLOR = 1 << 12,
	NDK_FLAG_FOCUSINNER = 1 << 13,
	NDK_FLAG_FOCUSFILL = 1 << 14,
} NodokaRcFlags;

struct _NodokaRcStyle
{
	GtkRcStyle parent_instance;

	NodokaRcFlags flags;

	GdkColor scrollbar_color;
	gboolean has_scrollbar_color;
	double contrast;
	double hilight_ratio;
	guint8 menubarstyle;
	guint8 toolbarstyle;
	guint8 listviewheaderstyle;
	guint8 listviewstyle;
	guint8 scrollbarstyle;
	guint8 roundness;
	gboolean animation;
	gboolean gradients;
	gboolean stripes;
	GdkColor bullet_color;
	gboolean focus_inner;
	gboolean focus_fill;
};

struct _NodokaRcStyleClass
{
	GtkRcStyleClass parent_class;
};

G_GNUC_INTERNAL void nodoka_rc_style_register_type (GTypeModule * module);
