/*
 * nodoka_draw.h
 * This file is part of gtk-nodoka-engine
 *
 * Copyright (C) 2007, 2008 - Martin Sourada, Daniel Geiger
 *
 * gtk-nodoka-engine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtk-nodoka-engine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gtk-nodoka-engine; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */ 

#ifndef NODOKA_DRAW_H
#define NODOKA_DRAW_H

#include "nodoka_types.h"

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <cairo.h>

G_GNUC_INTERNAL void nodoka_draw_button (cairo_t * cr,
										 const NodokaColors * colors,
										 const WidgetParameters * widget,
										 const ButtonParameters * button,
										 int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_scale_trough (cairo_t * cr,
											   const NodokaColors * colors,
											   const WidgetParameters * widget,
											   const SliderParameters * slider,
											   int x, int y, int width,
											   int height);

G_GNUC_INTERNAL void nodoka_draw_scale_slider (cairo_t * cr,
											   const NodokaColors * colors,
											   const WidgetParameters * widget,
											   const SliderParameters * slider,
											   int x, int y, int width,
											   int height);

G_GNUC_INTERNAL void nodoka_draw_progressbar_trough (cairo_t * cr,
													 const NodokaColors *
													 colors,
													 const WidgetParameters *
													 widget,
												    	 const ProgressBarParameters *
												   	 progressbar, int x, int y,
													 int width, int height);


G_GNUC_INTERNAL void nodoka_draw_progressbar_fill (cairo_t * cr,
											const NodokaColors * colors,
											const WidgetParameters * widget,
											const ProgressBarParameters * progressbar, 
											int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_entry_progress (cairo_t * cr,
											const NodokaColors * colors,
											const WidgetParameters * widget,
											const EntryProgressParameters * progress, 
											int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_slider_button (cairo_t * cr,
												const NodokaColors * colors,
												const WidgetParameters * widget,
												const SliderParameters * slider,
												int x, int y, int width,
												int height);

G_GNUC_INTERNAL void nodoka_draw_entry (cairo_t * cr,
										const NodokaColors * colors,
										const WidgetParameters * widget,
										const EntryParameters * entry,
										int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_optionmenu (cairo_t * cr,
										const NodokaColors * colors,
										const WidgetParameters * widget,
										const OptionMenuParameters * optionmenu, 
										int x, int y,
										int width, int height);

G_GNUC_INTERNAL void nodoka_draw_inset (cairo_t * cr,
										int width, int height,
										double radius, uint8 corners);

G_GNUC_INTERNAL void nodoka_draw_menubar (cairo_t * cr,
										  const NodokaColors * colors,
										  const WidgetParameters * widget,
										  const MenuBarParameters * menubar,
										  int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_tab (cairo_t * cr,
									  const NodokaColors * colors,
									  const WidgetParameters * widget,
									  const TabParameters * tab,
									  int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_frame (cairo_t * cr,
										const NodokaColors * colors,
										const WidgetParameters * widget,
										const FrameParameters * frame,
										int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_separator (cairo_t * cr,
											const NodokaColors * colors,
											const WidgetParameters * widget,
											const SeparatorParameters * separator, 
											int x, int y, int width,
											int height);

G_GNUC_INTERNAL void nodoka_draw_combo_separator (cairo_t * cr,
												  const NodokaColors * colors,
												  const WidgetParameters *
												  widget, int x, int y,
												  int width, int height);

G_GNUC_INTERNAL void nodoka_draw_list_view_header (cairo_t * cr,
												   const NodokaColors * colors,
												   const WidgetParameters *
												   widget,
												   const
												   ListViewHeaderParameters *
												   header, int x, int y,
												   int width, int height);

G_GNUC_INTERNAL void nodoka_draw_toolbar (cairo_t * cr,
										  const NodokaColors * colors,
										  const WidgetParameters * widget,
										  const ToolbarParameters * toolbar,
										  int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_menuitem (cairo_t * cr,
										   const NodokaColors * colors,
										   const WidgetParameters * widget,
										   int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_scrollbar_stepper (cairo_t * cr,
													const NodokaColors * colors,
													const WidgetParameters *
													widget,
													const ScrollBarParameters *
													scrollbar,
													const
													ScrollBarStepperParameters *
													stepper, int x, int y,
													int width, int height);

G_GNUC_INTERNAL void nodoka_draw_scrollbar_slider (cairo_t * cr,
												   const NodokaColors * colors,
												   const WidgetParameters *
												   widget,
												   const ScrollBarParameters *
												   scrollbar, int x, int y,
												   int width, int height);

G_GNUC_INTERNAL void nodoka_draw_scrollbar_trough (cairo_t * cr,
												   const NodokaColors * colors,
												   const WidgetParameters *
												   widget,
												   const ScrollBarParameters *
												   scrollbar, int x, int y,
												   int width, int height);

G_GNUC_INTERNAL void nodoka_draw_selected_cell (cairo_t * cr,
												const NodokaColors * colors,
												const WidgetParameters * widget,
												int x, int y, int width,
												int height);

G_GNUC_INTERNAL void nodoka_draw_statusbar (cairo_t * cr,
											const NodokaColors * colors,
											const WidgetParameters * widget,
											int x, int y, int width,
											int height);

G_GNUC_INTERNAL void nodoka_draw_menu_frame (cairo_t * cr,
											 const NodokaColors * colors,
											 const WidgetParameters * widget,
											 int x, int y, int width,
											 int height);

G_GNUC_INTERNAL void nodoka_draw_handle (cairo_t * cr,
										 const NodokaColors * colors,
										 const WidgetParameters * widget,
										 const HandleParameters * handle,
										 int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_arrow (cairo_t * cr,
										const NodokaColors * colors,
										const WidgetParameters * widget,
										const ArrowParameters * arrow,
										int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_checkbutton (cairo_t * cr,
											  const NodokaColors * colors,
											  const WidgetParameters * widget,
											  const OptionParameters * status,
											  int x, int y, int width,
											  int height, double trans);

G_GNUC_INTERNAL void nodoka_draw_radiobutton (cairo_t * cr,
											  const NodokaColors * colors,
											  const WidgetParameters * widget,
											  const OptionParameters * status,
											  int x, int y, int width,
											  int height, double trans);

G_GNUC_INTERNAL void nodoka_draw_resize_grip (cairo_t * cr,
											  const NodokaColors * colors,
											  const WidgetParameters * widget,
											  const ResizeGripParameters * grip,
											  int x, int y, int width,
											  int height);

G_GNUC_INTERNAL void nodoka_draw_focus (cairo_t * cr,
										 const NodokaColors * colors,
										 const WidgetParameters * widget,
										 const FocusParameters * focus,
										 int x, int y, int width, int height);

G_GNUC_INTERNAL void nodoka_draw_simple_focus (cairo_t * cr,
										 const NodokaColors * colors,
										 const WidgetParameters * widget,
										 const FocusParameters * focus,
										 int x, int y, int width, int height);


G_GNUC_INTERNAL void nodoka_draw_tooltip (cairo_t * cr, 
										const NodokaColors * colors,
										const WidgetParameters * widget,
										int x, int y, int width, int height);


#endif /* NODOKA_DRAW_H */
