# gtk-fortran source files

In the following filenames, the ? character is the GTK major version.

## gtk-fortran core

- gtk-fortran.f90: a gtk-?-fortran command to show information about the library.
- *-auto.f90 and *-auto.in: these files contains the Fortran interfaces to the C functions of the various GTK libraries. They are generated by the cfwrapper/cfwrapper.py script.
- gtk-fortran-index.csv: list of all the interfaces generated in the *-auto.f90 files, with the name of the library, the name of the function, its status (deprecated or not), the names of the .f90 file and the .h file, the C prototype of the function and the Fortran definition. Generated by the cfwrapper/cfwrapper.py script.
- gtk.f90: it contains the gtk module, which will be used by every GTK program. The g_signal_connect() and gtk_init() subroutines are defined here. The gtkenums-auto.* and gtk-auto.* files are automatically included.
- gtk-sup.f90: this module contains some supplementary material useful for writing GTK programs in Fortran.
- gtk-fortran.pc.in: template used by CMake to generate the gtk-?-fortran.pc pkg-config file.
- extract_events.pl: extracts the structure definitions for GDK events from the GDK header files.
  - gdkevents-auto.f90: Fortran GDK events structures generated by extract_events.pl.
- extract_enums.pl: find the enumerator constants in a fortran source file and write them out to a simple list.
  - gtk-enumerators.lis: list generated by extract_enums.pl.

## High Level interface

- gtk_hl.f90: the gtk_hl main Fortran module, which includes the other gtk-hl-\* modules:
  - gtk-\*hl-\*.f90
- gdk-pixbuf-hl.f90: some routines to facilitate the use of GDK pixbufs from Fortran.

## Various scripts

- show_versions.sh: shows the versions of the main tools and libraries used in gtk-fortran.
- screenshots.sh: automatically launches each gtk-fortran example and take a PNG screenshot using the scrot command. A suffix is added to the name of the example.
- build.sh: a short script to build gtk-fortran using CMake from the src/ directory.
- alt_build_test.sh: an alternative simple build system, using the directory ../build/byscript and finally launching one by one the examples for testing.
- usemodules.pl: scan a Fortran source file or files for GTK (etc.) routines. This is a somewhat 'tighter' replacement for usemodules.py.
  - gtk-modules.txt: the USE statements to copy/paste in your programs, generated by usemodules.pl.
  - gtk-fortran-modscan.man: man page of the gtk-?-fortran-modscan command (usemodules.pl).
- usemodules.py: this program scan all the Fortran files in the given directory and subdirectories to generate USE statements you can paste in your gtk-fortran programs. It also print warnings if you use deprecated GTK functions, and finally displays all the GTK functions used in a directory. It generates:
  - usemodules.txt: the USE statements to copy/paste in your programs, generated by usemodules.py.
- tools.py: that module contains functions used by usemodules.py and cfwrapper/cfwrapper.py.

